/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.cloudfoundry.client.lib.AdditionalRestOperations;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.domain.InstanceStats;
import org.cloudfoundry.client.lib.util.CloudEntityResourceMapper;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestTemplate;

public class AdditionalRestOperationsImpl
implements AdditionalRestOperations {
    private CloudEntityResourceMapper resourceMapper = new CloudEntityResourceMapper();
    private final RestTemplate restTemplate;
    private final CloudSpace sessionSpace;
    private final URL cloudControllerUrl;

    public AdditionalRestOperationsImpl(RestTemplate restTemplate, CloudSpace sessionSpace, URL cloudControllerUrl) {
        this.restTemplate = restTemplate;
        this.sessionSpace = sessionSpace;
        this.cloudControllerUrl = cloudControllerUrl;
    }

    @Override
    public List<CloudApplication> getBasicApplications() {
        ArrayList<CloudApplication> apps = new ArrayList<CloudApplication>();
        if (this.sessionSpace != null) {
            HashMap<String, Object> urlVars = new HashMap<String, Object>();
            String urlPath = "/v2";
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = urlPath + "/spaces/{space}";
            urlPath = urlPath + "/apps?inline-relations-depth=1";
            List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
            for (Map<String, Object> resource : resourceList) {
                CloudApplication app = this.mapBasicCloudApplication(resource);
                if (app == null) continue;
                apps.add(app);
            }
        }
        return apps;
    }

    @Override
    public CloudApplication getApplicationWithoutInstances(String appName) {
        Map<String, Object> resource = this.getBasicApplicationResource(appName);
        if (resource == null) {
            throw new CloudFoundryException(HttpStatus.NOT_FOUND, "Not Found", "Application not found");
        }
        this.fillApplicationServiceBindings(resource);
        CloudApplication app = this.mapBasicCloudApplication(resource);
        this.fillApplicationUris(app);
        return app;
    }

    @Override
    public CloudApplication getBasicApplication(String appName) {
        return this.mapBasicCloudApplication(appName);
    }

    @Override
    public void stopApplicationUsingBasicApp(String appName) {
        CloudApplication app = this.mapBasicCloudApplication(appName);
        if (app.getState() != CloudApplication.AppState.STOPPED) {
            HashMap<String, CloudApplication.AppState> appRequest = new HashMap<String, CloudApplication.AppState>();
            appRequest.put("state", CloudApplication.AppState.STOPPED);
            this.restTemplate.put(this.getUrl("/v2/apps/{guid}"), appRequest, new Object[]{app.getMeta().getGuid()});
        }
    }

    @Override
    public ApplicationStats getApplicationStats(CloudApplication application) {
        return this.doGetApplicationStats(application.getMeta().getGuid(), application.getState());
    }

    @Override
    public List<String> getStacks() {
        List newResources;
        Map<String, Object> resource;
        ArrayList<String> stacks = new ArrayList<String>();
        String json = (String)this.restTemplate.getForObject(this.getUrl("/v2/stacks"), String.class, new Object[0]);
        if (json != null && (resource = JsonUtil.convertJsonToMap(json)) != null && (newResources = (List)resource.get("resources")) != null) {
            for (Map res : newResources) {
                String name = CloudEntityResourceMapper.getEntityAttribute(res, "name", String.class);
                if (name == null) continue;
                stacks.add(name);
            }
        }
        return stacks;
    }

    protected CloudApplication mapBasicCloudApplication(String appName) {
        Map<String, Object> resource = this.getBasicApplicationResource(appName);
        return this.mapBasicCloudApplication(resource);
    }

    protected CloudApplication mapBasicCloudApplication(Map<String, Object> resource) {
        CloudApplication cloudApp = null;
        if (resource != null) {
            cloudApp = this.resourceMapper.mapResource(resource, CloudApplication.class);
        }
        return cloudApp;
    }

    protected Map<String, Object> getBasicApplicationResource(String appName) {
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        String urlPath = "/v2";
        if (this.sessionSpace != null) {
            urlVars.put("space", this.sessionSpace.getMeta().getGuid());
            urlPath = urlPath + "/spaces/{space}";
        }
        urlVars.put("q", "name:" + appName);
        urlPath = urlPath + "/apps?inline-relations-depth=1&q={q}";
        List<Map<String, Object>> allResources = this.getAllResources(urlPath, urlVars);
        if (!allResources.isEmpty()) {
            Map<String, Object> foundResource = allResources.get(0);
            this.fillApplicationStack(foundResource);
            return foundResource;
        }
        return null;
    }

    protected Map<String, Object> fillApplicationServiceBindings(Map<String, Object> resource) {
        this.fillInEmbeddedResource(resource, "service_bindings", "service_instance");
        return resource;
    }

    protected Map<String, Object> fillApplicationStack(Map<String, Object> resource) {
        this.fillInEmbeddedResource(resource, "stack");
        return resource;
    }

    protected List<String> findApplicationUris(UUID appGuid) {
        String urlPath = "/v2/apps/{app}/routes?inline-relations-depth=1";
        HashMap<String, Object> urlVars = new HashMap<String, Object>();
        urlVars.put("app", appGuid);
        List<Map<String, Object>> resourceList = this.getAllResources(urlPath, urlVars);
        ArrayList<String> uris = new ArrayList<String>();
        for (Map<String, Object> resource : resourceList) {
            Map<String, Object> domainResource = CloudEntityResourceMapper.getEmbeddedResource(resource, "domain");
            String host = CloudEntityResourceMapper.getEntityAttribute(resource, "host", String.class);
            String domain = CloudEntityResourceMapper.getEntityAttribute(domainResource, "name", String.class);
            if (host != null && host.length() > 0) {
                uris.add(host + "." + domain);
                continue;
            }
            uris.add(domain);
        }
        return uris;
    }

    protected CloudApplication fillApplicationUris(CloudApplication app) {
        if (app != null) {
            app.setUris(this.findApplicationUris(app.getMeta().getGuid()));
        }
        return app;
    }

    protected void fillInEmbeddedResource(Map<String, Object> resource, String ... resourcePath) {
        Object embeddedResource;
        if (resourcePath.length == 0) {
            return;
        }
        Map entity = (Map)resource.get("entity");
        String headKey = resourcePath[0];
        String[] tailPath = Arrays.copyOfRange(resourcePath, 1, resourcePath.length);
        if (!entity.containsKey(headKey)) {
            Map responseMap;
            String pathUrl = entity.get(headKey + "_url").toString();
            Object response = this.restTemplate.getForObject(this.getUrl(pathUrl), Object.class, new Object[0]);
            if (response instanceof Map && (responseMap = (Map)response).containsKey("resources")) {
                response = responseMap.get("resources");
            }
            entity.put(headKey, response);
        }
        if ((embeddedResource = entity.get(headKey)) instanceof Map) {
            Map embeddedResourceMap = (Map)embeddedResource;
            this.fillInEmbeddedResource(embeddedResourceMap, tailPath);
        } else if (embeddedResource instanceof List) {
            List embeddedResourcesList = (List)embeddedResource;
            for (Object r : embeddedResourcesList) {
                this.fillInEmbeddedResource((Map)r, tailPath);
            }
        } else {
            return;
        }
    }

    protected List<Map<String, Object>> getAllResources(String urlPath, Map<String, Object> urlVars) {
        ArrayList<Map<String, Object>> allResources = new ArrayList<Map<String, Object>>();
        String resp = urlVars != null ? (String)this.restTemplate.getForObject(this.getUrl(urlPath), String.class, urlVars) : (String)this.restTemplate.getForObject(this.getUrl(urlPath), String.class, new Object[0]);
        Map<String, Object> respMap = JsonUtil.convertJsonToMap(resp);
        List newResources = (List)respMap.get("resources");
        if (newResources != null && newResources.size() > 0) {
            allResources.addAll(newResources);
        }
        String nextUrl = (String)respMap.get("next_url");
        while (nextUrl != null && nextUrl.length() > 0) {
            nextUrl = this.addPageOfResources(nextUrl, allResources);
        }
        return allResources;
    }

    protected String addPageOfResources(String nextUrl, List<Map<String, Object>> allResources) {
        String resp = (String)this.restTemplate.getForObject(this.getUrl(nextUrl), String.class, new Object[0]);
        Map<String, Object> respMap = JsonUtil.convertJsonToMap(resp);
        List newResources = (List)respMap.get("resources");
        if (newResources != null && newResources.size() > 0) {
            allResources.addAll(newResources);
        }
        return (String)respMap.get("next_url");
    }

    private ApplicationStats doGetApplicationStats(UUID appId, CloudApplication.AppState appState) {
        ArrayList<InstanceStats> instanceList = new ArrayList<InstanceStats>();
        if (appState.equals((Object)CloudApplication.AppState.STARTED)) {
            Map<String, Object> respMap = this.getInstanceInfoForApp(appId, "stats");
            for (String instanceId : respMap.keySet()) {
                InstanceStats instanceStats = new InstanceStats(instanceId, (Map)respMap.get(instanceId));
                instanceList.add(instanceStats);
            }
        }
        return new ApplicationStats(instanceList);
    }

    private Map<String, Object> getInstanceInfoForApp(UUID appId, String path) {
        String url = this.getUrl("/v2/apps/{guid}/" + path);
        HashMap<String, UUID> urlVars = new HashMap<String, UUID>();
        urlVars.put("guid", appId);
        String resp = (String)this.restTemplate.getForObject(url, String.class, urlVars);
        return JsonUtil.convertJsonToMap(resp);
    }

    protected String getUrl(String path) {
        return this.cloudControllerUrl + (path.startsWith("/") ? path : "/" + path);
    }
}

