/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.oauth2;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.oauth2.ResourceOwnerPasscodeResourceDetails;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ResourceOwnerPasscodeAccessTokenProvider
extends ResourceOwnerPasswordAccessTokenProvider {
    public boolean supportsResource(OAuth2ProtectedResourceDetails resource) {
        return resource instanceof ResourceOwnerPasscodeResourceDetails && "password".equals(resource.getGrantType());
    }

    public OAuth2AccessToken obtainAccessToken(OAuth2ProtectedResourceDetails details, AccessTokenRequest request) throws UserRedirectRequiredException, AccessDeniedException, OAuth2AccessDeniedException {
        ResourceOwnerPasscodeResourceDetails resource = (ResourceOwnerPasscodeResourceDetails)details;
        return this.retrieveToken(request, (OAuth2ProtectedResourceDetails)resource, this.getParametersForTokenRequest(resource, request), new HttpHeaders());
    }

    private MultiValueMap<String, String> getParametersForTokenRequest(ResourceOwnerPasscodeResourceDetails resource, AccessTokenRequest request) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.set((Object)"grant_type", (Object)"password");
        form.set((Object)"passcode", (Object)resource.getPasscode());
        form.putAll((Map)request);
        if (resource.isScoped()) {
            StringBuilder builder = new StringBuilder();
            List scope = resource.getScope();
            if (scope != null) {
                Iterator scopeIt = scope.iterator();
                while (scopeIt.hasNext()) {
                    builder.append((String)scopeIt.next());
                    if (!scopeIt.hasNext()) continue;
                    builder.append(' ');
                }
            }
            form.set((Object)"scope", (Object)builder.toString());
        }
        return form;
    }
}

