/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipOutputStream;
import org.cloudfoundry.client.lib.io.DynamicInputStream;
import org.cloudfoundry.client.lib.io.UtcAdjustedZipEntry;
import org.springframework.util.Assert;

public class DynamicZipInputStream
extends DynamicInputStream {
    private static final int BUFFER_SIZE = 4096;
    private static InputStream EMPTY_STREAM = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private ZipOutputStream zipStream;
    private Iterator<Entry> entries;
    private InputStream entryStream = EMPTY_STREAM;
    private byte[] buffer = new byte[4096];
    private long fileCount = 0L;

    public DynamicZipInputStream(Iterable<Entry> entries) {
        Assert.notNull(entries, (String)"Entries must not be null");
        this.zipStream = new ZipOutputStream(this.getOutputStream());
        this.entries = entries.iterator();
    }

    @Override
    protected boolean writeMoreData() throws IOException {
        int count = this.entryStream.read(this.buffer);
        if (count != -1) {
            this.zipStream.write(this.buffer, 0, count);
            return true;
        }
        if (this.entryStream != EMPTY_STREAM) {
            this.zipStream.closeEntry();
            this.entryStream.close();
            this.entryStream = EMPTY_STREAM;
        }
        if (this.entries.hasNext()) {
            ++this.fileCount;
            Entry entry = this.entries.next();
            this.zipStream.putNextEntry(new UtcAdjustedZipEntry(entry.getName()));
            this.entryStream = entry.getInputStream();
            if (this.entryStream == null) {
                this.entryStream = EMPTY_STREAM;
            }
            return true;
        }
        if (this.fileCount == 0L) {
            ++this.fileCount;
            this.zipStream.putNextEntry(new UtcAdjustedZipEntry("__empty__"));
            this.entryStream = EMPTY_STREAM;
            return true;
        }
        this.zipStream.flush();
        this.zipStream.close();
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.zipStream.close();
    }

    public static interface Entry {
        public String getName();

        public InputStream getInputStream() throws IOException;
    }
}

