/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.domain;

import org.cloudfoundry.client.lib.domain.HealthCheckType;

public class Staging {
    private String command;
    private String buildpackUrl;
    private String detectedBuildpack;
    private String stack;
    private HealthCheckType healthCheckType;
    private String healthCheckHttpEndpoint;
    private Integer healthCheckTimeout;

    public Staging() {
    }

    public Staging(String command, String buildpackUrl) {
        this.command = command;
        this.buildpackUrl = buildpackUrl;
    }

    public Staging(String command, String buildpackUrl, String detectedBuildpack) {
        this(command, buildpackUrl);
        this.detectedBuildpack = detectedBuildpack;
    }

    public Staging(String command, String buildpackUrl, String stack, Integer healthCheckTimeout) {
        this(command, buildpackUrl);
        this.stack = stack;
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public Staging(String command, String buildpackUrl, String stack, Integer healthCheckTimeout, String detectedBuildpack) {
        this(command, buildpackUrl, stack, healthCheckTimeout);
        this.detectedBuildpack = detectedBuildpack;
    }

    public String getCommand() {
        return this.command;
    }

    public String getBuildpackUrl() {
        return this.buildpackUrl;
    }

    public String getDetectedBuildpack() {
        return this.detectedBuildpack;
    }

    public String getStack() {
        return this.stack;
    }

    public Integer getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public String getHealthCheckHttpEndpoint() {
        return this.healthCheckHttpEndpoint;
    }

    public HealthCheckType getHealthCheckType() {
        return this.healthCheckType;
    }

    public String toString() {
        return "Staging [command=" + this.getCommand() + " buildpack=" + this.getBuildpackUrl() + " stack=" + this.getStack() + " healthCheckTimeout=" + this.getHealthCheckTimeout() + " healthCheckType=" + (Object)((Object)this.getHealthCheckType()) + " healthCheckHttpEndpoint=" + this.getHealthCheckHttpEndpoint() + "]";
    }

    public static StagingBuilder builder() {
        return new StagingBuilder();
    }

    public static class StagingBuilder {
        private final Staging staging = new Staging();

        public StagingBuilder buildpack(String buildpack) {
            this.staging.buildpackUrl = buildpack;
            return this;
        }

        public StagingBuilder stack(String stack) {
            this.staging.stack = stack;
            return this;
        }

        public StagingBuilder healthCheckType(HealthCheckType healthCheckType) {
            this.staging.healthCheckType = healthCheckType;
            return this;
        }

        public StagingBuilder healthCheckTimeout(Integer healthCheckTimeout) {
            this.staging.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        public StagingBuilder healthCheckHttpEndpoint(String healthCheckHttpEndpoint) {
            this.staging.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
            return this;
        }

        public StagingBuilder detectedBuildpack(String detectedBuildpack) {
            this.staging.detectedBuildpack = detectedBuildpack;
            return this;
        }

        public StagingBuilder command(String command) {
            this.staging.command = command;
            return this;
        }

        public Staging build() {
            return this.staging;
        }
    }
}

