/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.domain;

import org.cloudfoundry.client.lib.domain.CloudEntity;

public class CloudJob
extends CloudEntity {
    private final Status status;
    private final ErrorDetails errorDetails;

    public CloudJob(CloudEntity.Meta meta, Status status) {
        this(meta, status, null);
    }

    public CloudJob(CloudEntity.Meta meta, Status status, ErrorDetails errorDetails) {
        super(meta);
        this.status = status;
        this.errorDetails = errorDetails;
    }

    public Status getStatus() {
        return this.status;
    }

    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public static class ErrorDetails {
        private long code;
        private String description;
        private String errorCode;

        public ErrorDetails(long code, String description, String errorCode) {
            this.code = code;
            this.description = description;
            this.errorCode = errorCode;
        }

        public long getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }
    }

    public static enum Status {
        FAILED("failed"),
        FINISHED("finished"),
        QUEUED("queued"),
        RUNNING("running");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }

        public static Status getEnum(String status) {
            for (Status value : Status.values()) {
                if (!value.status.equals(status)) continue;
                return value;
            }
            throw new IllegalArgumentException("Invalid Status value: " + status);
        }
    }
}

