/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.domain.CloudEntity;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.domain.Staging;
import org.cloudfoundry.client.lib.org.codehaus.jackson.annotate.JsonAutoDetect;
import org.cloudfoundry.client.lib.util.CloudUtil;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class CloudApplication
extends CloudEntity {
    private static final String COMMAND_KEY = "command";
    private static final String BUILDPACK_URL_KEY = "buildpack";
    private static final String DETECTED_BUILDPACK_KEY = "detected_buildpack";
    private static final String MEMORY_KEY = "memory";
    private static final String DISK_KEY = "disk_quota";
    private CloudSpace space;
    private Staging staging;
    private int instances;
    private int memory;
    private int diskQuota;
    private List<String> uris;
    private List<String> services;
    private AppState state;
    private DebugMode debug;
    private int runningInstances;
    private List<String> env = new ArrayList<String>();
    private boolean diego;
    private boolean enableSsh;

    public CloudApplication(CloudEntity.Meta meta, String name) {
        super(meta, name);
    }

    public CloudApplication(String name, String command, String buildpackUrl, int memory, int instances, List<String> uris, List<String> serviceNames, AppState state) {
        super(CloudEntity.Meta.defaultMeta(), name);
        this.staging = new Staging(command, buildpackUrl);
        this.memory = memory;
        this.instances = instances;
        this.uris = uris;
        this.services = serviceNames;
        this.state = state;
    }

    public CloudApplication(Map<String, Object> attributes) {
        super(CloudEntity.Meta.defaultMeta(), CloudUtil.parse(attributes.get("name")));
        this.instances = (Integer)attributes.get("instances");
        Integer runningInstancesAttribute = (Integer)attributes.get("runningInstances");
        if (runningInstancesAttribute != null) {
            this.runningInstances = runningInstancesAttribute;
        }
        this.uris = (List)attributes.get("uris");
        this.services = (List)attributes.get("services");
        this.state = AppState.valueOf((String)attributes.get("state"));
        if (attributes.containsKey(MEMORY_KEY)) {
            this.memory = (Integer)attributes.get(MEMORY_KEY);
        }
        if (attributes.containsKey(DISK_KEY)) {
            this.diskQuota = (Integer)attributes.get(DISK_KEY);
        }
        try {
            if (attributes.containsKey("diego")) {
                this.diego = Boolean.parseBoolean((String)attributes.get("diego"));
            }
        }
        catch (Exception e) {
            this.diego = false;
        }
        try {
            if (attributes.containsKey("enable_ssh")) {
                this.enableSsh = Boolean.parseBoolean((String)attributes.get("enable_ssh"));
            }
        }
        catch (Exception e) {
            this.enableSsh = false;
        }
        this.env = (List)attributes.get("env");
        Map metaValue = CloudUtil.parse(Map.class, attributes.get("meta"));
        if (metaValue != null) {
            long created;
            String debugAttribute = (String)metaValue.get("debug");
            if (debugAttribute != null) {
                this.debug = DebugMode.valueOf(debugAttribute);
            }
            Date createdDate = (created = CloudUtil.parse(Long.class, metaValue.get("created")).longValue()) != 0L ? new Date(created * 1000L) : null;
            this.setMeta(new CloudEntity.Meta(null, createdDate, null));
            String command = null;
            if (metaValue.containsKey(COMMAND_KEY)) {
                command = (String)metaValue.get(COMMAND_KEY);
            }
            String buildpackUrl = null;
            if (metaValue.containsKey(BUILDPACK_URL_KEY)) {
                buildpackUrl = (String)metaValue.get(BUILDPACK_URL_KEY);
            }
            String detectedBuildpack = null;
            if (metaValue.containsKey(DETECTED_BUILDPACK_KEY)) {
                detectedBuildpack = (String)metaValue.get(DETECTED_BUILDPACK_KEY);
            }
            this.setStaging(new Staging(command, buildpackUrl, detectedBuildpack));
        }
    }

    public CloudSpace getSpace() {
        return this.space;
    }

    public void setSpace(CloudSpace space) {
        this.space = space;
    }

    public Staging getStaging() {
        return this.staging;
    }

    public void setStaging(Staging staging) {
        this.staging = staging;
    }

    public Map<String, Integer> getResources() {
        HashMap<String, Integer> resources = new HashMap<String, Integer>();
        resources.put(MEMORY_KEY, this.memory);
        resources.put(DISK_KEY, this.diskQuota);
        return resources;
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        this.instances = instances;
    }

    public int getDiskQuota() {
        return this.diskQuota;
    }

    public void setDiskQuota(int diskQuota) {
        this.diskQuota = diskQuota;
    }

    public int getMemory() {
        return this.memory;
    }

    public void setMemory(int memory) {
        this.memory = memory;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public void setUris(List<String> uris) {
        this.uris = uris;
    }

    public AppState getState() {
        return this.state;
    }

    public void setState(AppState state) {
        this.state = state;
    }

    public DebugMode getDebug() {
        return this.debug;
    }

    public void setDebug(DebugMode debug) {
        this.debug = debug;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public int getRunningInstances() {
        return this.runningInstances;
    }

    public void setRunningInstances(int runningInstances) {
        this.runningInstances = runningInstances;
    }

    public Map<String, String> getEnvAsMap() {
        HashMap<String, String> envMap = new HashMap<String, String>();
        for (String nameAndValue : this.env) {
            String[] parts = nameAndValue.split("=", 2);
            envMap.put(parts[0], parts.length == 2 && parts[1].length() > 0 ? parts[1] : null);
        }
        return envMap;
    }

    public List<String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<Object, Object> env) {
        ArrayList<String> joined = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : env.entrySet()) {
            if (null == entry.getKey()) continue;
            String value = null == entry.getValue() ? "" : entry.getValue().toString();
            joined.add(entry.getKey().toString() + '=' + value);
        }
        this.env = joined;
    }

    @Override
    public String toString() {
        return "CloudApplication [staging=" + this.staging + ", instances=" + this.instances + ", name=" + this.getName() + ", memory=" + this.memory + ", diskQuota=" + this.diskQuota + ", state=" + (Object)((Object)this.state) + ", debug=" + (Object)((Object)this.debug) + ", uris=" + this.uris + ", services=" + this.services + ", env=" + this.env + ", space=" + this.space.getName() + "]";
    }

    public boolean isDiego() {
        return this.diego;
    }

    public void setDiego(boolean diego) {
        this.diego = diego;
    }

    public boolean isEnableSsh() {
        return this.enableSsh;
    }

    public void setEnableSsh(boolean enableSsh) {
        this.enableSsh = enableSsh;
    }

    public static enum DebugMode {
        run,
        suspend;

    }

    public static enum AppState {
        UPDATING,
        STARTED,
        STOPPED;

    }
}

