/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.cloudfoundry.client.lib.AdditionalRestOperations;
import org.cloudfoundry.client.lib.ApplicationLogListener;
import org.cloudfoundry.client.lib.ClientHttpResponseCallback;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.RestLogCallback;
import org.cloudfoundry.client.lib.StartingInfo;
import org.cloudfoundry.client.lib.StreamingLogToken;
import org.cloudfoundry.client.lib.UploadStatusCallback;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.cloudfoundry.client.lib.domain.CloudEvent;
import org.cloudfoundry.client.lib.domain.CloudInfo;
import org.cloudfoundry.client.lib.domain.CloudOrganization;
import org.cloudfoundry.client.lib.domain.CloudQuota;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.cloudfoundry.client.lib.domain.CloudSecurityGroup;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.CloudServiceBroker;
import org.cloudfoundry.client.lib.domain.CloudServiceInstance;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.domain.CloudStack;
import org.cloudfoundry.client.lib.domain.CloudUser;
import org.cloudfoundry.client.lib.domain.CrashesInfo;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.cloudfoundry.client.lib.domain.Staging;
import org.cloudfoundry.client.lib.rest.CloudControllerClient;
import org.cloudfoundry.client.lib.rest.CloudControllerClientFactory;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;

public class CloudFoundryClient
implements CloudFoundryOperations {
    private CloudControllerClient cc;
    private CloudInfo info;

    public CloudFoundryClient(URL cloudControllerUrl) {
        this(null, cloudControllerUrl, null, (HttpProxyConfiguration)null, false);
    }

    public CloudFoundryClient(URL cloudControllerUrl, boolean trustSelfSignedCerts) {
        this(null, cloudControllerUrl, null, (HttpProxyConfiguration)null, trustSelfSignedCerts);
    }

    public CloudFoundryClient(URL cloudControllerUrl, HttpProxyConfiguration httpProxyConfiguration) {
        this(null, cloudControllerUrl, null, httpProxyConfiguration, false);
    }

    public CloudFoundryClient(URL cloudControllerUrl, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
        this(null, cloudControllerUrl, null, httpProxyConfiguration, trustSelfSignedCerts);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl) {
        this(credentials, cloudControllerUrl, null, (HttpProxyConfiguration)null, false);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, boolean trustSelfSignedCerts) {
        this(credentials, cloudControllerUrl, null, (HttpProxyConfiguration)null, trustSelfSignedCerts);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, HttpProxyConfiguration httpProxyConfiguration) {
        this(credentials, cloudControllerUrl, null, httpProxyConfiguration, false);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
        this(credentials, cloudControllerUrl, null, httpProxyConfiguration, trustSelfSignedCerts);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, CloudSpace sessionSpace) {
        this(credentials, cloudControllerUrl, sessionSpace, null, false);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, CloudSpace sessionSpace, boolean trustSelfSignedCerts) {
        this(credentials, cloudControllerUrl, sessionSpace, null, trustSelfSignedCerts);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, CloudSpace sessionSpace, HttpProxyConfiguration httpProxyConfiguration) {
        this(credentials, cloudControllerUrl, sessionSpace, httpProxyConfiguration, false);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, CloudSpace sessionSpace, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
        Assert.notNull((Object)cloudControllerUrl, (String)"URL for cloud controller cannot be null");
        CloudControllerClientFactory cloudControllerClientFactory = new CloudControllerClientFactory(httpProxyConfiguration, trustSelfSignedCerts);
        this.cc = cloudControllerClientFactory.newCloudController(cloudControllerUrl, credentials, sessionSpace);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, String orgName, String spaceName) {
        this(credentials, cloudControllerUrl, orgName, spaceName, null, false);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, String orgName, String spaceName, boolean trustSelfSignedCerts) {
        this(credentials, cloudControllerUrl, orgName, spaceName, null, trustSelfSignedCerts);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, String orgName, String spaceName, HttpProxyConfiguration httpProxyConfiguration) {
        this(credentials, cloudControllerUrl, orgName, spaceName, httpProxyConfiguration, false);
    }

    public CloudFoundryClient(CloudCredentials credentials, URL cloudControllerUrl, String orgName, String spaceName, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
        Assert.notNull((Object)cloudControllerUrl, (String)"URL for cloud controller cannot be null");
        CloudControllerClientFactory cloudControllerClientFactory = new CloudControllerClientFactory(httpProxyConfiguration, trustSelfSignedCerts);
        this.cc = cloudControllerClientFactory.newCloudController(cloudControllerUrl, credentials, orgName, spaceName);
    }

    public CloudFoundryClient(CloudControllerClient cc) {
        this.cc = cc;
    }

    @Override
    public void setResponseErrorHandler(ResponseErrorHandler errorHandler) {
        this.cc.setResponseErrorHandler(errorHandler);
    }

    @Override
    public URL getCloudControllerUrl() {
        return this.cc.getCloudControllerUrl();
    }

    @Override
    public CloudInfo getCloudInfo() {
        if (this.info == null) {
            this.info = this.cc.getInfo();
        }
        return this.info;
    }

    @Override
    public List<CloudSpace> getSpaces() {
        return this.cc.getSpaces();
    }

    @Override
    public List<CloudOrganization> getOrganizations() {
        return this.cc.getOrganizations();
    }

    @Override
    public void register(String email, String password) {
        this.cc.register(email, password);
    }

    @Override
    public void updatePassword(String newPassword) {
        this.cc.updatePassword(newPassword);
    }

    @Override
    public void updatePassword(CloudCredentials credentials, String newPassword) {
        this.cc.updatePassword(credentials, newPassword);
    }

    @Override
    public void unregister() {
        this.cc.unregister();
    }

    @Override
    public OAuth2AccessToken login() {
        return this.cc.login();
    }

    @Override
    public void logout() {
        this.cc.logout();
    }

    @Override
    public List<CloudApplication> getApplications() {
        return this.cc.getApplications();
    }

    @Override
    public CloudApplication getApplication(String appName) {
        return this.cc.getApplication(appName);
    }

    @Override
    public CloudApplication getApplication(UUID appGuid) {
        return this.cc.getApplication(appGuid);
    }

    @Override
    public Map<String, Object> getApplicationEnvironment(UUID appGuid) {
        return this.cc.getApplicationEnvironment(appGuid);
    }

    @Override
    public Map<String, Object> getApplicationEnvironment(String appName) {
        return this.cc.getApplicationEnvironment(appName);
    }

    @Override
    public ApplicationStats getApplicationStats(String appName) {
        return this.cc.getApplicationStats(appName);
    }

    @Override
    public void createApplication(String appName, Staging staging, Integer memory, List<String> uris, List<String> serviceNames) {
        this.cc.createApplication(appName, staging, memory, uris, serviceNames);
    }

    @Override
    public void createApplication(String appName, Staging staging, Integer disk, Integer memory, List<String> uris, List<String> serviceNames) {
        this.cc.createApplication(appName, staging, disk, memory, uris, serviceNames);
    }

    @Override
    public void createService(CloudService service) {
        this.cc.createService(service);
    }

    @Override
    public void createUserProvidedService(CloudService service, Map<String, Object> credentials) {
        this.cc.createUserProvidedService(service, credentials);
    }

    @Override
    public void createUserProvidedService(CloudService service, Map<String, Object> credentials, String syslogDrainUrl) {
        this.cc.createUserProvidedService(service, credentials, syslogDrainUrl);
    }

    @Override
    public List<CloudRoute> deleteOrphanedRoutes() {
        return this.cc.deleteOrphanedRoutes();
    }

    @Override
    public void uploadApplication(String appName, String file) throws IOException {
        this.cc.uploadApplication(appName, new File(file), null);
    }

    @Override
    public void uploadApplication(String appName, File file) throws IOException {
        this.cc.uploadApplication(appName, file, null);
    }

    @Override
    public void uploadApplication(String appName, File file, UploadStatusCallback callback) throws IOException {
        this.cc.uploadApplication(appName, file, callback);
    }

    @Override
    public void uploadApplication(String appName, String fileName, InputStream inputStream) throws IOException {
        this.cc.uploadApplication(appName, fileName, inputStream, null);
    }

    @Override
    public void uploadApplication(String appName, String fileName, InputStream inputStream, UploadStatusCallback callback) throws IOException {
        this.cc.uploadApplication(appName, fileName, inputStream, callback);
    }

    @Override
    public void uploadApplication(String appName, ApplicationArchive archive) throws IOException {
        this.cc.uploadApplication(appName, archive, null);
    }

    @Override
    public void uploadApplication(String appName, ApplicationArchive archive, UploadStatusCallback callback) throws IOException {
        this.cc.uploadApplication(appName, archive, callback);
    }

    @Override
    public StartingInfo startApplication(String appName) {
        return this.cc.startApplication(appName);
    }

    @Override
    public void debugApplication(String appName, CloudApplication.DebugMode mode) {
        this.cc.debugApplication(appName, mode);
    }

    @Override
    public void stopApplication(String appName) {
        this.cc.stopApplication(appName);
    }

    @Override
    public StartingInfo restartApplication(String appName) {
        return this.cc.restartApplication(appName);
    }

    @Override
    public void deleteApplication(String appName) {
        this.cc.deleteApplication(appName);
    }

    @Override
    public void deleteAllApplications() {
        this.cc.deleteAllApplications();
    }

    @Override
    public void deleteAllServices() {
        this.cc.deleteAllServices();
    }

    @Override
    public void updateApplicationDiskQuota(String appName, int disk) {
        this.cc.updateApplicationDiskQuota(appName, disk);
    }

    @Override
    public void updateApplicationMemory(String appName, int memory) {
        this.cc.updateApplicationMemory(appName, memory);
    }

    @Override
    public void updateApplicationInstances(String appName, int instances) {
        this.cc.updateApplicationInstances(appName, instances);
    }

    @Override
    public void updateApplicationServices(String appName, List<String> services) {
        this.cc.updateApplicationServices(appName, services);
    }

    @Override
    public void updateApplicationStaging(String appName, Staging staging) {
        this.cc.updateApplicationStaging(appName, staging);
    }

    @Override
    public void updateApplicationUris(String appName, List<String> uris) {
        this.cc.updateApplicationUris(appName, uris);
    }

    @Override
    public void updateApplicationEnv(String appName, Map<String, String> env) {
        this.cc.updateApplicationEnv(appName, env);
    }

    @Override
    public void updateApplicationEnv(String appName, List<String> env) {
        this.cc.updateApplicationEnv(appName, env);
    }

    @Override
    public List<CloudEvent> getEvents() {
        return this.cc.getEvents();
    }

    @Override
    public List<CloudEvent> getApplicationEvents(String appName) {
        return this.cc.getApplicationEvents(appName);
    }

    @Override
    public Map<String, String> getLogs(String appName) {
        return this.cc.getLogs(appName);
    }

    @Override
    public StreamingLogToken streamLogs(String appName, ApplicationLogListener listener) {
        return this.cc.streamLogs(appName, listener);
    }

    @Override
    public List<ApplicationLog> getRecentLogs(String appName) {
        return this.cc.getRecentLogs(appName);
    }

    @Override
    public Map<String, String> getCrashLogs(String appName) {
        return this.cc.getCrashLogs(appName);
    }

    @Override
    public String getStagingLogs(StartingInfo info, int offset) {
        return this.cc.getStagingLogs(info, offset);
    }

    @Override
    public String getFile(String appName, int instanceIndex, String filePath) {
        return this.cc.getFile(appName, instanceIndex, filePath, 0, -1);
    }

    @Override
    public String getFile(String appName, int instanceIndex, String filePath, int startPosition) {
        Assert.isTrue((startPosition >= 0 ? 1 : 0) != 0, (String)(startPosition + " is not a valid value for start position, it should be 0 or greater."));
        return this.cc.getFile(appName, instanceIndex, filePath, startPosition, -1);
    }

    @Override
    public String getFile(String appName, int instanceIndex, String filePath, int startPosition, int endPosition) {
        Assert.isTrue((startPosition >= 0 ? 1 : 0) != 0, (String)(startPosition + " is not a valid value for start position, it should be 0 or greater."));
        Assert.isTrue((endPosition > startPosition ? 1 : 0) != 0, (String)(endPosition + " is not a valid value for end position, it should be greater than startPosition " + "which is " + startPosition + "."));
        return this.cc.getFile(appName, instanceIndex, filePath, startPosition, endPosition - 1);
    }

    @Override
    public void openFile(String appName, int instanceIndex, String filePath, ClientHttpResponseCallback callback) {
        this.cc.openFile(appName, instanceIndex, filePath, callback);
    }

    @Override
    public String getFileTail(String appName, int instanceIndex, String filePath, int length) {
        Assert.isTrue((length > 0 ? 1 : 0) != 0, (String)(length + " is not a valid value for length, it should be 1 or greater."));
        return this.cc.getFile(appName, instanceIndex, filePath, -1, length);
    }

    @Override
    public List<CloudService> getServices() {
        return this.cc.getServices();
    }

    @Override
    public List<CloudServiceBroker> getServiceBrokers() {
        return this.cc.getServiceBrokers();
    }

    @Override
    public CloudServiceBroker getServiceBroker(String name) {
        return this.cc.getServiceBroker(name);
    }

    @Override
    public void createServiceBroker(CloudServiceBroker serviceBroker) {
        this.cc.createServiceBroker(serviceBroker);
    }

    @Override
    public void updateServiceBroker(CloudServiceBroker serviceBroker) {
        this.cc.updateServiceBroker(serviceBroker);
    }

    @Override
    public void deleteServiceBroker(String name) {
        this.cc.deleteServiceBroker(name);
    }

    @Override
    public void updateServicePlanVisibilityForBroker(String name, boolean visibility) {
        this.cc.updateServicePlanVisibilityForBroker(name, visibility);
    }

    @Override
    public CloudService getService(String service) {
        return this.cc.getService(service);
    }

    @Override
    public CloudServiceInstance getServiceInstance(String service) {
        return this.cc.getServiceInstance(service);
    }

    @Override
    public void deleteService(String service) {
        this.cc.deleteService(service);
    }

    @Override
    public List<CloudServiceOffering> getServiceOfferings() {
        return this.cc.getServiceOfferings();
    }

    @Override
    public void bindService(String appName, String serviceName) {
        this.cc.bindService(appName, serviceName);
    }

    @Override
    public void unbindService(String appName, String serviceName) {
        this.cc.unbindService(appName, serviceName);
    }

    @Override
    public InstancesInfo getApplicationInstances(String appName) {
        return this.cc.getApplicationInstances(appName);
    }

    @Override
    public InstancesInfo getApplicationInstances(CloudApplication app) {
        return this.cc.getApplicationInstances(app);
    }

    @Override
    public CrashesInfo getCrashes(String appName) {
        return this.cc.getCrashes(appName);
    }

    @Override
    public List<CloudStack> getStacks() {
        return this.cc.getStacks();
    }

    @Override
    public CloudStack getStack(String name) {
        return this.cc.getStack(name);
    }

    @Override
    public void rename(String appName, String newName) {
        this.cc.rename(appName, newName);
    }

    @Override
    public List<CloudDomain> getDomainsForOrg() {
        return this.cc.getDomainsForOrg();
    }

    @Override
    public List<CloudDomain> getPrivateDomains() {
        return this.cc.getPrivateDomains();
    }

    @Override
    public List<CloudDomain> getSharedDomains() {
        return this.cc.getSharedDomains();
    }

    @Override
    public List<CloudDomain> getDomains() {
        return this.cc.getDomains();
    }

    @Override
    public CloudDomain getDefaultDomain() {
        return this.cc.getDefaultDomain();
    }

    @Override
    public void addDomain(String domainName) {
        this.cc.addDomain(domainName);
    }

    @Override
    public void deleteDomain(String domainName) {
        this.cc.deleteDomain(domainName);
    }

    @Override
    public void removeDomain(String domainName) {
        this.cc.removeDomain(domainName);
    }

    @Override
    public List<CloudRoute> getRoutes(String domainName) {
        return this.cc.getRoutes(domainName);
    }

    @Override
    public void addRoute(String host, String domainName) {
        this.cc.addRoute(host, domainName);
    }

    @Override
    public void deleteRoute(String host, String domainName) {
        this.cc.deleteRoute(host, domainName);
    }

    @Override
    public void registerRestLogListener(RestLogCallback callBack) {
        this.cc.registerRestLogListener(callBack);
    }

    @Override
    public void unRegisterRestLogListener(RestLogCallback callBack) {
        this.cc.unRegisterRestLogListener(callBack);
    }

    @Override
    public CloudOrganization getOrgByName(String orgName, boolean required) {
        return this.cc.getOrgByName(orgName, required);
    }

    @Override
    public List<CloudQuota> getQuotas() {
        return this.cc.getQuotas();
    }

    @Override
    public CloudQuota getQuotaByName(String quotaName, boolean required) {
        return this.cc.getQuotaByName(quotaName, required);
    }

    @Override
    public void setQuotaToOrg(String orgName, String quotaName) {
        this.cc.setQuotaToOrg(orgName, quotaName);
    }

    @Override
    public void createQuota(CloudQuota quota) {
        this.cc.createQuota(quota);
    }

    @Override
    public void deleteQuota(String quotaName) {
        this.cc.deleteQuota(quotaName);
    }

    @Override
    public void updateQuota(CloudQuota quota, String name) {
        this.cc.updateQuota(quota, name);
    }

    @Override
    public void createSpace(String spaceName) {
        this.cc.createSpace(spaceName);
    }

    @Override
    public void deleteSpace(String spaceName) {
        this.cc.deleteSpace(spaceName);
    }

    @Override
    public CloudSpace getSpace(String spaceName) {
        return this.cc.getSpace(spaceName);
    }

    @Override
    public List<UUID> getSpaceManagers(String spaceName) {
        return this.cc.getSpaceManagers(null, spaceName);
    }

    @Override
    public List<UUID> getSpaceDevelopers(String spaceName) {
        return this.cc.getSpaceDevelopers(null, spaceName);
    }

    @Override
    public List<UUID> getSpaceAuditors(String spaceName) {
        return this.cc.getSpaceAuditors(null, spaceName);
    }

    @Override
    public List<UUID> getSpaceManagers(String orgName, String spaceName) {
        return this.cc.getSpaceManagers(orgName, spaceName);
    }

    @Override
    public List<UUID> getSpaceDevelopers(String orgName, String spaceName) {
        return this.cc.getSpaceDevelopers(orgName, spaceName);
    }

    @Override
    public List<UUID> getSpaceAuditors(String orgName, String spaceName) {
        return this.cc.getSpaceAuditors(orgName, spaceName);
    }

    @Override
    public void associateManagerWithSpace(String spaceName) {
        this.cc.associateManagerWithSpace(null, spaceName, null);
    }

    @Override
    public void associateDeveloperWithSpace(String spaceName) {
        this.cc.associateDeveloperWithSpace(null, spaceName, null);
    }

    @Override
    public void associateAuditorWithSpace(String spaceName) {
        this.cc.associateAuditorWithSpace(null, spaceName, null);
    }

    @Override
    public void associateManagerWithSpace(String orgName, String spaceName) {
        this.cc.associateManagerWithSpace(orgName, spaceName, null);
    }

    @Override
    public void associateDeveloperWithSpace(String orgName, String spaceName) {
        this.cc.associateDeveloperWithSpace(orgName, spaceName, null);
    }

    @Override
    public void associateAuditorWithSpace(String orgName, String spaceName) {
        this.cc.associateAuditorWithSpace(orgName, spaceName, null);
    }

    @Override
    public void associateManagerWithSpace(String orgName, String spaceName, String userGuid) {
        this.cc.associateManagerWithSpace(orgName, spaceName, userGuid);
    }

    @Override
    public void associateDeveloperWithSpace(String orgName, String spaceName, String userGuid) {
        this.cc.associateDeveloperWithSpace(orgName, spaceName, userGuid);
    }

    @Override
    public void associateAuditorWithSpace(String orgName, String spaceName, String userGuid) {
        this.cc.associateAuditorWithSpace(orgName, spaceName, userGuid);
    }

    @Override
    public List<CloudSecurityGroup> getSecurityGroups() {
        return this.cc.getSecurityGroups();
    }

    @Override
    public CloudSecurityGroup getSecurityGroup(String securityGroupName) {
        return this.cc.getSecurityGroup(securityGroupName);
    }

    @Override
    public void createSecurityGroup(CloudSecurityGroup securityGroup) {
        this.cc.createSecurityGroup(securityGroup);
    }

    @Override
    public void createSecurityGroup(String name, InputStream jsonRulesFile) {
        this.cc.createSecurityGroup(name, jsonRulesFile);
    }

    @Override
    public void updateSecurityGroup(CloudSecurityGroup securityGroup) {
        this.cc.updateSecurityGroup(securityGroup);
    }

    @Override
    public void updateSecurityGroup(String name, InputStream jsonRulesFile) {
        this.cc.updateSecurityGroup(name, jsonRulesFile);
    }

    @Override
    public void deleteSecurityGroup(String securityGroupName) {
        this.cc.deleteSecurityGroup(securityGroupName);
    }

    @Override
    public List<CloudSecurityGroup> getStagingSecurityGroups() {
        return this.cc.getStagingSecurityGroups();
    }

    @Override
    public void bindStagingSecurityGroup(String securityGroupName) {
        this.cc.bindStagingSecurityGroup(securityGroupName);
    }

    @Override
    public void unbindStagingSecurityGroup(String securityGroupName) {
        this.cc.unbindStagingSecurityGroup(securityGroupName);
    }

    @Override
    public List<CloudSecurityGroup> getRunningSecurityGroups() {
        return this.cc.getRunningSecurityGroups();
    }

    @Override
    public void bindRunningSecurityGroup(String securityGroupName) {
        this.cc.bindRunningSecurityGroup(securityGroupName);
    }

    @Override
    public void unbindRunningSecurityGroup(String securityGroupName) {
        this.cc.unbindRunningSecurityGroup(securityGroupName);
    }

    @Override
    public void bindSecurityGroup(String orgName, String spaceName, String securityGroupName) {
        this.cc.bindSecurityGroup(orgName, spaceName, securityGroupName);
    }

    @Override
    public void unbindSecurityGroup(String orgName, String spaceName, String securityGroupName) {
        this.cc.unbindSecurityGroup(orgName, spaceName, securityGroupName);
    }

    @Override
    public Map<String, CloudUser> getOrganizationUsers(String orgName) {
        return this.cc.getOrganizationUsers(orgName);
    }

    @Override
    public List<CloudSpace> getSpacesBoundToSecurityGroup(String securityGroupName) {
        return this.cc.getSpacesBoundToSecurityGroup(securityGroupName);
    }

    @Override
    public void updateApplicationDiego(String appName, boolean diego) {
        this.cc.updateApplicationDiego(appName, diego);
    }

    @Override
    public void updateApplicationEnableSsh(String appName, boolean enableSsh) {
        this.cc.updateApplicationEnableSsh(appName, enableSsh);
    }

    @Override
    public AdditionalRestOperations getAdditionalRestOperations() {
        return this.cc.getAdditionalRestOperations();
    }
}

