/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib;

import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class CloudCredentials {
    private boolean refreshable = true;
    private String email;
    private String password;
    private String clientId = "cf";
    private String clientSecret = "";
    private OAuth2AccessToken token;
    private String proxyUser;
    private String passcode;

    public CloudCredentials(String email, String password) {
        this.email = email;
        this.password = password;
    }

    public CloudCredentials(String email, String password, String clientId) {
        this.email = email;
        this.password = password;
        this.clientId = clientId;
    }

    public CloudCredentials(String email, String password, String clientId, String clientSecret) {
        this.email = email;
        this.password = password;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public CloudCredentials(OAuth2AccessToken token) {
        this.token = token;
    }

    public CloudCredentials(String passcode, OAuth2AccessToken token) {
        this.passcode = passcode;
        this.token = token;
    }

    public CloudCredentials(OAuth2AccessToken token, boolean refreshable) {
        this.token = token;
        this.refreshable = refreshable;
    }

    public CloudCredentials(OAuth2AccessToken token, String clientId) {
        this.token = token;
        this.clientId = clientId;
    }

    public CloudCredentials(OAuth2AccessToken token, String clientId, String clientSecret) {
        this.token = token;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public CloudCredentials(CloudCredentials cloudCredentials, String proxyForUser) {
        this.email = cloudCredentials.getEmail();
        this.password = cloudCredentials.getPassword();
        this.clientId = cloudCredentials.getClientId();
        this.token = cloudCredentials.getToken();
        this.proxyUser = proxyForUser;
    }

    public CloudCredentials(String passcode) {
        this.passcode = passcode;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public OAuth2AccessToken getToken() {
        return this.token;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public boolean isProxyUserSet() {
        return this.proxyUser != null;
    }

    public CloudCredentials proxyForUser(String user) {
        return new CloudCredentials(this, user);
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public boolean isPasscodeSet() {
        return this.passcode != null;
    }
}

