/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.catalina.Context;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.Extension;
import org.apache.catalina.util.ManifestResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class ExtensionValidator {
    private static final Log log = LogFactory.getLog(ExtensionValidator.class);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.util");
    private static volatile ArrayList<Extension> containerAvailableExtensions = null;
    private static final ArrayList<ManifestResource> containerManifestResources = new ArrayList();

    public static synchronized boolean validateApplication(WebResourceRoot resources, Context context) throws IOException {
        WebResource[] manifestResources;
        String appName = context.getName();
        ArrayList<ManifestResource> appManifestResources = new ArrayList<ManifestResource>();
        WebResource resource = resources.getResource("/META-INF/MANIFEST.MF");
        if (resource.isFile()) {
            try (InputStream inputStream = resource.getInputStream();){
                Manifest manifest = new Manifest(inputStream);
                ManifestResource mre = new ManifestResource(sm.getString("extensionValidator.web-application-manifest"), manifest, 2);
                appManifestResources.add(mre);
            }
        }
        for (WebResource manifestResource : manifestResources = resources.getClassLoaderResources("/META-INF/MANIFEST.MF")) {
            if (!manifestResource.isFile()) continue;
            String jarName = manifestResource.getURL().toExternalForm();
            Manifest jmanifest = null;
            try (InputStream is = manifestResource.getInputStream();){
                jmanifest = new Manifest(is);
                ManifestResource mre = new ManifestResource(jarName, jmanifest, 3);
                appManifestResources.add(mre);
            }
        }
        return ExtensionValidator.validateManifestResources(appName, appManifestResources);
    }

    public static void addSystemResource(File jarFile) throws IOException {
        try (FileInputStream is = new FileInputStream(jarFile);){
            Manifest manifest = ExtensionValidator.getManifest(is);
            if (manifest != null) {
                ManifestResource mre = new ManifestResource(jarFile.getAbsolutePath(), manifest, 1);
                containerManifestResources.add(mre);
            }
        }
    }

    private static boolean validateManifestResources(String appName, ArrayList<ManifestResource> resources) {
        boolean passes = true;
        int failureCount = 0;
        ArrayList<Extension> availableExtensions = null;
        for (ManifestResource mre : resources) {
            ArrayList<Extension> requiredList = mre.getRequiredExtensions();
            if (requiredList == null) continue;
            if (availableExtensions == null) {
                availableExtensions = ExtensionValidator.buildAvailableExtensionsList(resources);
            }
            if (containerAvailableExtensions == null) {
                containerAvailableExtensions = ExtensionValidator.buildAvailableExtensionsList(containerManifestResources);
            }
            Iterator<Extension> rit = requiredList.iterator();
            while (rit.hasNext()) {
                boolean found = false;
                Extension requiredExt = rit.next();
                if (availableExtensions != null) {
                    for (Extension targetExt : availableExtensions) {
                        if (!targetExt.isCompatibleWith(requiredExt)) continue;
                        requiredExt.setFulfilled(true);
                        found = true;
                        break;
                    }
                }
                if (!found && containerAvailableExtensions != null) {
                    for (Extension targetExt : containerAvailableExtensions) {
                        if (!targetExt.isCompatibleWith(requiredExt)) continue;
                        requiredExt.setFulfilled(true);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                log.info((Object)sm.getString("extensionValidator.extension-not-found-error", appName, mre.getResourceName(), requiredExt.getExtensionName()));
                passes = false;
                ++failureCount;
            }
        }
        if (!passes) {
            log.info((Object)sm.getString("extensionValidator.extension-validation-error", appName, failureCount + ""));
        }
        return passes;
    }

    private static ArrayList<Extension> buildAvailableExtensionsList(ArrayList<ManifestResource> resources) {
        ArrayList<Extension> availableList = null;
        for (ManifestResource mre : resources) {
            ArrayList<Extension> list = mre.getAvailableExtensions();
            if (list == null) continue;
            for (Extension ext : list) {
                if (availableList == null) {
                    availableList = new ArrayList<Extension>();
                    availableList.add(ext);
                    continue;
                }
                availableList.add(ext);
            }
        }
        return availableList;
    }

    private static Manifest getManifest(InputStream inStream) throws IOException {
        Manifest manifest = null;
        try (JarInputStream jin = new JarInputStream(inStream);){
            manifest = jin.getManifest();
        }
        return manifest;
    }

    private static void addFolderList(String property) {
        String extensionsDir = System.getProperty(property);
        if (extensionsDir != null) {
            StringTokenizer extensionsTok = new StringTokenizer(extensionsDir, File.pathSeparator);
            while (extensionsTok.hasMoreTokens()) {
                File[] files;
                File targetDir = new File(extensionsTok.nextToken());
                if (!targetDir.isDirectory() || (files = targetDir.listFiles()) == null) continue;
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !files[i].isFile()) continue;
                    try {
                        ExtensionValidator.addSystemResource(files[i]);
                        continue;
                    }
                    catch (IOException e) {
                        log.error((Object)sm.getString("extensionValidator.failload", files[i]), (Throwable)e);
                    }
                }
            }
        }
    }

    static {
        String systemClasspath = System.getProperty("java.class.path");
        StringTokenizer strTok = new StringTokenizer(systemClasspath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            File item;
            String classpathItem = strTok.nextToken();
            if (!classpathItem.toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(item = new File(classpathItem)).isFile()) continue;
            try {
                ExtensionValidator.addSystemResource(item);
            }
            catch (IOException e) {
                log.error((Object)sm.getString("extensionValidator.failload", item), (Throwable)e);
            }
        }
        ExtensionValidator.addFolderList("java.ext.dirs");
    }
}

