/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.reorg.NewNameQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.CopyRefactoring;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ReorgCopyStarter {
    private final JavaCopyProcessor fCopyProcessor;

    public static ReorgCopyStarter create(IJavaElement[] javaElements, IResource[] resources, IReorgDestination destination) throws JavaModelException {
        Assert.isNotNull((Object)javaElements);
        Assert.isNotNull((Object)resources);
        if (destination == null) {
            return null;
        }
        IReorgPolicy.ICopyPolicy copyPolicy = ReorgPolicyFactory.createCopyPolicy(resources, javaElements);
        if (!copyPolicy.canEnable()) {
            return null;
        }
        JavaCopyProcessor copyProcessor = new JavaCopyProcessor(copyPolicy);
        if (!copyProcessor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgCopyStarter(copyProcessor);
    }

    private ReorgCopyStarter(JavaCopyProcessor copyProcessor) {
        Assert.isNotNull((Object)copyProcessor);
        this.fCopyProcessor = copyProcessor;
    }

    public void run(Shell parent) throws InterruptedException, InvocationTargetException {
        IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.fCopyProcessor.setNewNameQueries(new NewNameQueries(parent));
        this.fCopyProcessor.setReorgQueries(new ReorgQueries(parent));
        CopyRefactoring refactoring = new CopyRefactoring((CopyProcessor)this.fCopyProcessor);
        new RefactoringExecutionHelper((Refactoring)refactoring, RefactoringCore.getConditionCheckingFailedSeverity(), this.fCopyProcessor.getSaveMode(), parent, (IRunnableContext)context).perform(false, false);
    }
}

