/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;

public class JavaUIPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        EditorsUI.useAnnotationsPreferencePage((IPreferenceStore)store);
        EditorsUI.useQuickDiffPreferencePage((IPreferenceStore)store);
        PreferenceConstants.initializeDefaultValues(store);
    }

    public static void setThemeBasedPreferences(IPreferenceStore store, boolean fireEvent) {
        ColorRegistry registry = null;
        if (PlatformUI.isWorkbenchRunning()) {
            registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        }
        JavaUIPreferenceInitializer.setDefault(store, "java_string", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_string", new RGB(42, 0, 255)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_default", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_default", new RGB(0, 0, 0)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_multi_line_comment", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_multi_line_comment", new RGB(63, 127, 95)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_single_line_comment", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_single_line_comment", new RGB(63, 127, 95)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_keyword", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_keyword", new RGB(127, 0, 85)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_keyword_return", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_keyword_return", new RGB(127, 0, 85)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_operator", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_operator", new RGB(0, 0, 0)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_bracket", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_bracket", new RGB(0, 0, 0)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "matchingBracketsColor", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.matchingBracketsColor", new RGB(127, 0, 85)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_comment_task_tag", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_comment_task_tag", new RGB(127, 159, 191)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_doc_keyword", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_doc_keyword", new RGB(127, 159, 191)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_doc_tag", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_doc_tag", new RGB(127, 127, 159)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_doc_link", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_doc_link", new RGB(63, 63, 191)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "java_doc_default", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.java_doc_default", new RGB(63, 95, 191)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "content_assist_parameters_background", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.content_assist_parameters_background", new RGB(255, 255, 255)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "content_assist_parameters_foreground", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.content_assist_parameters_foreground", new RGB(0, 0, 0)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "content_assist_completion_replacement_background", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.content_assist_completion_replacement_background", new RGB(255, 255, 0)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "content_assist_completion_replacement_foreground", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.content_assist_completion_replacement_foreground", new RGB(255, 0, 0)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "pf_coloring_key", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.pf_coloring_key", new RGB(0, 0, 0)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "pf_coloring_value", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.pf_coloring_value", new RGB(42, 0, 255)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "pf_coloring_assignment", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.pf_coloring_assignment", new RGB(0, 0, 0)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "pf_coloring_argument", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.pf_coloring_argument", new RGB(127, 0, 85)), fireEvent);
        JavaUIPreferenceInitializer.setDefault(store, "pf_coloring_comment", JavaUIPreferenceInitializer.findRGB(registry, "org.eclipse.jdt.ui.pf_coloring_comment", new RGB(63, 127, 95)), fireEvent);
    }

    private static void setDefault(IPreferenceStore store, String key, RGB newValue, boolean fireEvent) {
        if (!fireEvent) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
            return;
        }
        RGB oldValue = null;
        if (store.isDefault(key)) {
            oldValue = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
        if (oldValue != null && !oldValue.equals((Object)newValue)) {
            store.firePropertyChangeEvent(key, (Object)oldValue, (Object)newValue);
        }
    }

    private static RGB findRGB(ColorRegistry registry, String key, RGB defaultRGB) {
        if (registry == null) {
            return defaultRGB;
        }
        RGB rgb = registry.getRGB(key);
        if (rgb != null) {
            return rgb;
        }
        return defaultRGB;
    }
}

