/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.document.DOMMessages;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.ReadOnlyController;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeContainer
extends NodeImpl
implements Node,
NodeList {
    private NodeList childNodesCache = null;
    private boolean fChildEditable = true;
    NodeImpl firstChild = null;
    NodeImpl lastChild = null;
    Object lockObject = new byte[0];

    protected NodeContainer() {
    }

    protected NodeContainer(NodeContainer that) {
        super(that);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    protected void cloneChildNodes(Node newParent, boolean deep) {
        if (newParent == null || newParent == this) {
            return;
        }
        if (!(newParent instanceof NodeContainer)) {
            return;
        }
        NodeContainer container = (NodeContainer)newParent;
        container.removeChildNodes();
        Node child = this.getFirstChild();
        while (child != null) {
            Node cloned = child.cloneNode(deep);
            if (cloned != null) {
                container.appendChild(cloned);
            }
            child = child.getNextSibling();
        }
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        if (this.firstChild == null) {
            return 0;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.childNodesCache == null) {
                this.childNodesCache = new ChildNodesCache();
            }
            return this.childNodesCache.getLength();
        }
    }

    public String getSource() {
        String source;
        String source2;
        StringBuffer buffer = new StringBuffer();
        IStructuredDocumentRegion startStructuredDocumentRegion = this.getStartStructuredDocumentRegion();
        if (startStructuredDocumentRegion != null && (source2 = startStructuredDocumentRegion.getText()) != null) {
            buffer.append(source2);
        }
        NodeImpl child = this.firstChild;
        while (child != null) {
            source = child.getSource();
            if (source != null) {
                buffer.append(source);
            }
            child = (NodeImpl)child.getNextSibling();
        }
        IStructuredDocumentRegion endStructuredDocumentRegion = this.getEndStructuredDocumentRegion();
        if (endStructuredDocumentRegion != null && (source = endStructuredDocumentRegion.getText()) != null) {
            buffer.append(source);
        }
        return buffer.toString();
    }

    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild == null) {
            return null;
        }
        if (refChild != null && refChild.getParentNode() != this) {
            throw new DOMException(8, DOMMessages.NOT_FOUND_ERR);
        }
        if (!this.isChildEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        if (newChild == refChild) {
            return newChild;
        }
        if (this.isParent(newChild)) {
            throw new DOMException(3, NLS.bind((String)DOMMessages.HIERARCHY_REQUEST_ERR_WITH_DETAILS, (Object[])new String[]{newChild.getNodeName(), refChild != null ? refChild.getNodeName() : "<null>"}));
        }
        if (newChild.getNodeType() == 11) {
            Node child = newChild.getFirstChild();
            while (child != null) {
                newChild.removeChild(child);
                this.insertBefore(child, refChild);
                child = newChild.getFirstChild();
            }
            return newChild;
        }
        Object child = this.lockObject;
        synchronized (child) {
            this.childNodesCache = null;
        }
        child = (NodeImpl)newChild;
        NodeImpl next = (NodeImpl)refChild;
        NodeImpl prev = null;
        Node oldParent = ((NodeImpl)child).getParentNode();
        if (oldParent != null) {
            oldParent.removeChild((Node)child);
        }
        if (next == null) {
            prev = this.lastChild;
            this.lastChild = child;
        } else {
            prev = (NodeImpl)next.getPreviousSibling();
            next.setPreviousSibling((Node)child);
        }
        if (prev == null) {
            this.firstChild = child;
        } else {
            prev.setNextSibling((Node)child);
        }
        ((NodeImpl)child).setPreviousSibling(prev);
        ((NodeImpl)child).setNextSibling(next);
        ((NodeImpl)child).setParentNode(this);
        if (((NodeImpl)child).getOwnerDocument() == null) {
            if (this.getNodeType() == 9) {
                ((NodeImpl)child).setOwnerDocument((Document)((Object)this));
            } else {
                ((NodeImpl)child).setOwnerDocument(this.getOwnerDocument());
            }
        }
        this.notifyChildReplaced((Node)child, null);
        return child;
    }

    public boolean isChildEditable() {
        DOMModelImpl model;
        if (!this.fChildEditable && (model = (DOMModelImpl)this.getModel()) != null && model.isReparsing()) {
            return true;
        }
        return this.fChildEditable;
    }

    public boolean isContainer() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node item(int index) {
        if (this.firstChild == null) {
            return null;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.childNodesCache == null) {
                this.childNodesCache = new ChildNodesCache();
            }
            return this.childNodesCache.item(index);
        }
    }

    protected void notifyChildReplaced(Node newChild, Node oldChild) {
        DocumentImpl document = (DocumentImpl)this.getContainerDocument();
        if (document == null) {
            return;
        }
        this.syncChildEditableState(newChild);
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.childReplaced(this, newChild, oldChild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild == null) {
            return null;
        }
        if (oldChild.getParentNode() != this) {
            throw new DOMException(8, DOMMessages.NOT_FOUND_ERR);
        }
        if (!this.isChildEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        Object object = this.lockObject;
        synchronized (object) {
            this.childNodesCache = null;
        }
        NodeImpl child = (NodeImpl)oldChild;
        NodeImpl prev = (NodeImpl)child.getPreviousSibling();
        NodeImpl next = (NodeImpl)child.getNextSibling();
        child.setEditable(true, true);
        if (prev == null) {
            this.firstChild = next;
        } else {
            prev.setNextSibling(next);
        }
        if (next == null) {
            this.lastChild = prev;
        } else {
            next.setPreviousSibling(prev);
        }
        child.setPreviousSibling(null);
        child.setNextSibling(null);
        child.setParentNode(null);
        this.notifyChildReplaced(null, child);
        return child;
    }

    public void removeChildNodes() {
        if (!this.isChildEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        Node nextChild = null;
        Node child = this.getFirstChild();
        while (child != null) {
            nextChild = child.getNextSibling();
            this.removeChild(child);
            child = nextChild;
        }
    }

    public DocumentFragment removeChildNodes(Node firstChild, Node lastChild) {
        if (!this.hasChildNodes()) {
            return null;
        }
        if (!this.isChildEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        Document document = null;
        document = this.getNodeType() == 9 ? (Document)((Object)this) : this.getOwnerDocument();
        if (document == null) {
            return null;
        }
        DocumentFragment fragment = document.createDocumentFragment();
        if (fragment == null) {
            return null;
        }
        if (firstChild == null) {
            firstChild = this.getFirstChild();
        }
        if (lastChild == null) {
            lastChild = this.getLastChild();
        }
        Node nextChild = null;
        Node child = firstChild;
        while (child != null) {
            nextChild = child.getNextSibling();
            this.removeChild(child);
            fragment.appendChild(child);
            if (child == lastChild) break;
            child = nextChild;
        }
        return fragment;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (!this.isChildEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        if (oldChild == null || oldChild == newChild) {
            return newChild;
        }
        if (newChild != null) {
            this.insertBefore(newChild, oldChild);
        }
        return this.removeChild(oldChild);
    }

    public void setChildEditable(boolean editable) {
        if (this.fChildEditable == editable) {
            return;
        }
        ReadOnlyController roc = ReadOnlyController.getInstance();
        if (editable) {
            Node node = this.getFirstChild();
            while (node != null) {
                roc.unlockNode((IDOMNode)node);
                node = node.getNextSibling();
            }
        } else {
            Node node = this.getFirstChild();
            while (node != null) {
                roc.lockNode((IDOMNode)node);
                node = node.getNextSibling();
            }
        }
        this.fChildEditable = editable;
        this.notifyEditableChanged();
    }

    protected void syncChildEditableState(Node child) {
        ReadOnlyController roc = ReadOnlyController.getInstance();
        if (this.fChildEditable) {
            roc.unlockNode((NodeImpl)child);
        } else {
            roc.lockNode((NodeImpl)child);
        }
    }

    private boolean isParent(Node possibleParent) {
        Node parent = this.getParentNode();
        while (parent != null && parent != possibleParent) {
            parent = parent.getParentNode();
        }
        return parent == possibleParent;
    }

    private class ChildNodesCache
    implements NodeList {
        private Node curChild = null;
        private int curIndex = -1;
        private int length = 0;

        ChildNodesCache() {
            this.initializeCache();
        }

        public int getLength() {
            return this.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeCache() {
            Object object = NodeContainer.this.lockObject;
            synchronized (object) {
                Node child = NodeContainer.this.firstChild;
                while (child != null) {
                    ++this.length;
                    child = child.getNextSibling();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Node item(int index) {
            var2_2 = NodeContainer.this.lockObject;
            synchronized (var2_2) {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                if (this.length != 0) break block12;
                                return null;
                            }
                            if (index >= 0) break block13;
                            return null;
                        }
                        if (index < this.length) break block14;
                        return null;
                    }
                    if (this.curIndex < 0) {
                        if (index * 2 >= this.length) {
                            this.curIndex = this.length - 1;
                            this.curChild = NodeContainer.this.lastChild;
                        } else {
                            this.curIndex = 0;
                            this.curChild = NodeContainer.this.firstChild;
                        }
                    }
                    if (index == this.curIndex) {
                        return this.curChild;
                    }
                    if (index <= this.curIndex) ** GOTO lbl33
                    while (index > this.curIndex) {
                        ++this.curIndex;
                        this.curChild = this.curChild.getNextSibling();
                    }
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        --this.curIndex;
                        this.curChild = this.curChild.getPreviousSibling();
lbl33:
                        // 2 sources

                        ** while (index < this.curIndex)
                    }
                }
                return this.curChild;
            }
        }
    }
}

