/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.catalog.util;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Collection;

public class CatalogStatistics {
    public static final byte BOOLEAN_TYPE = 0;
    public static final byte INTEGER_TYPE = 1;
    public static final byte STRING_TYPE = 2;
    public static final byte FLOAT_TYPE = 3;
    public static final byte BIGINT_TYPE = 4;
    public static final byte TIMESTAMP_TYPE = 5;
    public static final byte COLLECTION_TYPE = 6;
    private String id;
    private String name;
    private String desc;
    private String syscatalog;
    private boolean booleanValue;
    private int intValue;
    private String stringValue;
    private float floatValue;
    private BigInteger bigIntegerValue;
    private Timestamp timestampValue;
    private Collection collectionValue;
    private byte type;
    private String forBitData;
    private boolean forBitDataFromNumeric = false;

    public CatalogStatistics(String id, String name, String description, boolean initialValue, String syscatalog) {
        this.init(id, name, description, initialValue, syscatalog);
    }

    public CatalogStatistics(String id, String name, String description, String initialValue, String syscatalog) {
        this.init(id, name, description, initialValue, syscatalog);
    }

    public CatalogStatistics(String id, String name, String description, int initialValue, String syscatalog) {
        this.init(id, name, description, initialValue, syscatalog);
    }

    public CatalogStatistics(String id, String name, String description, float initialValue, String syscatalog) {
        this.init(id, name, description, initialValue, syscatalog);
    }

    public CatalogStatistics(String id, String name, String description, BigInteger initialValue, String syscatalog) {
        this.init(id, name, description, initialValue, syscatalog);
    }

    public CatalogStatistics(String id, String name, String description, Timestamp initialValue, String syscatalog) {
        this.init(id, name, description, initialValue, syscatalog);
    }

    public CatalogStatistics(String id, String name, String description, Collection initialValue, String syscatalog) {
        this.init(id, name, description, initialValue, syscatalog);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getSyscatalog() {
        return this.syscatalog;
    }

    public byte getType() {
        return this.type;
    }

    public boolean getBoolean() {
        if (this.type != 0) {
            throw new RuntimeException("Invalid Call");
        }
        return this.booleanValue;
    }

    public void setBoolean(boolean value) {
        if (this.type != 0) {
            throw new RuntimeException("Invalid Call");
        }
        this.booleanValue = value;
    }

    public int getInt() {
        if (this.type != 1) {
            throw new RuntimeException("Invalid Call");
        }
        return this.intValue;
    }

    public void setInt(int value) {
        if (this.type != 1) {
            throw new RuntimeException("Invalid Call");
        }
        this.intValue = value;
    }

    public String getString() {
        if (this.type != 2) {
            throw new RuntimeException("Invalid Call");
        }
        return this.stringValue;
    }

    public void setString(String value) {
        if (this.type != 2) {
            throw new RuntimeException("Invalid Call");
        }
        this.stringValue = value;
    }

    public float getFloat() {
        if (this.type != 3) {
            throw new RuntimeException("Invalid Call");
        }
        return this.floatValue;
    }

    public void setFloat(float value) {
        if (this.type != 3) {
            throw new RuntimeException("Invalid Call");
        }
        this.floatValue = value;
    }

    public BigInteger getBiginteger() {
        if (this.type != 4) {
            throw new RuntimeException("Invalid Call");
        }
        return this.bigIntegerValue;
    }

    public void setBigInteger(BigInteger value) {
        if (this.type != 4) {
            throw new RuntimeException("Invalid Call");
        }
        this.bigIntegerValue = value;
    }

    public Timestamp getTimestamp() {
        if (this.type != 5) {
            throw new RuntimeException("Invalid Call");
        }
        return this.timestampValue;
    }

    public void setTimestampr(Timestamp value) {
        if (this.type != 5) {
            throw new RuntimeException("Invalid Call");
        }
        this.timestampValue = value;
    }

    public Collection getCollection() {
        if (this.type != 6) {
            throw new RuntimeException("Invalid Call");
        }
        return this.collectionValue;
    }

    public void setComplex(Collection value) {
        if (this.type != 6) {
            throw new RuntimeException("Invalid Call");
        }
        this.collectionValue = value;
    }

    private void init(String id, String name, String description, boolean initialValue, String syscatalog) {
        this.type = 0;
        this.id = id;
        this.name = name;
        this.desc = description;
        this.syscatalog = syscatalog;
        this.booleanValue = initialValue;
    }

    public void init(String id, String name, String description, String initialValue, String syscatalog) {
        this.type = (byte)2;
        this.id = id;
        this.name = name;
        this.desc = description;
        this.syscatalog = syscatalog;
        this.stringValue = initialValue;
    }

    public void init(String id, String name, String description, int initialValue, String syscatalog) {
        this.type = 1;
        this.id = id;
        this.name = name;
        this.desc = description;
        this.syscatalog = syscatalog;
        this.intValue = initialValue;
    }

    public void init(String id, String name, String description, float initialValue, String syscatalog) {
        this.type = (byte)3;
        this.id = id;
        this.name = name;
        this.desc = description;
        this.syscatalog = syscatalog;
        this.floatValue = initialValue;
    }

    public void init(String id, String name, String description, BigInteger initialValue, String syscatalog) {
        this.type = (byte)4;
        this.id = id;
        this.name = name;
        this.desc = description;
        this.syscatalog = syscatalog;
        this.bigIntegerValue = initialValue;
    }

    public void init(String id, String name, String description, Timestamp initialValue, String syscatalog) {
        this.type = (byte)5;
        this.id = id;
        this.name = name;
        this.desc = description;
        this.syscatalog = syscatalog;
        this.timestampValue = initialValue;
    }

    public void init(String id, String name, String description, Collection initialValue, String syscatalog) {
        this.type = (byte)6;
        this.id = id;
        this.name = name;
        this.desc = description;
        this.syscatalog = syscatalog;
        this.collectionValue = initialValue;
    }

    public String toString() {
        switch (this.getType()) {
            case 0: {
                return Boolean.toString(this.booleanValue);
            }
            case 1: {
                return Integer.toString(this.intValue);
            }
            case 2: {
                return this.stringValue;
            }
            case 3: {
                return Float.toString(this.floatValue);
            }
            case 5: {
                return this.timestampValue.toString();
            }
            case 4: {
                return this.bigIntegerValue.toString();
            }
        }
        return "";
    }

    public String getForBitData() {
        return this.forBitData;
    }

    public void setForBitData(String fotBitData) {
        this.forBitData = fotBitData;
    }

    public void setForBitDataFromNumeric() {
        this.forBitDataFromNumeric = true;
    }

    public boolean isForBitDataFromNumeric() {
        return this.forBitDataFromNumeric;
    }
}

