/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

abstract class BaseNodeDeserializer<T extends JsonNode>
extends StdDeserializer<T> {
    public BaseNodeDeserializer(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected void _reportProblem(JsonParser jsonParser, String string) throws JsonMappingException {
        throw new JsonMappingException(string, jsonParser.getTokenLocation());
    }

    @Deprecated
    protected void _handleDuplicateField(String string, ObjectNode objectNode, JsonNode jsonNode, JsonNode jsonNode2) throws JsonProcessingException {
    }

    protected void _handleDuplicateField(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, String string, ObjectNode objectNode, JsonNode jsonNode, JsonNode jsonNode2) throws JsonProcessingException {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            this._reportProblem(jsonParser, "Duplicate field '" + string + "' for ObjectNode: not allowed when FAIL_ON_READING_DUP_TREE_KEY enabled");
        }
        this._handleDuplicateField(string, objectNode, jsonNode, jsonNode2);
    }

    protected final ObjectNode deserializeObject(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException, JsonProcessingException {
        ObjectNode objectNode = jsonNodeFactory.objectNode();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        while (jsonToken == JsonToken.FIELD_NAME) {
            JsonNode jsonNode;
            String string = jsonParser.getCurrentName();
            switch (jsonParser.nextToken()) {
                case START_OBJECT: {
                    jsonNode = this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case START_ARRAY: {
                    jsonNode = this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory);
                    break;
                }
                case VALUE_STRING: {
                    jsonNode = jsonNodeFactory.textNode(jsonParser.getText());
                    break;
                }
                default: {
                    jsonNode = this.deserializeAny(jsonParser, deserializationContext, jsonNodeFactory);
                }
            }
            JsonNode jsonNode2 = objectNode.replace(string, jsonNode);
            if (jsonNode2 != null) {
                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, string, objectNode, jsonNode2, jsonNode);
            }
            jsonToken = jsonParser.nextToken();
        }
        return objectNode;
    }

    protected final ArrayNode deserializeArray(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException, JsonProcessingException {
        ArrayNode arrayNode = jsonNodeFactory.arrayNode();
        block6: while (true) {
            JsonToken jsonToken;
            if ((jsonToken = jsonParser.nextToken()) == null) {
                throw deserializationContext.mappingException("Unexpected end-of-input when binding data into ArrayNode");
            }
            switch (jsonToken) {
                case START_OBJECT: {
                    arrayNode.add(this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block6;
                }
                case START_ARRAY: {
                    arrayNode.add(this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory));
                    continue block6;
                }
                case END_ARRAY: {
                    return arrayNode;
                }
                case VALUE_STRING: {
                    arrayNode.add(jsonNodeFactory.textNode(jsonParser.getText()));
                    continue block6;
                }
            }
            arrayNode.add(this.deserializeAny(jsonParser, deserializationContext, jsonNodeFactory));
        }
    }

    protected final JsonNode deserializeAny(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) throws IOException, JsonProcessingException {
        switch (jsonParser.getCurrentToken()) {
            case START_OBJECT: 
            case END_OBJECT: {
                return this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case START_ARRAY: {
                return this.deserializeArray(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case FIELD_NAME: {
                return this.deserializeObject(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case VALUE_EMBEDDED_OBJECT: {
                Object object = jsonParser.getEmbeddedObject();
                if (object == null) {
                    return jsonNodeFactory.nullNode();
                }
                Class<?> clazz = object.getClass();
                if (clazz == byte[].class) {
                    return jsonNodeFactory.binaryNode((byte[])object);
                }
                if (JsonNode.class.isAssignableFrom(clazz)) {
                    return (JsonNode)object;
                }
                return jsonNodeFactory.pojoNode(object);
            }
            case VALUE_STRING: {
                return jsonNodeFactory.textNode(jsonParser.getText());
            }
            case VALUE_NUMBER_INT: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.BIG_INTEGER || deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
                }
                if (numberType == JsonParser.NumberType.INT) {
                    return jsonNodeFactory.numberNode(jsonParser.getIntValue());
                }
                return jsonNodeFactory.numberNode(jsonParser.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.BIG_DECIMAL || deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
                }
                return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
            }
            case VALUE_TRUE: {
                return jsonNodeFactory.booleanNode(true);
            }
            case VALUE_FALSE: {
                return jsonNodeFactory.booleanNode(false);
            }
            case VALUE_NULL: {
                return jsonNodeFactory.nullNode();
            }
        }
        throw deserializationContext.mappingException(this.handledType());
    }
}

