/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.vote;

import java.util.Collection;
import java.util.Set;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class ClientScopeVoter
implements AccessDecisionVoter<Object> {
    private String clientHasScope = "CLIENT_HAS_SCOPE";
    private boolean throwException = true;
    private ClientDetailsService clientDetailsService;
    private boolean clientAuthoritiesAreScopes = true;

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public void setClientAuthoritiesAreScopes(boolean clientAuthoritiesAreScopes) {
        this.clientAuthoritiesAreScopes = clientAuthoritiesAreScopes;
    }

    public void setDenyAccess(String denyAccess) {
        this.clientHasScope = denyAccess;
    }

    public boolean supports(ConfigAttribute attribute) {
        return this.clientHasScope.equals(attribute.getAttribute());
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        int result = 0;
        if (!(authentication instanceof OAuth2Authentication)) {
            return result;
        }
        OAuth2Authentication oauth2Authentication = (OAuth2Authentication)authentication;
        OAuth2Request clientAuthentication = oauth2Authentication.getOAuth2Request();
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientAuthentication.getClientId());
        Set scopes = clientAuthentication.getScope();
        if (oauth2Authentication.isClientOnly() && this.clientAuthoritiesAreScopes) {
            scopes = AuthorityUtils.authorityListToSet(clientAuthentication.getAuthorities());
        }
        for (ConfigAttribute attribute : attributes) {
            if (!this.supports(attribute)) continue;
            result = 1;
            for (String scope : scopes) {
                if (client.getScope().contains(scope)) continue;
                result = -1;
                break;
            }
            if (result == -1 && this.throwException) {
                InsufficientScopeException failure = new InsufficientScopeException("Insufficient scope for this resource", client.getScope());
                throw new AccessDeniedException(failure.getMessage(), (Throwable)failure);
            }
            return result;
        }
        return result;
    }
}

