/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.xml;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.config.xml.ProviderBeanDefinitionParser;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.approval.DefaultUserApprovalHandler;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenGranter;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeTokenGranter;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.AuthorizationEndpoint;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpoint;
import org.springframework.security.oauth2.provider.endpoint.WhitelabelApprovalEndpoint;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenGranter;
import org.springframework.security.oauth2.provider.password.ResourceOwnerPasswordTokenGranter;
import org.springframework.security.oauth2.provider.refresh.RefreshTokenGranter;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestValidator;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AuthorizationServerBeanDefinitionParser
extends ProviderBeanDefinitionParser {
    @Override
    protected AbstractBeanDefinition parseEndpointAndReturnFilter(Element element, ParserContext parserContext, String tokenServicesRef, String serializerRef) {
        String clientDetailsRef = element.getAttribute("client-details-service-ref");
        String oAuth2RequestFactoryRef = element.getAttribute("authorization-request-manager-ref");
        String tokenEndpointUrl = element.getAttribute("token-endpoint-url");
        String authorizationEndpointUrl = element.getAttribute("authorization-endpoint-url");
        String tokenGranterRef = element.getAttribute("token-granter-ref");
        String redirectStrategyRef = element.getAttribute("redirect-strategy-ref");
        String userApprovalHandlerRef = element.getAttribute("user-approval-handler-ref");
        String approvalPage = element.getAttribute("user-approval-page");
        String errorPage = element.getAttribute("error-page");
        String approvalParameter = element.getAttribute("approval-parameter-name");
        String redirectResolverRef = element.getAttribute("redirect-resolver-ref");
        String oAuth2RequestValidatorRef = element.getAttribute("request-validator-ref");
        BeanDefinitionBuilder authorizationEndpointBean = BeanDefinitionBuilder.rootBeanDefinition(AuthorizationEndpoint.class);
        if (!StringUtils.hasText((String)clientDetailsRef)) {
            parserContext.getReaderContext().error("ClientDetailsService must be provided", (Object)element);
            return null;
        }
        if (!StringUtils.hasText((String)oAuth2RequestValidatorRef)) {
            oAuth2RequestValidatorRef = "defaultOAuth2RequestValidator";
            BeanDefinitionBuilder oAuth2RequestValidator = BeanDefinitionBuilder.rootBeanDefinition(DefaultOAuth2RequestValidator.class);
            parserContext.getRegistry().registerBeanDefinition(oAuth2RequestValidatorRef, (BeanDefinition)oAuth2RequestValidator.getBeanDefinition());
        }
        authorizationEndpointBean.addPropertyReference("oAuth2RequestValidator", oAuth2RequestValidatorRef);
        if (!StringUtils.hasText((String)oAuth2RequestFactoryRef)) {
            oAuth2RequestFactoryRef = "oAuth2AuthorizationRequestManager";
            BeanDefinitionBuilder oAuth2RequestManager = BeanDefinitionBuilder.rootBeanDefinition(DefaultOAuth2RequestFactory.class);
            oAuth2RequestManager.addConstructorArgReference(clientDetailsRef);
            parserContext.getRegistry().registerBeanDefinition(oAuth2RequestFactoryRef, (BeanDefinition)oAuth2RequestManager.getBeanDefinition());
        }
        ManagedList tokenGranters = null;
        if (!StringUtils.hasText((String)tokenGranterRef)) {
            tokenGranterRef = "oauth2TokenGranter";
            BeanDefinitionBuilder tokenGranterBean = BeanDefinitionBuilder.rootBeanDefinition(CompositeTokenGranter.class);
            parserContext.getRegistry().registerBeanDefinition(tokenGranterRef, (BeanDefinition)tokenGranterBean.getBeanDefinition());
            tokenGranters = new ManagedList();
            tokenGranterBean.addConstructorArgValue((Object)tokenGranters);
        }
        authorizationEndpointBean.addPropertyReference("tokenGranter", tokenGranterRef);
        boolean registerAuthorizationEndpoint = false;
        Element authorizationCodeElement = DomUtils.getChildElementByTagName((Element)element, (String)"authorization-code");
        if (authorizationCodeElement != null && !"true".equalsIgnoreCase(authorizationCodeElement.getAttribute("disabled"))) {
            String authorizationCodeServices = authorizationCodeElement.getAttribute("authorization-code-services-ref");
            String clientTokenCacheRef = authorizationCodeElement.getAttribute("client-token-cache-ref");
            BeanDefinitionBuilder authorizationCodeTokenGranterBean = BeanDefinitionBuilder.rootBeanDefinition(AuthorizationCodeTokenGranter.class);
            if (StringUtils.hasText((String)tokenServicesRef)) {
                authorizationCodeTokenGranterBean.addConstructorArgReference(tokenServicesRef);
            }
            if (!StringUtils.hasText((String)authorizationCodeServices)) {
                authorizationCodeServices = "oauth2AuthorizationCodeServices";
                BeanDefinitionBuilder authorizationCodeServicesBean = BeanDefinitionBuilder.rootBeanDefinition(InMemoryAuthorizationCodeServices.class);
                parserContext.getRegistry().registerBeanDefinition(authorizationCodeServices, (BeanDefinition)authorizationCodeServicesBean.getBeanDefinition());
            }
            authorizationEndpointBean.addPropertyReference("authorizationCodeServices", authorizationCodeServices);
            authorizationCodeTokenGranterBean.addConstructorArgReference(authorizationCodeServices);
            authorizationCodeTokenGranterBean.addConstructorArgReference(clientDetailsRef);
            authorizationCodeTokenGranterBean.addConstructorArgReference(oAuth2RequestFactoryRef);
            if (StringUtils.hasText((String)clientTokenCacheRef)) {
                authorizationEndpointBean.addPropertyReference("clientTokenCache", clientTokenCacheRef);
            }
            if (StringUtils.hasText((String)oAuth2RequestFactoryRef)) {
                authorizationEndpointBean.addPropertyReference("oAuth2RequestFactory", oAuth2RequestFactoryRef);
            }
            if (tokenGranters != null) {
                tokenGranters.add((Object)authorizationCodeTokenGranterBean.getBeanDefinition());
            }
            registerAuthorizationEndpoint = true;
        }
        if (tokenGranters != null) {
            Element clientPasswordElement;
            Element clientCredentialsElement;
            Element implicitElement;
            Element refreshTokenElement = DomUtils.getChildElementByTagName((Element)element, (String)"refresh-token");
            if (refreshTokenElement != null && !"true".equalsIgnoreCase(refreshTokenElement.getAttribute("disabled"))) {
                BeanDefinitionBuilder refreshTokenGranterBean = BeanDefinitionBuilder.rootBeanDefinition(RefreshTokenGranter.class);
                refreshTokenGranterBean.addConstructorArgReference(tokenServicesRef);
                refreshTokenGranterBean.addConstructorArgReference(clientDetailsRef);
                refreshTokenGranterBean.addConstructorArgReference(oAuth2RequestFactoryRef);
                tokenGranters.add((Object)refreshTokenGranterBean.getBeanDefinition());
            }
            if ((implicitElement = DomUtils.getChildElementByTagName((Element)element, (String)"implicit")) != null && !"true".equalsIgnoreCase(implicitElement.getAttribute("disabled"))) {
                BeanDefinitionBuilder implicitGranterBean = BeanDefinitionBuilder.rootBeanDefinition(ImplicitTokenGranter.class);
                implicitGranterBean.addConstructorArgReference(tokenServicesRef);
                implicitGranterBean.addConstructorArgReference(clientDetailsRef);
                implicitGranterBean.addConstructorArgReference(oAuth2RequestFactoryRef);
                tokenGranters.add((Object)implicitGranterBean.getBeanDefinition());
                registerAuthorizationEndpoint = true;
            }
            if ((clientCredentialsElement = DomUtils.getChildElementByTagName((Element)element, (String)"client-credentials")) != null && !"true".equalsIgnoreCase(clientCredentialsElement.getAttribute("disabled"))) {
                BeanDefinitionBuilder clientCredentialsGranterBean = BeanDefinitionBuilder.rootBeanDefinition(ClientCredentialsTokenGranter.class);
                clientCredentialsGranterBean.addConstructorArgReference(tokenServicesRef);
                clientCredentialsGranterBean.addConstructorArgReference(clientDetailsRef);
                clientCredentialsGranterBean.addConstructorArgReference(oAuth2RequestFactoryRef);
                tokenGranters.add((Object)clientCredentialsGranterBean.getBeanDefinition());
            }
            if ((clientPasswordElement = DomUtils.getChildElementByTagName((Element)element, (String)"password")) != null && !"true".equalsIgnoreCase(clientPasswordElement.getAttribute("disabled"))) {
                BeanDefinitionBuilder clientPasswordTokenGranter = BeanDefinitionBuilder.rootBeanDefinition(ResourceOwnerPasswordTokenGranter.class);
                String authenticationManagerRef = clientPasswordElement.getAttribute("authentication-manager-ref");
                if (!StringUtils.hasText((String)authenticationManagerRef)) {
                    authenticationManagerRef = "org.springframework.security.authenticationManager";
                }
                clientPasswordTokenGranter.addConstructorArgReference(authenticationManagerRef);
                clientPasswordTokenGranter.addConstructorArgReference(tokenServicesRef);
                clientPasswordTokenGranter.addConstructorArgReference(clientDetailsRef);
                clientPasswordTokenGranter.addConstructorArgReference(oAuth2RequestFactoryRef);
                tokenGranters.add((Object)clientPasswordTokenGranter.getBeanDefinition());
            }
            List customGrantElements = DomUtils.getChildElementsByTagName((Element)element, (String)"custom-grant");
            for (Element customGrantElement : customGrantElements) {
                if ("true".equalsIgnoreCase(customGrantElement.getAttribute("disabled"))) continue;
                String customGranterRef = customGrantElement.getAttribute("token-granter-ref");
                tokenGranters.add((Object)new RuntimeBeanReference(customGranterRef));
            }
        }
        if (registerAuthorizationEndpoint) {
            BeanDefinitionBuilder approvalEndpointBean = BeanDefinitionBuilder.rootBeanDefinition(WhitelabelApprovalEndpoint.class);
            parserContext.getRegistry().registerBeanDefinition("oauth2ApprovalEndpoint", (BeanDefinition)approvalEndpointBean.getBeanDefinition());
            if (!StringUtils.hasText((String)clientDetailsRef)) {
                parserContext.getReaderContext().error("A client details service is mandatory", (Object)element);
            }
            if (StringUtils.hasText((String)redirectStrategyRef)) {
                authorizationEndpointBean.addPropertyReference("redirectStrategy", redirectStrategyRef);
            }
            if (StringUtils.hasText((String)userApprovalHandlerRef)) {
                authorizationEndpointBean.addPropertyReference("userApprovalHandler", userApprovalHandlerRef);
            }
            authorizationEndpointBean.addPropertyReference("clientDetailsService", clientDetailsRef);
            if (StringUtils.hasText((String)redirectResolverRef)) {
                authorizationEndpointBean.addPropertyReference("redirectResolver", redirectResolverRef);
            }
            if (StringUtils.hasText((String)approvalPage)) {
                authorizationEndpointBean.addPropertyValue("userApprovalPage", (Object)approvalPage);
            }
            if (StringUtils.hasText((String)errorPage)) {
                authorizationEndpointBean.addPropertyValue("errorPage", (Object)errorPage);
            }
            parserContext.getRegistry().registerBeanDefinition("oauth2AuthorizationEndpoint", (BeanDefinition)authorizationEndpointBean.getBeanDefinition());
        }
        BeanDefinitionBuilder tokenEndpointBean = BeanDefinitionBuilder.rootBeanDefinition(TokenEndpoint.class);
        tokenEndpointBean.addPropertyReference("clientDetailsService", clientDetailsRef);
        tokenEndpointBean.addPropertyReference("tokenGranter", tokenGranterRef);
        authorizationEndpointBean.addPropertyReference("oAuth2RequestValidator", oAuth2RequestValidatorRef);
        parserContext.getRegistry().registerBeanDefinition("oauth2TokenEndpoint", (BeanDefinition)tokenEndpointBean.getBeanDefinition());
        if (StringUtils.hasText((String)oAuth2RequestFactoryRef)) {
            tokenEndpointBean.addPropertyReference("oAuth2RequestFactory", oAuth2RequestFactoryRef);
        }
        if (StringUtils.hasText((String)oAuth2RequestValidatorRef)) {
            tokenEndpointBean.addPropertyReference("oAuth2RequestValidator", oAuth2RequestValidatorRef);
        }
        BeanDefinitionBuilder handlerMappingBean = BeanDefinitionBuilder.rootBeanDefinition(FrameworkEndpointHandlerMapping.class);
        if (StringUtils.hasText((String)tokenEndpointUrl) || StringUtils.hasText((String)authorizationEndpointUrl)) {
            ManagedMap mappings = new ManagedMap();
            if (StringUtils.hasText((String)tokenEndpointUrl)) {
                mappings.put((Object)"/oauth/token", (Object)new TypedStringValue(tokenEndpointUrl, String.class));
            }
            if (StringUtils.hasText((String)authorizationEndpointUrl)) {
                mappings.put((Object)"/oauth/authorize", (Object)new TypedStringValue(authorizationEndpointUrl, String.class));
            }
            if (StringUtils.hasText((String)approvalPage)) {
                mappings.put((Object)"/oauth/confirm_access", (Object)new TypedStringValue(approvalPage, String.class));
            }
            handlerMappingBean.addPropertyValue("mappings", (Object)mappings);
        }
        if (StringUtils.hasText((String)approvalParameter) && registerAuthorizationEndpoint) {
            if (!StringUtils.hasText((String)userApprovalHandlerRef)) {
                BeanDefinitionBuilder userApprovalHandler = BeanDefinitionBuilder.rootBeanDefinition(DefaultUserApprovalHandler.class);
                userApprovalHandler.addPropertyValue("approvalParameter", (Object)new TypedStringValue(approvalParameter, String.class));
                authorizationEndpointBean.addPropertyValue("userApprovalHandler", (Object)userApprovalHandler.getBeanDefinition());
            }
            handlerMappingBean.addPropertyValue("approvalParameter", (Object)approvalParameter);
        }
        parserContext.getRegistry().registerBeanDefinition("oauth2HandlerMapping", (BeanDefinition)handlerMappingBean.getBeanDefinition());
        return null;
    }
}

