// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options', function () {
  var OptionsPage = options.OptionsPage;

  function ImportExportBookmarkOverlay() {
    OptionsPage.call(this,
                     'importExportBookmark',
                     templateData.importExportBookmarkOverlayTabTitle,
                     'import-or-export-bookmark-overlay');
  }

  cr.addSingletonGetter(ImportExportBookmarkOverlay);

  ImportExportBookmarkOverlay.prototype = {
    // Inherit from OptionsPage.
    __proto__: OptionsPage.prototype,

    /**
    * Initialize the page.
    */
    initializePage: function () {

      // Call base class implementation to start preference initialization.
      OptionsPage.prototype.initializePage.call(this);
      var self = this;
      
      $("import-bookmark-btn").onclick = function () {
        $('import-or-export-select').hidden = true;
        $('import-or-export-title').textContent = localStrings.getString("importBookmark");
        $('import-bookmark-container').hidden = false;
        // add by huangximing ûе¼Ĳʾ
        if (!self.parentPage._360syncSetupCompleted) {
          $('browser_btn_99').hidden = true;
        } else {
          $('browser_btn_99').hidden = false;
        }
      };
      $("clean-bookmark-confirm").onclick = function () {
        var checkboxes =
                      document.querySelectorAll('#clean-bookmarks-list input[type=checkbox]');
        var cleanList = new Array();
        for (var i = 0; i < checkboxes.length; i++) {
          if (checkboxes[i].checked) {
            cleanList.push(String(checkboxes[i].value));
          }
        }
        chrome.send("cleanRubbishURL", cleanList);
      };
      $("export-bookmark-btn").onclick = function () {
        chrome.send("exportBookmarkToHTML");
      };
      $('import-cancel').onclick = function () {
        ImportExportBookmarkOverlay.userClose();
      };
      $('import-or-export-cancel').onclick = function () {
        ImportExportBookmarkOverlay.userClose();
      };
      $('clean-cancel').onclick = function () {
        ImportExportBookmarkOverlay.userClose();
      };
      $("import-failed-close").onclick = function () {
        ImportExportBookmarkOverlay.userClose();
      };
      $("createNewFolderDiv").addEventListener("click", this.setCreateNewFolder_);
      $("createNewFolderCbx").addEventListener("click", this.setCreateNewFolder_);

      var bookmark_manager = document.querySelectorAll('.bookmark-manage');
      for (var i = 0; i < bookmark_manager.length; i++) {
        bookmark_manager.onclick = function () {
          chrome.send("clickBookmarkManager");
        };
      }

      $("clean-bookmarks-list").innerHTML = "";
      self.setImportingtState_(false);
      self.setCleaningState_(false);
      $('import-cancel').disabled = "";
    },
    setCreateNewFolder_: function () {
      $("createNewFolderCbx").checked = !$("createNewFolderCbx").checked;
    },
    setImportingtState_: function (sensitive) {
      var buttons = document.querySelectorAll('#import-bookmark-browser-list div');
      for (var i = 0; i < buttons.length; i++)
        buttons[i].disabled = sensitive;
      var bookmark_manage = document.querySelector("#import-bookmark-container .bookmark-manage");
      bookmark_manage.style.display = sensitive ? "none" : "block";
      $('import-bookmark-throbber').style.display = sensitive ? "block" : "none";
    },

    setCleaningState_: function (state) {
      var bookmark_manage = document.querySelector("#import-bookmark-success .bookmark-manage");
      bookmark_manage.style.display = state ? "none" : "block";
      $('clean-bookmark-throbber').style.display = state ? "block" : "none";
    },

    setLocalBrowsers_: function (browsers) {
      //this.browserProfiles = browsers;
      var browserList = $('import-bookmark-browser-list');
      browserList.innerHTML = "";
      var browserCount = browsers.length;
      for (var i = 0; i < browserCount; i++) {
        var browser = browsers[i];
        var browser_btn = document.createElement("div");
        browser_btn.id = "browser_btn_" + browser['index'];
        browser_btn.innerHTML = "<span class='import-source-" + browser["index"] + "'></span>" + localStrings.getStringF("importBookmarkFrom", browser['name']);
        browser_btn.onclick = (function (bindex) {
          return function () {
            chrome.send("importBookmark", [String(bindex), String($("createNewFolderCbx").checked)]);
            $('import-cancel').disabled = "disabled";
          };
        })(browser["index"]);

        browserList.appendChild(browser_btn);
      }
    },

    closeClean_: function () {
      $('import-or-export-select').hidden = false;
      $('import-bookmark-container').hidden = true;
      $('clean-bookmarks-list').innerHTML = "";
      $('import-bookmark-success').hidden = true;
      $("clean-bookmark-throbber").hidden = true;
      $("import-bookmark-failed").hidden = true;
      $("success-failed-pic").className = "failed-pic";
      $('import-or-export-title').textContent = localStrings.getString("importExportBookmark");
      $('import-bookmark-throbber').style.display = "none";
      var bookmark_manage = document.querySelector("#import-bookmark-container .bookmark-manage");
      bookmark_manage.style.display = "block";
      $('import-cancel').disabled = "";
    },

    importSuccess_: function (url_list) {
      // this.rubbishUrlList = url_list;
      $('import-cancel').disabled = "";
      var urlListContainer = $('clean-bookmarks-list');
      urlListContainer.innerHTML = "";
      var urlCount = url_list.length;
      $('clean-bookmark-container').hidden = urlCount <= 0 ? true : false;
      for (var i = 0; i < urlCount; i++) {
        var urlItem = url_list[i];
        var urlItem_ckb = document.createElement('input');
        urlItem_ckb.type = 'checkbox';
        urlItem_ckb.value = urlItem['id'];
        urlItem_ckb.name = "rubbishUrlList";
        urlItem_ckb.setAttribute("checked", "checked");
        urlListContainer.appendChild(urlItem_ckb);
        urlListContainer.appendChild(document.createTextNode(urlItem['title']));
        var item_br = document.createElement('br');
        urlListContainer.appendChild(item_br);
      }
      //            $('import-bookmark-success').hidden = urlCount <= 0 ? true : false;
      //            if (urlCount <= 0) {
      //                $("import-bookmark-failed").hidden = false;
      //                $("import-or-export-title").textContent = localStrings.getString("importBookmark");
      //                $("failed-info-text").textContent = localStrings.getString("importBookmarkSuccessed");
      //                $("success-failed-pic").className = "success-pic";
      //            }
    }
  };

  ImportExportBookmarkOverlay.closeClean = function () {
    ImportExportBookmarkOverlay.getInstance().closeClean_();
  };

  ImportExportBookmarkOverlay.setLocalBrowsers = function (browsers) {
    ImportExportBookmarkOverlay.getInstance().setLocalBrowsers_(browsers);
  };

  ImportExportBookmarkOverlay.setImportingState = function (state) {
    ImportExportBookmarkOverlay.getInstance().setImportingtState_(state);
  };

  ImportExportBookmarkOverlay.setCleaningState = function (state) {
    ImportExportBookmarkOverlay.getInstance().setCleaningState_(state);
  };

  ImportExportBookmarkOverlay.userClose = function (clear_state) {
    if (typeof (clear_state) != 'undefined' && clear_state) {
      ImportExportBookmarkOverlay.importSuccessTips('clean');
    }
    ImportExportBookmarkOverlay.closeClean();
    OptionsPage.closeOverlay();
  };
  ImportExportBookmarkOverlay.setCancelBtn = function () {
    $('import-cancel').disabled = "";
  };
  ImportExportBookmarkOverlay.importSuccess = function (rubbish_url_list) {
    ImportExportBookmarkOverlay.setImportingState(false);
    $('import-bookmark-container').hidden = true;
    $('import-bookmark-success').hidden = false;
    if (rubbish_url_list.length <= 0) {
      ImportExportBookmarkOverlay.userClose();
      //add by huangximing
      ImportExportBookmarkOverlay.importSuccessTips();
    } else
      ImportExportBookmarkOverlay.getInstance().importSuccess_(rubbish_url_list);
  };

  ImportExportBookmarkOverlay.importSuccessTips = function (type) {
    var forId = 'import_success_tips';
    if (type == 'clean') forId = 'import_clear_tips';
    $(forId).style.opacity = "1";
    setTimeout(function () {
      $(forId).style.opacity = "0";
    }, 1500);
  };

  ImportExportBookmarkOverlay.importOrExportFailed = function (operation) {
    var other_div = document.querySelectorAll("#import-or-export-bookmark-overlay > div");
    for (var i = 0; i < other_div.length; i++)
      other_div[i].hidden = true;
    if (!operation) {
      $("import-or-export-title").textContent = localStrings.getString("exportBookmark");
      $("failed-info-text").textContent = localStrings.getString("exportBookmarkFailed");
    }
    $("import-bookmark-failed").hidden = false;
  };
  // Export
  return {
    ImportExportBookmarkOverlay: ImportExportBookmarkOverlay
  };
});
