//////////////////////////////////////////////////////////////////////////////
//  Copyright 2014 by Autodesk, Inc.  All rights reserved.
//
// This computer source code and related instructions and comments 
// are the unpublished confidential and proprietary information of 
// Autodesk, Inc. and are protected under applicable copyright and 
// trade secret law.  They may not be disclosed to, copied or used 
// by any third party without the prior written consent of Autodesk, Inc.
//////////////////////////////////////////////////////////////////////////////

/*globals $,jQuery,document, window, navigator*/

/*!
* ntp.resources - Processes loading of external resources
*/

// Namespace
var ntp = ntp || {};
ntp.resources = ntp.resources || {};

/**
 * Initializes ntp.resources
 */
(function() {
    // Get parameters from query string
    var currentProd = ntp.utils.query.product();
    var currentLocale = ntp.utils.query.locale();

    $.extend(ntp.resources, {
        loadSettings : function() {
            // Load settings
            var autoSettings = ntp.utils.query.settings();
            var genericSettings = null;
            var specSettings = null;
            var loadSpecSettingsReq = null;
            var loadGenericSettingsReq = null;

            loadGenericSettingsReq = $.ajax({
                url : 'config/common.json',
                dataType : 'json',
                success : function(data) {
                    genericSettings = data;
                }
            });

            if (currentProd != null) {
                loadSpecSettingsReq = $.ajax({
                    url : 'config/' + currentProd + '/setting.json',
                    dataType : 'json',
                    success : function(data) {
                        specSettings = data;
                    }
                });
            }

            $.when(loadGenericSettingsReq).always(function() {
                $.when(loadSpecSettingsReq).always(function() {
                    // Merge manual and automatic settings, and let automatic
                    // settings overwrite manual
                    ntp.deferred.settings.resolve($.extend(specSettings, autoSettings), genericSettings);
                });
            });
        }, // ntp.resources.loadSettings

        loadStrings : function() {
            // Load both generic and prod specific string resources
            var genericStrings = null;
            var prodSpecificStrings = null;
            var genericStringsReq = $.ajax({
                url : 'local/' + currentLocale + '/resource.resjson',
                dataType : 'json',
                success : function(data) {
                    genericStrings = data;
                }
            });

            var prodSpecificStringsReq = null;
            if (currentProd != null) {
                prodSpecificStringsReq = $.ajax({
                    url : 'config/' + currentProd + '/' + currentLocale + '/strings.resjson',
                    dataType : 'json',
                    success : function(data) {
                        prodSpecificStrings = data;
                    }
                });
            }

            $.when(genericStringsReq).always(function() {
                $.when(prodSpecificStringsReq).always(function() {
                    // Merge generic and product specific strings and load the string table
                    var mergedStrings = $.extend(genericStrings, prodSpecificStrings);
                    //ntp.content.applyLocalizedStrings(mergedStrings);
                    ntp.deferred.strings.resolve(mergedStrings);
                });
            });
        }, // ntp.resources.loadStrings

        loadLearnTab : function(url) {
            $.ajax({
                url : url,
                dataType : 'jsonp',
                jsonpCallback : 'learnTabCallback',
                crossDomain : true,
                timeout : 5000,
                success : function(data) {
                    ntp.deferred.learnTab.resolve(data);
                },
                error : function() {
                    ntp.deferred.learnTab.reject();
                }
            });
        }, // ntp.resources.loadLearnTab

        loadTipsData : function(url) {
            $.ajax({
                url : url,
                dataType : 'jsonp',
                jsonpCallback : 'learnDataCallback',
                crossDomain : true,
                timeout : 5000,
                success : function(data) {
                    ntp.content.learnTab.updateLearnTipsData(data);
                },
                error : function() {
                    ntp.deferred.learnTab.reject();
                }
            });
        }, // ntp.resources.loadLearnTab
    });
})();

/**
 * Triggers the loading of external resources on document ready.
 */
$(document).ready(function() {
    ntp.resources.loadStrings();
    ntp.resources.loadSettings();
}); 

// SIG // Begin signature block
// SIG // MIIZjAYJKoZIhvcNAQcCoIIZfTCCGXkCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // ExvoVhxM991dUtl8E5UD5VJ7eznkz9Gg0hTw+77w/qeg
// SIG // ggopMIIE2jCCA8KgAwIBAgIQfG5XIF7pXpl44AXkMQgG
// SIG // EDANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xODA3MDUwMDAw
// SIG // MDBaFw0xOTA4MDUyMzU5NTlaMIGKMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECAwKQ2FsaWZvcm5pYTETMBEGA1UEBwwK
// SIG // U2FuIFJhZmFlbDEXMBUGA1UECgwOQXV0b2Rlc2ssIElu
// SIG // Yy4xHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlvbnMgR3Jv
// SIG // dXAxFzAVBgNVBAMMDkF1dG9kZXNrLCBJbmMuMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA7mRyNXG+
// SIG // QgtKVZfb37ZZm2wDgkFnx9kZy5clwGxvrSFmo0RQb5gR
// SIG // 6Ez0lhlQRNsfBVcYZrp0YyNxKg25oCdLDgPnaqilCia0
// SIG // UkRTpMYIUdaD0acP8C7Cb7r4oeKl2c3qVOGpvyCSM7Ep
// SIG // x16v7HtO0xeiOtCGU+cQ2kussGyDxiuvg0nsCMR4zV7b
// SIG // cg0bjKS3q22JzkzNrJpxSJJPnemEif5NQVQExg8Dg8YO
// SIG // UVAEhPc5+TRCtWH0fT+c4asKEUo9Urz5TBRwqqg2h/Ti
// SIG // k2qUPok3YlHrI8JIOeKfItfgU4PYtwr6yt4PPW7Jie1g
// SIG // cYi6JNButwAUIwRfCI1brIyhwQIDAQABo4IBPjCCATow
// SIG // CQYDVR0TBAIwADAOBgNVHQ8BAf8EBAMCB4AwEwYDVR0l
// SIG // BAwwCgYIKwYBBQUHAwMwYQYDVR0gBFowWDBWBgZngQwB
// SIG // BAEwTDAjBggrBgEFBQcCARYXaHR0cHM6Ly9kLnN5bWNi
// SIG // LmNvbS9jcHMwJQYIKwYBBQUHAgIwGQwXaHR0cHM6Ly9k
// SIG // LnN5bWNiLmNvbS9ycGEwHwYDVR0jBBgwFoAU1MAGIknr
// SIG // OUvdk+JcobhHdglyA1gwKwYDVR0fBCQwIjAgoB6gHIYa
// SIG // aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcmwwVwYIKwYB
// SIG // BQUHAQEESzBJMB8GCCsGAQUFBzABhhNodHRwOi8vcmIu
// SIG // c3ltY2QuY29tMCYGCCsGAQUFBzAChhpodHRwOi8vcmIu
// SIG // c3ltY2IuY29tL3JiLmNydDANBgkqhkiG9w0BAQsFAAOC
// SIG // AQEArEMBlWJ6bc5AKEqwyO4TWNdnsYX9FreWUauXniGK
// SIG // lAwGhAkH7N4Ma1sE3yKtQi6pE7n+1t0bmlPPLiAWfRgI
// SIG // oDZ/ZwiWkOoP7A+31Q7skKjdUN1M96QjcbNUQjDkFqxy
// SIG // bHUraVr0gPlGUpnMR1npXAFHgXCrw45F1NT+LZNHWt/l
// SIG // AmfQsquTmDNvs7o0f/AhQr45Ylo8/Gsr8neojm2Io8iF
// SIG // pcMHqY7jcNnVL4ethYXVVdY0JSBN+Vg/2G0j/Lq8ic+I
// SIG // f8LiWdBllb3DUrVrgdjmBIHYCxPPJTXgsTGv4hwlRifS
// SIG // QkMw83nBdgWsObnssKnDJEOrhm9Da8FRHL4/fzCCBUcw
// SIG // ggQvoAMCAQICEHwbNTVK59t050FfEWnKa6gwDQYJKoZI
// SIG // hvcNAQELBQAwgb0xCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDIw
// SIG // MDggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9yaXpl
// SIG // ZCB1c2Ugb25seTE4MDYGA1UEAxMvVmVyaVNpZ24gVW5p
// SIG // dmVyc2FsIFJvb3QgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
// SIG // dHkwHhcNMTQwNzIyMDAwMDAwWhcNMjQwNzIxMjM1OTU5
// SIG // WjCBhDELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFu
// SIG // dGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRl
// SIG // YyBUcnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRl
// SIG // YyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0Eg
// SIG // LSBHMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBANeVQ9Tc32euOftSpLYmMQRw6beOWyq6N2k1lY+7
// SIG // wDDnhthzu9/r0XY/ilaO6y1L8FcYTrGNpTPTC3Uj1Wp5
// SIG // J92j0/cOh2W13q0c8fU1tCJRryKhwV1LkH/AWU6rnXmp
// SIG // AtceSbE7TYf+wnirv+9SrpyvCNk55ZpRPmlfMBBOcWNs
// SIG // WOHwIDMbD3S+W8sS4duMxICUcrv2RZqewSUL+6Mcntim
// SIG // CXBx7MBHTI99w94Zzj7uBHKOF9P/8LIFMhlM07Acn/6l
// SIG // eCBCcEGwJoxvAMg6ABFBekGwp4qRBKCZePR3tPNgKuZs
// SIG // UAS3FGD/DVH0qIuE/iHaXF599Sl5T7BEdG9tcv8CAwEA
// SIG // AaOCAXgwggF0MC4GCCsGAQUFBwEBBCIwIDAeBggrBgEF
// SIG // BQcwAYYSaHR0cDovL3Muc3ltY2QuY29tMBIGA1UdEwEB
// SIG // /wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBbBgtghkgBhvhF
// SIG // AQcXAzBMMCMGCCsGAQUFBwIBFhdodHRwczovL2Quc3lt
// SIG // Y2IuY29tL2NwczAlBggrBgEFBQcCAjAZGhdodHRwczov
// SIG // L2Quc3ltY2IuY29tL3JwYTA2BgNVHR8ELzAtMCugKaAn
// SIG // hiVodHRwOi8vcy5zeW1jYi5jb20vdW5pdmVyc2FsLXJv
// SIG // b3QuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMDMA4GA1Ud
// SIG // DwEB/wQEAwIBBjApBgNVHREEIjAgpB4wHDEaMBgGA1UE
// SIG // AxMRU3ltYW50ZWNQS0ktMS03MjQwHQYDVR0OBBYEFNTA
// SIG // BiJJ6zlL3ZPiXKG4R3YJcgNYMB8GA1UdIwQYMBaAFLZ3
// SIG // +mlIR59TEtXC6gcydgfRlwcZMA0GCSqGSIb3DQEBCwUA
// SIG // A4IBAQB/68qn6ot2Qus+jiBUMOO3udz6SD4Wxw9FlRDN
// SIG // J4ajZvMC7XH4qsJVl5Fwg/lSflJpPMnx4JRGgBi7odSk
// SIG // VqbzHQCR1YbzSIfgy8Q0aCBetMv5Be2cr3BTJ7noPn5R
// SIG // oGlxi9xR7YA6JTKfRK9uQyjTIXW7l9iLi4z+qQRGBIX3
// SIG // FZxLEY3ELBf+1W5/muJWkvGWs60t+fTf2omZzrI4RMD3
// SIG // R3vKJbn6Kmgzm1By3qif1M0sCzS9izB4QOCNjicbkG8a
// SIG // vggVgV3rL+JR51EeyXgp5x5lvzjvAUoBCSQOFsQUecFB
// SIG // NzTQPZFSlJ3haO8I8OJpnGdukAsak3HUJgLDwFojMYIO
// SIG // uzCCDrcCAQEwgZkwgYQxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UE
// SIG // CxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1MDMGA1UE
// SIG // AxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBT
// SIG // aWduaW5nIENBIC0gRzICEHxuVyBe6V6ZeOAF5DEIBhAw
// SIG // DQYJYIZIAWUDBAIBBQCgfDAQBgorBgEEAYI3AgEMMQIw
// SIG // ADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgor
// SIG // BgEEAYI3AgELMQ4wDAYKKwYBBAGCNwIBFTAvBgkqhkiG
// SIG // 9w0BCQQxIgQg89nsDu4nPgNz4HZRfW2H+wlA24hZZ/GU
// SIG // pJ2AHp+DGOEwDQYJKoZIhvcNAQEBBQAEggEAl/XA6zEo
// SIG // YZXA34oN3zk6UqjOmcGW3kjd4ezkWnX9tDhrbsGfDrMk
// SIG // JkGXHfn3yH61XfofK0XaU/Jc1vQyZCD4OiIJbecJ+CRi
// SIG // uMLaasJNCdW7mZ94QL3+JUowFMB0xnMBlTnhM4WOPvRE
// SIG // BhRSj3DlhKzVqd0nM+rZNh0KMRM71c8vPt66wsV7NcSa
// SIG // hfS92yJE5Na1eTgS9UtvOZEaw2x91XLcgeQu4jW6irS0
// SIG // zp+jiWHDF1MGbVS7FCTXFepGcpn5NbIUlhzdwWNIjO1R
// SIG // c7U+NRVGKdkFZK5p5vsXFijka6AtUgroIHWsQUobRU4r
// SIG // ttnLNMtpFZHokYM0Yv7l1sLd1aGCDHQwggxwBgorBgEE
// SIG // AYI3AwMBMYIMYDCCDFwGCSqGSIb3DQEHAqCCDE0wggxJ
// SIG // AgEDMQ8wDQYJYIZIAWUDBAIBBQAwga8GCyqGSIb3DQEJ
// SIG // EAEEoIGfBIGcMIGZAgEBBgkrBgEEAaAyAgMwMTANBglg
// SIG // hkgBZQMEAgEFAAQg2m6yjyskm+Qmbrqijz2I6eRkUfyw
// SIG // gdGjfxqmx9V+Ht4CFFr5cSQ2SmMq7Y96ZUdDvxBBx/Db
// SIG // GA8yMDE5MDEzMDA5NDc0NVqgL6QtMCsxKTAnBgNVBAMM
// SIG // IEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAtIEcy
// SIG // oIII0zCCBLYwggOeoAMCAQICDAynz10HBySsieeaOjAN
// SIG // BgkqhkiG9w0BAQsFADBbMQswCQYDVQQGEwJCRTEZMBcG
// SIG // A1UEChMQR2xvYmFsU2lnbiBudi1zYTExMC8GA1UEAxMo
// SIG // R2xvYmFsU2lnbiBUaW1lc3RhbXBpbmcgQ0EgLSBTSEEy
// SIG // NTYgLSBHMjAeFw0xODAyMTkwMDAwMDBaFw0yOTAzMTgx
// SIG // MDAwMDBaMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEAt8eSiijY85HLUA1d6ylE
// SIG // wYJZpcpkzr2DtVHllMxugJoXbNz/YuY2Q14Bwgxkjcp3
// SIG // nvZdd0W5Xsgk60E3EWY3rMjNdJvMs+9M4n8bznO+yZad
// SIG // NR5891T3bOygEtaumZ1jxHhfWakuIvXDJ9iyW0VjJ5D/
// SIG // jLE9qbTzDsDxIGUGiZ0DHKOwUkGFNOu8y85U9hL+swGJ
// SIG // Sqb6VMUf+9McwOO/l+M/0Bv5QMcb1esmfEMwx3DyeBGq
// SIG // hU6lDg0ASjoRd6PKIwGAnsiTVl1GzIrY0qoKhIWyiVvV
// SIG // Ms5BexhOVMqr0VJeEtMknlbzDI/dvZKOedVBicOjoOWR
// SIG // /MdnnYczznEycwIDAQABo4IBqDCCAaQwDgYDVR0PAQH/
// SIG // BAQDAgeAMEwGA1UdIARFMEMwQQYJKwYBBAGgMgEeMDQw
// SIG // MgYIKwYBBQUHAgEWJmh0dHBzOi8vd3d3Lmdsb2JhbHNp
// SIG // Z24uY29tL3JlcG9zaXRvcnkvMAkGA1UdEwQCMAAwFgYD
// SIG // VR0lAQH/BAwwCgYIKwYBBQUHAwgwRgYDVR0fBD8wPTA7
// SIG // oDmgN4Y1aHR0cDovL2NybC5nbG9iYWxzaWduLmNvbS9n
// SIG // cy9nc3RpbWVzdGFtcGluZ3NoYTJnMi5jcmwwgZgGCCsG
// SIG // AQUFBwEBBIGLMIGIMEgGCCsGAQUFBzAChjxodHRwOi8v
// SIG // c2VjdXJlLmdsb2JhbHNpZ24uY29tL2NhY2VydC9nc3Rp
// SIG // bWVzdGFtcGluZ3NoYTJnMi5jcnQwPAYIKwYBBQUHMAGG
// SIG // MGh0dHA6Ly9vY3NwMi5nbG9iYWxzaWduLmNvbS9nc3Rp
// SIG // bWVzdGFtcGluZ3NoYTJnMjAdBgNVHQ4EFgQULW5u0Y3l
// SIG // A4Du52Ppp9naCzxXIj0wHwYDVR0jBBgwFoAUkiGnSpVd
// SIG // ZLCbtB7mADdH5p1BK0wwDQYJKoZIhvcNAQELBQADggEB
// SIG // AI39HR+PiNNl+LVcRumn07Y/SstDBcIHDcNeA4QjN6h6
// SIG // jJcj/yechH1h61xLVz6b9ETbgFj3tmXejxIKX6eHdLfa
// SIG // FECHUeyfSkdV8BfoGD5xIDHmKCKrTvaunGvC50T7aA0g
// SIG // f1M/lBuhhoJOMhYQWj+JWMHQtNu2kPuNMumhS0ZQN7bD
// SIG // OukpJBKSWk4rubYKejaMl8DviXwz3jHhoZfk50WtYVL9
// SIG // WonTVH6KTVuJew6Wd9HyPDgb2vmlYSBlArzFrdcMYhAo
// SIG // LN2246hhAKwIJqONhdBkyTaQHopSyYeNNaVdSJH8k6al
// SIG // ZfHs+TrcpSyeBG1iM/7e+p/Fzq+V81Go8s4wggQVMIIC
// SIG // /aADAgECAgsEAAAAAAExicZQBDANBgkqhkiG9w0BAQsF
// SIG // ADBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0Eg
// SIG // LSBSMzETMBEGA1UEChMKR2xvYmFsU2lnbjETMBEGA1UE
// SIG // AxMKR2xvYmFsU2lnbjAeFw0xMTA4MDIxMDAwMDBaFw0y
// SIG // OTAzMjkxMDAwMDBaMFsxCzAJBgNVBAYTAkJFMRkwFwYD
// SIG // VQQKExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhH
// SIG // bG9iYWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1
// SIG // NiAtIEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
// SIG // CgKCAQEAqpuOw6sRUSUBtpaU4k/YwQj2RiPZRcWVl1ur
// SIG // Gr/SbFfJMwYfoA/GPH5TSHq/nYeer+7DjEfhQuzj46FK
// SIG // bAwXxKbBuc1b8R5EiY7+C94hWBPuTcjFZwscsrPxNHaR
// SIG // ossHbTfFoEcmAhWkkJGpeZ7X61edK3wi2BTX8QceeCI2
// SIG // a3d5r6/5f45O4bUIMf3q7UtxYowj8QM5j0R5tnYDV56t
// SIG // LwhG3NKMvPSOdM7IaGlRdhGLD10kWxlUPSbMQI2CJxtZ
// SIG // IH1Z9pOAjvgqOP1roEBlH1d2zFuOBE8sqNuEUBNPxtyL
// SIG // ufjdaUyI65x7MCb8eli7WbwUcpKBV7d2ydiACoBuCQID
// SIG // AQABo4HoMIHlMA4GA1UdDwEB/wQEAwIBBjASBgNVHRMB
// SIG // Af8ECDAGAQH/AgEAMB0GA1UdDgQWBBSSIadKlV1ksJu0
// SIG // HuYAN0fmnUErTDBHBgNVHSAEQDA+MDwGBFUdIAAwNDAy
// SIG // BggrBgEFBQcCARYmaHR0cHM6Ly93d3cuZ2xvYmFsc2ln
// SIG // bi5jb20vcmVwb3NpdG9yeS8wNgYDVR0fBC8wLTAroCmg
// SIG // J4YlaHR0cDovL2NybC5nbG9iYWxzaWduLm5ldC9yb290
// SIG // LXIzLmNybDAfBgNVHSMEGDAWgBSP8Et/qC5FJK5NUPpj
// SIG // move4t0bvDANBgkqhkiG9w0BAQsFAAOCAQEABFaCSnzQ
// SIG // zsm/NmbRvjWek2yX6AbOMRhZ+WxBX4AuwEIluBjH/NSx
// SIG // N8RooM8oagN0S2OXhXdhO9cv4/W9M6KSfREfnops7yyw
// SIG // 9GKNNnPRFjbxvF7stICYePzSdnno4SGU4B/EouGqZ9uz
// SIG // nHPlQCLPOc7b5neVp7uyy/YZhp2fyNSYBbJxb051rvE9
// SIG // ZGo7Xk5GpipdCJLxo/MddL9iDSOMXCo4ldLA1c3PiNof
// SIG // KLW6gWlkKrWmotVzr9xG2wSukdduxZi61EfEVnSAR3hY
// SIG // jL7vK/3sbL/RlPe/UOB74JD9IBh4GCJdCC6MHKCX8x2Z
// SIG // faOdkdMGRE4EbnocIOM28LZQuTGCAqgwggKkAgEBMGsw
// SIG // WzELMAkGA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNp
// SIG // Z24gbnYtc2ExMTAvBgNVBAMTKEdsb2JhbFNpZ24gVGlt
// SIG // ZXN0YW1waW5nIENBIC0gU0hBMjU2IC0gRzICDAynz10H
// SIG // BySsieeaOjANBglghkgBZQMEAgEFAKCCAQ4wGgYJKoZI
// SIG // hvcNAQkDMQ0GCyqGSIb3DQEJEAEEMBwGCSqGSIb3DQEJ
// SIG // BTEPFw0xOTAxMzAwOTQ3NDVaMC8GCSqGSIb3DQEJBDEi
// SIG // BCChnwrnLDUoC+XHn2RSfrCwbc5n/5/f1bHCi3yio4JQ
// SIG // gTCBoAYLKoZIhvcNAQkQAgwxgZAwgY0wgYowgYcEFJsS
// SIG // BXrnKq/21jdytJ9qI28mSc2pMG8wX6RdMFsxCzAJBgNV
// SIG // BAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNh
// SIG // MTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVzdGFtcGlu
// SIG // ZyBDQSAtIFNIQTI1NiAtIEcyAgwMp89dBwckrInnmjow
// SIG // DQYJKoZIhvcNAQEBBQAEggEAqEPt0A9CHrtSHP06hQ4S
// SIG // 8Hb5jrTCO/7lts3Ei7I4FYbyg/+41QNg59xi2hJwmmmQ
// SIG // 5Kbj1yIdk6AkCgQEp/+Ps8y63Z6/RIoOw1F8dxqaeeuj
// SIG // 68s9LXbp5I1KiIyu0hEKhwmeiM3dZ8kFzHsHuBidiPBa
// SIG // qMAH5y0VCpc3O3SNiMsR4Td95MbpMBijl+1l/JN4TRmd
// SIG // cuvpkPtm21u4xfgmPjv3HKQfVOP/wvgfYQ3gEDbgdROK
// SIG // P8yodYSZWBJjlJ0NkyyjckZOfNamY1h4v1OWqlbQjtKD
// SIG // 7/sA2ZnWENr1RsHcFzNVc8ApS5/VeCHZ7x+w8KoAPQ5s
// SIG // +HDrTBeF8FM9HQ==
// SIG // End signature block
