/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

public final class ComponentUtil {
    public static void centerComponentInWindow(Component component, int percentOfScreen) {
        if (percentOfScreen < 0) {
            ComponentUtil.centerComponentInWindow(component, -percentOfScreen);
            return;
        }
        if (percentOfScreen > 100) {
            ComponentUtil.centerComponentInWindow(component, 100);
            return;
        }
        double percent = (double)percentOfScreen / 100.0;
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        component.setSize((int)(bounds.getWidth() * percent), (int)(bounds.getHeight() * percent));
        ComponentUtil.centerComponentInWindow(component);
    }

    public static void centerComponentInWindow(Component component) {
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        component.setLocation((int)((bounds.getWidth() - (double)component.getWidth()) / 2.0), (int)((bounds.getHeight() - (double)component.getHeight()) / 2.0));
        component.validate();
        component.repaint();
    }

    public static void centerComponentInComponent(Component parent, Component toBeCentered) {
        toBeCentered.setLocation(parent.getX() + (parent.getWidth() - toBeCentered.getWidth()) / 2, parent.getY() + (parent.getHeight() - toBeCentered.getHeight()) / 2);
        toBeCentered.validate();
        toBeCentered.repaint();
    }

    private ComponentUtil() {
    }
}

