/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.HttpURLConnection;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.keystore.JmeterKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSLManager {
    private static final Logger log = LoggerFactory.getLogger(SSLManager.class);
    private static final String SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String JAVAX_NET_SSL_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String PKCS12 = "pkcs12";
    private static SSLManager manager;
    private static final boolean IS_SSL_SUPPORTED = true;
    private volatile JmeterKeyStore keyStore;
    private KeyStore trustStore = null;
    private volatile boolean truststoreLoaded = false;
    protected String defaultpw = System.getProperty("javax.net.ssl.keyStorePassword");
    private int keystoreAliasStartIndex;
    private int keystoreAliasEndIndex;
    private String clientCertAliasVarName;

    public static synchronized void reset() {
        manager = null;
    }

    public abstract void setContext(HttpURLConnection var1);

    protected void setProvider(Provider provider) {
        if (null != provider) {
            Security.addProvider(provider);
        }
    }

    protected synchronized JmeterKeyStore getKeyStore() {
        if (null == this.keyStore) {
            block32: {
                String fileName = System.getProperty(JAVAX_NET_SSL_KEY_STORE, "");
                String fileType = System.getProperty(JAVAX_NET_SSL_KEY_STORE_TYPE, fileName.toLowerCase(Locale.ENGLISH).endsWith(".p12") ? PKCS12 : "JKS");
                log.info("JmeterKeyStore Location: {} type {}", (Object)fileName, (Object)fileType);
                try {
                    this.keyStore = JmeterKeyStore.getInstance(fileType, this.keystoreAliasStartIndex, this.keystoreAliasEndIndex, this.clientCertAliasVarName);
                    log.info("KeyStore created OK");
                }
                catch (Exception e) {
                    this.keyStore = null;
                    throw new RuntimeException("Could not create keystore: " + e.getMessage(), e);
                }
                try {
                    File initStore = new File(fileName);
                    if (fileName.length() > 0 && initStore.exists()) {
                        try (FileInputStream fis = new FileInputStream(initStore);
                             BufferedInputStream fileInputStream = new BufferedInputStream(fis);){
                            this.keyStore.load(fileInputStream, this.getPassword());
                            if (log.isInfoEnabled()) {
                                log.info("Total of {} aliases loaded OK from keystore", (Object)this.keyStore.getAliasCount());
                            }
                            break block32;
                        }
                    }
                    log.warn("Keystore file not found, loading empty keystore");
                    this.defaultpw = "";
                    this.keyStore.load(null, "");
                }
                catch (Exception e) {
                    log.error("Problem loading keystore: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("JmeterKeyStore type: {}", this.keyStore.getClass());
            }
        }
        return this.keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPassword() {
        String password = this.defaultpw;
        if (null == password) {
            GuiPackage guiInstance = GuiPackage.getInstance();
            if (guiInstance != null) {
                SSLManager sSLManager = this;
                synchronized (sSLManager) {
                    this.defaultpw = JOptionPane.showInputDialog(guiInstance.getMainFrame(), JMeterUtils.getResString("ssl_pass_prompt"), JMeterUtils.getResString("ssl_pass_title"), 3);
                    System.setProperty(KEY_STORE_PASSWORD, this.defaultpw);
                    password = this.defaultpw;
                }
            } else {
                log.warn("No password provided, and no GUI present so cannot prompt");
            }
        }
        return password;
    }

    protected KeyStore getTrustStore() {
        block31: {
            if (!this.truststoreLoaded) {
                this.truststoreLoaded = true;
                String fileName = System.getProperty(SSL_TRUST_STORE);
                if (fileName == null) {
                    return null;
                }
                log.info("TrustStore Location: " + fileName);
                try {
                    this.trustStore = KeyStore.getInstance("JKS");
                    log.info("TrustStore created OK, Type: JKS");
                }
                catch (Exception e) {
                    this.trustStore = null;
                    throw new RuntimeException("Problem creating truststore: " + e.getMessage(), e);
                }
                try {
                    File initStore = new File(fileName);
                    if (initStore.exists()) {
                        try (FileInputStream fis = new FileInputStream(initStore);
                             BufferedInputStream fileInputStream = new BufferedInputStream(fis);){
                            this.trustStore.load(fileInputStream, null);
                            log.info("Truststore loaded OK from file");
                            break block31;
                        }
                    }
                    log.warn("Truststore file not found, loading empty truststore");
                    this.trustStore.load(null, null);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't load TrustStore: " + e.getMessage(), e);
                }
            }
        }
        return this.trustStore;
    }

    protected SSLManager() {
    }

    public static synchronized SSLManager getInstance() {
        if (null == manager) {
            manager = new JsseSSLManager(null);
        }
        return manager;
    }

    public static boolean isSSLSupported() {
        return true;
    }

    public void configureKeystore(boolean preload, int startIndex, int endIndex, String clientCertAliasVarName) {
        this.keystoreAliasStartIndex = startIndex;
        this.keystoreAliasEndIndex = endIndex;
        this.clientCertAliasVarName = clientCertAliasVarName;
        if (preload) {
            this.keyStore = this.getKeyStore();
        }
    }

    public void destroyKeystore() {
        this.keyStore = null;
    }
}

