/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.ClearGui;
import org.apache.jmeter.testbeans.gui.TestBeanPropertyEditor;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableEditor
extends PropertyEditorSupport
implements FocusListener,
TestBeanPropertyEditor,
TableModelListener,
ClearGui {
    private static final Logger log = LoggerFactory.getLogger(TableEditor.class);
    public static final String CLASSNAME = "tableObject.classname";
    public static final String HEADERS = "table.headers";
    public static final String OBJECT_PROPERTIES = "tableObject.properties";
    private JTable table;
    private ObjectTableModel model;
    private Class<?> clazz;
    private PropertyDescriptor descriptor;
    private final JButton addButton = new JButton(JMeterUtils.getResString("add"));
    private final JButton clipButton;
    private final JButton removeButton;
    private final JButton clearButton;
    private final JButton upButton;
    private final JButton downButton;

    public TableEditor() {
        this.addButton.addActionListener(new AddListener());
        this.clipButton = new JButton(JMeterUtils.getResString("add_from_clipboard"));
        this.clipButton.addActionListener(new ClipListener());
        this.removeButton = new JButton(JMeterUtils.getResString("remove"));
        this.removeButton.addActionListener(new RemoveListener());
        this.clearButton = new JButton(JMeterUtils.getResString("clear"));
        this.clearButton.addActionListener(new ClearListener());
        this.upButton = new JButton(JMeterUtils.getResString("up"));
        this.upButton.addActionListener(new UpListener());
        this.downButton = new JButton(JMeterUtils.getResString("down"));
        this.downButton.addActionListener(new DownListener());
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        JComponent pane = this.makePanel();
        pane.doLayout();
        pane.validate();
        return pane;
    }

    private JComponent makePanel() {
        JPanel p = new JPanel(new BorderLayout());
        JScrollPane scroller = new JScrollPane(this.table);
        this.table.setSelectionMode(2);
        scroller.setMinimumSize(new Dimension(100, 70));
        scroller.setPreferredSize(scroller.getMinimumSize());
        p.add((Component)scroller, "Center");
        JPanel south = new JPanel();
        south.add(this.addButton);
        south.add(this.clipButton);
        this.removeButton.setEnabled(false);
        south.add(this.removeButton);
        this.clearButton.setEnabled(false);
        south.add(this.clearButton);
        this.upButton.setEnabled(false);
        south.add(this.upButton);
        this.downButton.setEnabled(false);
        south.add(this.downButton);
        p.add((Component)south, "South");
        return p;
    }

    @Override
    public Object getValue() {
        return this.model.getObjectList();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.model.setRows(this.convertCollection((Collection)value));
        } else {
            this.model.clearData();
        }
        if (this.model.getRowCount() > 0) {
            this.removeButton.setEnabled(true);
            this.clearButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.clearButton.setEnabled(false);
        }
        if (this.model.getRowCount() > 1) {
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        this.firePropertyChange();
    }

    private Collection<Object> convertCollection(Collection<?> values) {
        LinkedList<Object> l = new LinkedList<Object>();
        for (Object obj : values) {
            if (obj instanceof TestElementProperty) {
                l.add(((TestElementProperty)obj).getElement());
                continue;
            }
            l.add(obj);
        }
        return l;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void setDescriptor(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
        String value = (String)descriptor.getValue(CLASSNAME);
        if (value == null) {
            throw new RuntimeException("The Table Editor requires the CLASSNAME attribute be set - the name of the object to represent a row");
        }
        try {
            this.clazz = Class.forName(value);
            this.initializeModel();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find the CLASSNAME class " + value, e);
        }
    }

    void initializeModel() {
        Object hdrs = this.descriptor.getValue(HEADERS);
        if (!(hdrs instanceof String[])) {
            throw new RuntimeException("attribute HEADERS must be a String array");
        }
        if (this.clazz == String.class) {
            this.model = new ObjectTableModel((String[])hdrs, new Functor[0], new Functor[0], new Class[]{String.class});
        } else {
            Object value = this.descriptor.getValue(OBJECT_PROPERTIES);
            if (!(value instanceof String[])) {
                throw new RuntimeException("attribute OBJECT_PROPERTIES must be a String array");
            }
            List<String> props = Arrays.stream((String[])value).map(StringUtils::capitalize).collect(Collectors.toList());
            Functor[] writers = this.createWriters(props);
            Functor[] readers = this.createReaders(this.clazz, props);
            Class[] editors = this.getArgsForWriter(this.clazz, props);
            this.model = new ObjectTableModel((String[])hdrs, readers, writers, editors);
        }
        this.model.addTableModelListener((TableModelListener)this);
        this.table = new JTable((TableModel)this.model);
        JMeterUtils.applyHiDPI(this.table);
        this.table.setSelectionMode(0);
        this.table.addFocusListener(this);
    }

    private Functor[] createWriters(List<String> propNames) {
        return (Functor[])propNames.stream().map(propName -> "set" + propName).map(Functor::new).toArray(Functor[]::new);
    }

    private Functor[] createReaders(Class<?> c, List<String> propNames) {
        List methodNames = Arrays.stream(c.getMethods()).map(Method::getName).collect(Collectors.toList());
        return (Functor[])propNames.stream().map(name -> methodNames.contains("get" + name) ? "get" + name : "is" + name).map(Functor::new).toArray(Functor[]::new);
    }

    private Class<?>[] getArgsForWriter(Class<?> c, List<String> propNames) {
        return (Class[])propNames.stream().map(propName -> Arrays.stream(c.getMethods()).filter(m -> m.getName().equals("set" + propName)).map(m -> m.getParameterTypes()[0]).findFirst().orElse(null)).toArray(Class[]::new);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.firePropertyChange();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        int editingRow = this.table.getEditingRow();
        int editingColumn = this.table.getEditingColumn();
        TableCellEditor ce = null;
        if (editingRow != -1 && editingColumn != -1) {
            ce = this.table.getCellEditor(editingRow, editingColumn);
        }
        Component editor = this.table.getEditorComponent();
        if (ce != null && (editor == null || editor != e.getOppositeComponent())) {
            ce.stopCellEditing();
        } else if (editor != null) {
            editor.addFocusListener(this);
        }
        this.firePropertyChange();
    }

    @Override
    public void clearGui() {
        this.model.clearData();
    }

    private class DownListener
    implements ActionListener {
        private DownListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiUtils.cancelEditing((JTable)TableEditor.this.table);
            int[] rowsSelected = TableEditor.this.table.getSelectedRows();
            if (rowsSelected.length > 0 && rowsSelected[rowsSelected.length - 1] < TableEditor.this.table.getRowCount() - 1) {
                TableEditor.this.table.clearSelection();
                for (int i = rowsSelected.length - 1; i >= 0; --i) {
                    int rowSelected = rowsSelected[i];
                    TableEditor.this.model.moveRow(rowSelected, rowSelected + 1, rowSelected + 1);
                }
                for (int rowSelected : rowsSelected) {
                    TableEditor.this.table.addRowSelectionInterval(rowSelected + 1, rowSelected + 1);
                }
            }
        }
    }

    private class UpListener
    implements ActionListener {
        private UpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiUtils.cancelEditing((JTable)TableEditor.this.table);
            int[] rowsSelected = TableEditor.this.table.getSelectedRows();
            if (rowsSelected.length > 0 && rowsSelected[0] > 0) {
                TableEditor.this.table.clearSelection();
                for (int rowSelected : rowsSelected) {
                    TableEditor.this.model.moveRow(rowSelected, rowSelected + 1, rowSelected - 1);
                }
                for (int rowSelected : rowsSelected) {
                    TableEditor.this.table.addRowSelectionInterval(rowSelected - 1, rowSelected - 1);
                }
            }
        }
    }

    private class ClearListener
    implements ActionListener {
        private ClearListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableEditor.this.model.clearData();
            TableEditor.this.upButton.setEnabled(false);
            TableEditor.this.downButton.setEnabled(false);
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = TableEditor.this.table.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                TableEditor.this.model.removeRow(rows[i] - i);
            }
            if (TableEditor.this.model.getRowCount() > 1) {
                TableEditor.this.upButton.setEnabled(true);
                TableEditor.this.downButton.setEnabled(true);
            } else {
                TableEditor.this.upButton.setEnabled(false);
                TableEditor.this.downButton.setEnabled(false);
            }
        }
    }

    private class ClipListener
    implements ActionListener {
        private ClipListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String[] clipboardLines;
                String clipboardContent = GuiUtils.getPastedText();
                if (clipboardContent == null) {
                    return;
                }
                for (String clipboardLine : clipboardLines = clipboardContent.split("\n")) {
                    String[] columns = clipboardLine.split("\t");
                    TableEditor.this.model.addRow(TableEditor.this.clazz.newInstance());
                    for (int i = 0; i < columns.length; ++i) {
                        TableEditor.this.model.setValueAt((Object)columns[i], TableEditor.this.model.getRowCount() - 1, i);
                    }
                }
                if (TableEditor.this.model.getRowCount() > 1) {
                    TableEditor.this.upButton.setEnabled(true);
                    TableEditor.this.downButton.setEnabled(true);
                } else {
                    TableEditor.this.upButton.setEnabled(false);
                    TableEditor.this.downButton.setEnabled(false);
                }
            }
            catch (Exception err) {
                log.error("The class type given to TableEditor was not instantiable.", (Throwable)err);
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TableEditor.this.model.addRow(TableEditor.this.clazz.newInstance());
                TableEditor.this.removeButton.setEnabled(true);
                TableEditor.this.clearButton.setEnabled(true);
            }
            catch (Exception err) {
                log.error("The class type given to TableEditor was not instantiable.", (Throwable)err);
            }
        }
    }
}

