/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.report.core.AbstractSampleWriter;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleMetadata;
import org.apache.jmeter.save.CSVSaveService;

public class CsvSampleWriter
extends AbstractSampleWriter {
    private int columnCount;
    private char separator;
    private SampleMetadata metadata;
    private long sampleCount;

    public CsvSampleWriter(SampleMetadata metadata) {
        this.metadata = metadata;
        this.columnCount = metadata.getColumnCount();
        this.separator = metadata.getSeparator();
        this.sampleCount = 0L;
    }

    public CsvSampleWriter(Writer output, SampleMetadata metadata) {
        this(metadata);
        this.setWriter(output);
    }

    public CsvSampleWriter(OutputStream output, SampleMetadata metadata) {
        this(metadata);
        this.setOutputStream(output);
    }

    public CsvSampleWriter(File output, SampleMetadata metadata) {
        this(metadata);
        this.setOutputFile(output);
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    private void reset() {
        this.sampleCount = 0L;
    }

    @Override
    public void setWriter(Writer writer) {
        super.setWriter(writer);
        this.reset();
    }

    public void writeHeader() {
        Validate.validState((this.writer != null ? 1 : 0) != 0, (String)"No writer set! Call setWriter() first!", (Object[])new Object[0]);
        StringBuilder row = new StringBuilder();
        for (int i = 0; i < this.columnCount; ++i) {
            row.append(this.metadata.getColumnName(i));
            if (i >= this.columnCount - 1) continue;
            row.append(this.separator);
        }
        this.writer.println(row.toString());
    }

    @Override
    public long write(Sample sample) {
        Validate.validState((this.writer != null ? 1 : 0) != 0, (String)"No writer set! Call setWriter() first!", (Object[])new Object[0]);
        StringBuilder row = new StringBuilder();
        char[] specials = new char[]{this.separator, '\"', '\r', '\n'};
        for (int i = 0; i < this.columnCount; ++i) {
            String data = sample.getData(i);
            row.append(CSVSaveService.quoteDelimiters(data, specials)).append(this.separator);
        }
        row.setLength(row.length() - 1);
        this.writer.println(row.toString());
        ++this.sampleCount;
        return this.sampleCount;
    }
}

