/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.Replaceable;
import org.apache.jmeter.gui.Searchable;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.action.RawTextSearcher;
import org.apache.jmeter.gui.action.RegexpSearcher;
import org.apache.jmeter.gui.action.Searcher;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTreeDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4436834972710248247L;
    private static final Logger logger = LoggerFactory.getLogger(SearchTreeDialog.class);
    private static final Font FONT_DEFAULT = UIManager.getDefaults().getFont("TextField.font");
    private static final Font FONT_SMALL = new Font("SansSerif", 0, (int)Math.round((double)FONT_DEFAULT.getSize() * 0.8));
    private JButton searchButton;
    private JLabeledTextField searchTF;
    private JLabeledTextField replaceTF;
    private JLabel statusLabel;
    private JCheckBox isRegexpCB;
    private JCheckBox isCaseSensitiveCB;
    private JButton cancelButton;
    private transient String lastSearch = null;
    private JButton searchAndExpandButton;

    public SearchTreeDialog() {
        super((Frame)null, JMeterUtils.getResString("search_tree_title"), false);
        this.init();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -6543764044868772971L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTreeDialog.this.setVisible(false);
            }
        };
        AbstractAction enterAction = new AbstractAction("ENTER"){
            private static final long serialVersionUID = -3661361497864527363L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTreeDialog.this.doSearch(actionEvent);
            }
        };
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escapeAction.getValue("Name"), escapeAction);
        actionMap.put(enterAction.getValue("Name"), enterAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        inputMap.put(KeyStrokes.ENTER, enterAction.getValue("Name"));
        return rootPane;
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.searchTF = new JLabeledTextField(JMeterUtils.getResString("search_text_field"), 20);
        if (!StringUtils.isEmpty((CharSequence)this.lastSearch)) {
            this.searchTF.setText(this.lastSearch);
        }
        this.replaceTF = new JLabeledTextField(JMeterUtils.getResString("search_text_replace"), 20);
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setPreferredSize(new Dimension(100, 20));
        this.statusLabel.setMinimumSize(new Dimension(100, 20));
        this.isRegexpCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_regexp"), false);
        this.isCaseSensitiveCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_case"), true);
        this.isRegexpCB.setFont(FONT_SMALL);
        this.isCaseSensitiveCB.setFont(FONT_SMALL);
        JPanel searchCriterionPanel = new JPanel(new FlowLayout(1));
        searchCriterionPanel.add(this.isCaseSensitiveCB);
        searchCriterionPanel.add(this.isRegexpCB);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 1));
        searchPanel.setBorder(BorderFactory.createEmptyBorder(7, 3, 3, 3));
        searchPanel.add((Component)this.searchTF);
        searchPanel.add((Component)this.replaceTF);
        searchPanel.add(this.statusLabel);
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.searchButton = new JButton(JMeterUtils.getResString("search"));
        this.searchButton.addActionListener(this);
        this.searchAndExpandButton = new JButton(JMeterUtils.getResString("search_expand"));
        this.searchAndExpandButton.addActionListener(this);
        JButton replaceButton = new JButton(JMeterUtils.getResString("search_replace_all"));
        replaceButton.addActionListener(this);
        this.cancelButton = new JButton(JMeterUtils.getResString("cancel"));
        this.cancelButton.addActionListener(this);
        buttonsPanel.add(this.searchButton);
        buttonsPanel.add(this.searchAndExpandButton);
        buttonsPanel.add(replaceButton);
        buttonsPanel.add(this.cancelButton);
        JPanel searchAndReplacePanel = new JPanel();
        searchAndReplacePanel.setLayout((LayoutManager)new VerticalLayout());
        searchAndReplacePanel.add(searchPanel);
        searchAndReplacePanel.add(searchCriterionPanel);
        searchAndReplacePanel.add(buttonsPanel);
        this.getContentPane().add(searchAndReplacePanel);
        this.searchTF.requestFocusInWindow();
        this.pack();
        ComponentUtil.centerComponentInWindow((Component)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.statusLabel.setText("");
        if (e.getSource() == this.cancelButton) {
            this.searchTF.requestFocusInWindow();
            this.setVisible(false);
        } else if (e.getSource() == this.searchButton || e.getSource() == this.searchAndExpandButton) {
            this.doSearch(e);
        } else {
            this.doReplaceAll(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSearch(ActionEvent e) {
        boolean expand = e.getSource() == this.searchAndExpandButton;
        String wordToSearch = this.searchTF.getText();
        if (StringUtils.isEmpty((CharSequence)wordToSearch)) {
            return;
        }
        this.lastSearch = wordToSearch;
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "search_reset"));
        Searcher searcher = this.isRegexpCB.isSelected() ? new RegexpSearcher(this.isCaseSensitiveCB.isSelected(), this.searchTF.getText()) : new RawTextSearcher(this.isCaseSensitiveCB.isSelected(), this.searchTF.getText());
        GuiPackage guiPackage = GuiPackage.getInstance();
        int numberOfMatches = 0;
        try {
            guiPackage.beginUndoTransaction();
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            HashSet<JMeterTreeNode> nodes = new HashSet<JMeterTreeNode>();
            for (JMeterTreeNode jMeterTreeNode : jMeterTreeModel.getNodesOfType(Searchable.class)) {
                try {
                    Searchable searchable = (Searchable)jMeterTreeNode.getUserObject();
                    List<JMeterTreeNode> matchingNodes = jMeterTreeNode.getPathToThreadGroup();
                    List<String> searchableTokens = searchable.getSearchableTokens();
                    boolean result = searcher.search(searchableTokens);
                    if (!result) continue;
                    ++numberOfMatches;
                    nodes.addAll(matchingNodes);
                }
                catch (Exception ex) {
                    logger.error("Error occurred searching for word:" + wordToSearch + " in node:" + jMeterTreeNode.getName(), (Throwable)ex);
                }
            }
            GuiPackage guiInstance = GuiPackage.getInstance();
            JTree jTree = guiInstance.getMainFrame().getTree();
            for (JMeterTreeNode jMeterTreeNode : nodes) {
                jMeterTreeNode.setMarkedBySearch(true);
                if (!expand) continue;
                jTree.expandPath(new TreePath(jMeterTreeNode.getPath()));
            }
        }
        finally {
            guiPackage.endUndoTransaction();
        }
        GuiPackage.getInstance().getMainFrame().repaint();
        this.searchTF.requestFocusInWindow();
        this.statusLabel.setText(MessageFormat.format(JMeterUtils.getResString("search_tree_matches"), numberOfMatches));
    }

    private void doReplaceAll(ActionEvent e) {
        Searcher searcher;
        String regex;
        String wordToSearch = this.searchTF.getText();
        String wordToReplace = this.replaceTF.getText();
        if (StringUtils.isEmpty((CharSequence)wordToReplace)) {
            return;
        }
        GuiPackage.getInstance().updateCurrentNode();
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "search_reset"));
        if (this.isRegexpCB.isSelected()) {
            regex = wordToSearch;
            searcher = new RegexpSearcher(this.isCaseSensitiveCB.isSelected(), wordToSearch);
        } else {
            regex = Pattern.quote(wordToSearch);
            searcher = new RawTextSearcher(this.isCaseSensitiveCB.isSelected(), wordToSearch);
        }
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
        HashSet<JMeterTreeNode> nodes = new HashSet<JMeterTreeNode>();
        boolean caseSensitiveReplacement = this.isCaseSensitiveCB.isSelected();
        int totalReplaced = 0;
        for (JMeterTreeNode jMeterTreeNode : jMeterTreeModel.getNodesOfType(Searchable.class)) {
            try {
                Searchable searchable = (Searchable)jMeterTreeNode.getUserObject();
                List<String> searchableTokens = searchable.getSearchableTokens();
                boolean result = searcher.search(searchableTokens);
                if (!result || !(jMeterTreeNode.getUserObject() instanceof Replaceable)) continue;
                Replaceable replaceable = (Replaceable)jMeterTreeNode.getUserObject();
                int numberOfReplacements = replaceable.replace(regex, wordToReplace, caseSensitiveReplacement);
                if (logger.isInfoEnabled()) {
                    logger.info("Replaced " + numberOfReplacements + " in element:" + ((TestElement)jMeterTreeNode.getUserObject()).getName());
                }
                totalReplaced += numberOfReplacements;
                if (numberOfReplacements <= 0) continue;
                List<JMeterTreeNode> matchingNodes = jMeterTreeNode.getPathToThreadGroup();
                nodes.addAll(matchingNodes);
            }
            catch (Exception ex) {
                logger.error("Error occurred replacing data in node:" + jMeterTreeNode.getName(), (Throwable)ex);
            }
        }
        this.statusLabel.setText(MessageFormat.format("Replaced {0} occurrences", totalReplaced));
        GuiPackage guiInstance = GuiPackage.getInstance();
        JTree jTree = guiInstance.getMainFrame().getTree();
        for (JMeterTreeNode jMeterTreeNode : nodes) {
            jMeterTreeNode.setMarkedBySearch(true);
            jTree.expandPath(new TreePath(jMeterTreeNode.getPath()));
        }
        if (totalReplaced > 0) {
            GuiPackage.getInstance().refreshCurrentGui();
        }
        GuiPackage.getInstance().getMainFrame().repaint();
        this.searchTF.requestFocusInWindow();
    }
}

