/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLevelCommand
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(LogLevelCommand.class);
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent ev) {
        String levelString = ev.getActionCommand().substring("loglevel:".length());
        log.warn("Setting root log level: {}", (Object)levelString);
        Configurator.setRootLevel((Level)Level.toLevel((String)levelString));
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        for (org.slf4j.event.Level level : org.slf4j.event.Level.values()) {
            commands.add("loglevel:" + level.toString());
        }
    }
}

