/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.io.File;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteObject;
import java.util.Properties;
import org.apache.jmeter.engine.ConvertListeners;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.PreCompiler;
import org.apache.jmeter.engine.RemoteJMeterEngine;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.engine.TurnElementsOn;
import org.apache.jmeter.rmi.RmiUtils;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientJMeterEngine
implements JMeterEngine {
    private static final Logger log = LoggerFactory.getLogger(ClientJMeterEngine.class);
    private static final Object LOCK = new Object();
    private RemoteJMeterEngine remote;
    private HashTree test;
    private final String hostAndPort;
    private Properties savep;

    private static RemoteJMeterEngine getEngine(String hostAndPort) throws RemoteException, NotBoundException {
        Registry registry;
        Remote remobj;
        String name = "JMeterEngine";
        String host = hostAndPort;
        int port = RmiUtils.DEFAULT_RMI_PORT;
        int indexOfSeparator = hostAndPort.indexOf(58);
        if (indexOfSeparator >= 0) {
            host = hostAndPort.substring(0, indexOfSeparator);
            String portAsString = hostAndPort.substring(indexOfSeparator + 1);
            port = Integer.parseInt(portAsString);
        }
        if ((remobj = (registry = LocateRegistry.getRegistry(host, port, RmiUtils.createClientSocketFactory())).lookup("JMeterEngine")) instanceof RemoteJMeterEngine) {
            RemoteJMeterEngine rje = (RemoteJMeterEngine)remobj;
            if (remobj instanceof RemoteObject) {
                RemoteObject robj = (RemoteObject)remobj;
                System.out.println("Using remote object: " + robj.getRef().remoteToString());
            }
            return rje;
        }
        throw new RemoteException("Could not find JMeterEngine");
    }

    public ClientJMeterEngine(String hostAndPort) throws NotBoundException, RemoteException {
        this.remote = ClientJMeterEngine.getEngine(hostAndPort);
        this.hostAndPort = hostAndPort;
    }

    @Override
    public void configure(HashTree testTree) {
        TreeCloner cloner = new TreeCloner(false);
        testTree.traverse((HashTreeTraverser)cloner);
        this.test = cloner.getClonedTree();
    }

    @Override
    public void stopTest(boolean now) {
        log.info("about to {} remote test on {}", (Object)(now ? "stop" : "shutdown"), (Object)this.hostAndPort);
        try {
            this.remote.rstopTest(now);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    @Override
    public void reset() {
        try {
            try {
                this.remote.rreset();
            }
            catch (ConnectException e) {
                log.info("Retry reset after: " + e);
                this.remote = ClientJMeterEngine.getEngine(this.hostAndPort);
                this.remote.rreset();
            }
        }
        catch (Exception ex) {
            log.error("Failed to reset remote engine", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest() throws JMeterEngineException {
        HashTree testTree;
        log.info("running clientengine run method");
        JMeterContextService.clearTotalThreads();
        HashTree hashTree = testTree = this.test;
        synchronized (hashTree) {
            PreCompiler compiler = new PreCompiler(true);
            testTree.traverse((HashTreeTraverser)compiler);
            JMeterContextService.initClientSideVariables(compiler.getClientSideVariables());
            testTree.traverse((HashTreeTraverser)new TurnElementsOn());
            testTree.traverse((HashTreeTraverser)new ConvertListeners());
        }
        String methodName = "unknown";
        try {
            JMeterContextService.startTest();
            File baseDirRelative = FileServer.getFileServer().getBaseDirRelative();
            String scriptName = FileServer.getFileServer().getScriptName();
            Object object = LOCK;
            synchronized (object) {
                methodName = "rconfigure()";
                this.remote.rconfigure(testTree, this.hostAndPort, baseDirRelative, scriptName);
            }
            log.info("sent test to {} basedir='{}'", (Object)this.hostAndPort, (Object)baseDirRelative);
            if (this.savep == null) {
                this.savep = new Properties();
            }
            log.info("Sending properties {}", (Object)this.savep);
            try {
                methodName = "rsetProperties()";
                this.remote.rsetProperties(this.savep);
            }
            catch (RemoteException e) {
                log.warn("Could not set properties: " + e.toString());
            }
            methodName = "rrunTest()";
            this.remote.rrunTest();
            log.info("sent run command to {}", (Object)this.hostAndPort);
        }
        catch (IllegalStateException ex) {
            log.error("Error in {} method ", (Object)methodName, (Object)ex);
            ClientJMeterEngine.tidyRMI(log);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Error in " + methodName + " method " + ex);
            ClientJMeterEngine.tidyRMI(log);
            throw new JMeterEngineException("Error in " + methodName + " method " + ex, ex);
        }
    }

    public static void tidyRMI(Logger logger) {
        String reaperRE = JMeterUtils.getPropDefault("rmi.thread.name", "^RMI Reaper$");
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            String name = t.getName();
            if (!name.matches(reaperRE)) continue;
            logger.info("Interrupting {}", (Object)name);
            t.interrupt();
        }
    }

    @Override
    public void exit() {
        log.info("about to exit remote server on {}", (Object)this.hostAndPort);
        try {
            this.remote.rexit();
        }
        catch (RemoteException e) {
            log.warn("Could not perform remote exit: " + e.toString());
        }
    }

    @Override
    public void setProperties(Properties p) {
        this.savep = p;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public String getHost() {
        return this.hostAndPort;
    }
}

