/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeVisitor;
import jodd.util.StringUtil;
import jodd.util.net.HtmlDecoder;
import jodd.util.net.HtmlEncoder;

public class Text
extends Node {
    protected String encodedText;
    protected Boolean blank;

    public Text(Document ownerDocument, String text) {
        super(ownerDocument, Node.NodeType.TEXT, null);
        this.nodeValue = text;
        this.encodedText = null;
    }

    @Override
    public Text clone() {
        return this.cloneTo(new Text(this.ownerDocument, this.nodeValue));
    }

    public boolean isBlank() {
        if (this.blank == null) {
            this.blank = StringUtil.isBlank((CharSequence)this.nodeValue);
        }
        return this.blank;
    }

    @Override
    public void setNodeValue(String value) {
        this.encodedText = null;
        super.setNodeValue(value);
    }

    public void setTextValue(String text) {
        this.encodedText = text;
        this.nodeValue = HtmlDecoder.decode((String)text);
    }

    public String getTextValue() {
        if (this.encodedText == null) {
            this.encodedText = HtmlEncoder.text((CharSequence)this.nodeValue);
        }
        return this.encodedText;
    }

    @Override
    protected void visitNode(NodeVisitor nodeVisitor) {
        nodeVisitor.text(this);
    }
}

