/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.statistics;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.statistics.IStatisticsHandlerNumeric;
import java.math.BigInteger;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractStatisticsHandlerNumeric
implements IStatisticsHandlerNumeric {
    private final transient SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private int m_nInvocationCount = 0;
    private long m_nMin = -1L;
    private long m_nMax = -1L;
    private BigInteger m_aSum = BigInteger.ZERO;

    @Override
    @Nonnegative
    public final int getInvocationCount() {
        return this.m_aRWLock.readLocked(() -> this.m_nInvocationCount);
    }

    protected final void addValue(long l) {
        this.m_aRWLock.writeLock().lock();
        try {
            ++this.m_nInvocationCount;
            if (this.m_nMin == -1L || l < this.m_nMin) {
                this.m_nMin = l;
            }
            if (this.m_nMax == -1L || l > this.m_nMax) {
                this.m_nMax = l;
            }
            this.m_aSum = this.m_aSum.add(BigInteger.valueOf(l));
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @Nonnull
    public final BigInteger getSum() {
        return this.m_aRWLock.readLocked(() -> this.m_aSum);
    }

    @Override
    @CheckForSigned
    public final long getMin() {
        return this.m_aRWLock.readLocked(() -> this.m_nMin);
    }

    @Override
    @CheckForSigned
    public final long getAverage() {
        return this.m_aRWLock.readLocked(() -> {
            if (this.m_nInvocationCount == 0) {
                return -1L;
            }
            return this.m_aSum.divide(BigInteger.valueOf(this.m_nInvocationCount)).longValue();
        });
    }

    @Override
    @CheckForSigned
    public long getMax() {
        return this.m_aRWLock.readLocked(() -> this.m_nMax);
    }
}

