/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.io.stream.WrappedInputStream;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CountingInputStream
extends WrappedInputStream {
    private long m_nBytesRead = 0L;
    private long m_nPosition = 0L;
    private long m_nMark = 0L;

    public CountingInputStream(@Nonnull InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.m_nBytesRead;
            ++this.m_nPosition;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.m_nBytesRead += (long)n3;
            this.m_nPosition += (long)n3;
        }
        return n3;
    }

    @Override
    public long skip(@Nonnegative long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            this.m_nPosition += l2;
        }
        return l2;
    }

    @Override
    public void mark(@Nonnegative int n) {
        super.mark(n);
        this.m_nMark = this.m_nPosition;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.m_nPosition = this.m_nMark;
    }

    @Nonnegative
    public long getBytesRead() {
        return this.m_nBytesRead;
    }

    @Nonnegative
    public long getPosition() {
        return this.m_nPosition;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("bytesRead", this.m_nBytesRead).append("position", this.m_nPosition).getToString();
    }
}

