/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.http;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHttpMethod implements IHasName
{
    OPTIONS("OPTIONS"),
    GET("GET"),
    HEAD("HEAD"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE"),
    TRACE("TRACE"),
    CONNECT("CONNECT"),
    PATCH("PATCH");

    private final String m_sName;

    private EHttpMethod(String string2) {
        this.m_sName = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    public boolean isIdempodent() {
        return this == GET || this == HEAD || this == PUT || this == DELETE || this == OPTIONS || this == TRACE;
    }

    public boolean isContentAllowed() {
        return this != HEAD;
    }

    public boolean isPayloadInBody() {
        return this == POST || this == PUT || this == PATCH;
    }

    @Nullable
    public static EHttpMethod getFromNameOrNull(@Nullable String string) {
        return EnumHelper.getFromNameOrNull(EHttpMethod.class, string);
    }
}

