/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.collection.iterate.IterableIterator;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.state.EChange;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsCollection<ELEMENTTYPE>
extends Collection<ELEMENTTYPE>,
ICommonsIterable<ELEMENTTYPE>,
IHasSize {
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<ELEMENTTYPE> getCopyAsList() {
        return new CommonsArrayList<ICommonsCollection>(this);
    }

    @Override
    @Nonnegative
    default public int getCount(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.getCount(this, predicate);
    }

    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nonnegative int n) {
        return this.getAtIndex(n, null);
    }

    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.getAtIndex(null, n, ELEMENTTYPE);
    }

    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n) {
        return this.getAtIndex(predicate, n, null);
    }

    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return CollectionHelper.getAtIndex(this, predicate, n, ELEMENTTYPE);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAtIndexMapped(@Nonnegative int n, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function) {
        return this.getAtIndexMapped(n, function, null);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAtIndexMapped(@Nonnegative int n, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionHelper.getAtIndexMapped(this, n, function, DSTTYPE);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAtIndexMapped(@Nonnull Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function) {
        return this.getAtIndexMapped(predicate, n, function, null);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAtIndexMapped(@Nonnull Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionHelper.getAtIndexMapped(this, predicate, n, function, DSTTYPE);
    }

    @Nonnull
    default public ICommonsList<ELEMENTTYPE> getSorted(@Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return new CommonsArrayList<ICommonsCollection>(this).getSortedInline(comparator);
    }

    @Nonnull
    default public EChange addObject(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return EChange.valueOf(this.add(ELEMENTTYPE));
    }

    @Nonnull
    default public EChange addIf(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate != null && !predicate.test(ELEMENTTYPE)) {
            return EChange.UNCHANGED;
        }
        return this.addObject(ELEMENTTYPE);
    }

    @Nonnull
    default public EChange addIfNotNull(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (ELEMENTTYPE == null) {
            return EChange.UNCHANGED;
        }
        return this.addObject(ELEMENTTYPE);
    }

    @Nonnull
    default public EChange addAll(ELEMENTTYPE ... ELEMENTTYPEArray) {
        EChange eChange = EChange.UNCHANGED;
        if (ELEMENTTYPEArray != null) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange addAll(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange addAll(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        EChange eChange = EChange.UNCHANGED;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                eChange = eChange.or(this.add(enumeration.nextElement()));
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange addAll(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        EChange eChange = EChange.UNCHANGED;
        if (iterator != null) {
            while (iterator.hasNext()) {
                eChange = eChange.or(this.add(iterator.next()));
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange addAll(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.addAll(ELEMENTTYPEArray);
        }
        EChange eChange = EChange.UNCHANGED;
        if (ELEMENTTYPEArray != null) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange addAll(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.addAll(iterable);
        }
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange addAll(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.addAll(enumeration);
        }
        EChange eChange = EChange.UNCHANGED;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ELEMENTTYPE ELEMENTTYPE = enumeration.nextElement();
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange addAll(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.addAll(iterator);
        }
        EChange eChange = EChange.UNCHANGED;
        if (iterator != null) {
            while (iterator.hasNext()) {
                ELEMENTTYPE ELEMENTTYPE = iterator.next();
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    @Nonnull
    default public <SRCTYPE> EChange addAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        ValueEnforcer.notNull(function, "Mapper");
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                eChange = eChange.or(this.add(function.apply(SRCTYPE)));
            }
        }
        return eChange;
    }

    @Nonnull
    default public <SRCTYPE> EChange addAllMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        ValueEnforcer.notNull(function, "Mapper");
        EChange eChange = EChange.UNCHANGED;
        if (SRCTYPEArray != null) {
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                eChange = eChange.or(this.add(function.apply(SRCTYPE)));
            }
        }
        return eChange;
    }

    @Nonnull
    default public <SRCTYPE> EChange addAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        ValueEnforcer.notNull(function, "Mapper");
        if (predicate == null) {
            return this.addAllMapped(iterable, function);
        }
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                if (!predicate.test(SRCTYPE)) continue;
                eChange = eChange.or(this.add(function.apply(SRCTYPE)));
            }
        }
        return eChange;
    }

    @Nonnull
    default public <SRCTYPE> EChange addAllMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        ValueEnforcer.notNull(function, "Mapper");
        if (predicate == null) {
            return this.addAllMapped(SRCTYPEArray, function);
        }
        EChange eChange = EChange.UNCHANGED;
        if (SRCTYPEArray != null) {
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                if (!predicate.test(SRCTYPE)) continue;
                eChange = eChange.or(this.add(function.apply(SRCTYPE)));
            }
        }
        return eChange;
    }

    @Nonnull
    default public <SRCTYPE> EChange addAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        ValueEnforcer.notNull(function, "Mapper");
        if (predicate == null) {
            return this.addAllMapped(iterable, function);
        }
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                ELEMENTTYPE ELEMENTTYPE = function.apply(SRCTYPE);
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    @Nonnull
    default public <SRCTYPE> EChange addAllMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        ValueEnforcer.notNull(function, "Mapper");
        if (predicate == null) {
            return this.addAllMapped(SRCTYPEArray, function);
        }
        EChange eChange = EChange.UNCHANGED;
        if (SRCTYPEArray != null) {
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                ELEMENTTYPE ELEMENTTYPE = function.apply(SRCTYPE);
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange set(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.removeAll().or(this.add(ELEMENTTYPE));
    }

    @Nonnull
    default public EChange setAll(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return this.removeAll().or(this.addAll(iterable));
    }

    @Nonnull
    default public EChange setAll(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return this.removeAll().or(this.addAll(ELEMENTTYPEArray));
    }

    @Nonnull
    default public EChange removeAll() {
        if (this.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    default public EChange removeObject(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return EChange.valueOf(this.remove(ELEMENTTYPE));
    }

    @Nonnull
    @CodingStyleguideUnaware
    default public Collection<ELEMENTTYPE> getAsUnmodifiable() {
        return Collections.unmodifiableCollection(this);
    }

    @Nonnull
    default public IIterableIterator<ELEMENTTYPE> iterator2() {
        return new IterableIterator(this);
    }
}

