/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ftp.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.apache.jmeter.config.gui.LoginConfigGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.ftp.config.gui.FtpConfigGui;
import org.apache.jmeter.protocol.ftp.sampler.FTPSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class FtpTestSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private LoginConfigGui loginPanel;
    private FtpConfigGui ftpDefaultPanel;

    public FtpTestSamplerGui() {
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.loginPanel.configure(element);
        this.ftpDefaultPanel.configure(element);
    }

    public TestElement createTestElement() {
        FTPSampler sampler = new FTPSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        sampler.clear();
        this.ftpDefaultPanel.modifyTestElement(sampler);
        this.loginPanel.modifyTestElement(sampler);
        super.configureTestElement(sampler);
    }

    public void clearGui() {
        super.clearGui();
        this.ftpDefaultPanel.clearGui();
        this.loginPanel.clearGui();
    }

    public String getLabelResource() {
        return "ftp_testing_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel mainPanel = new VerticalPanel();
        this.ftpDefaultPanel = new FtpConfigGui(false);
        mainPanel.add((Component)((Object)this.ftpDefaultPanel));
        this.loginPanel = new LoginConfigGui(false);
        this.loginPanel.setBorder((Border)BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"login_config")));
        mainPanel.add((Component)this.loginPanel);
        this.add((Component)mainPanel, "Center");
    }
}

