/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberLineNames
implements ICSSExpressionMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberLineNames() {
    }

    public CSSExpressionMemberLineNames(@Nonnull Iterable<? extends String> iterable) {
        this.m_aMembers.addAll(iterable);
    }

    @Nonnull
    public CSSExpressionMemberLineNames addMember(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Member");
        this.m_aMembers.add((Object)string);
        return this;
    }

    @Nonnull
    public CSSExpressionMemberLineNames addMember(@Nonnegative int n, @Nonnull @Nonempty String string) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)string, (String)"Member");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add((Object)string);
        } else {
            this.m_aMembers.add(n, (Object)string);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull String string) {
        return this.m_aMembers.removeObject((Object)string);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSExpressionMemberLineNames getClone() {
        return new CSSExpressionMemberLineNames((Iterable<? extends String>)this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder().append('[');
        boolean bl = true;
        for (String string : this.m_aMembers) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberLineNames cSSExpressionMemberLineNames = (CSSExpressionMemberLineNames)object;
        return this.m_aMembers.equals(cSSExpressionMemberLineNames.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

