/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.cl;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import jodd.util.ArraysUtil;
import jodd.util.StringUtil;
import jodd.util.SystemUtil;
import jodd.util.Wildcard;

public class ExtendedURLClassLoader
extends URLClassLoader {
    protected final ClassLoader parentClassLoader;
    protected String[] parentOnlyRules;
    protected String[] loaderOnlyRules;
    protected final boolean parentFirst;
    protected boolean matchResourcesAsPackages = true;

    public ExtendedURLClassLoader(URL[] classpath, ClassLoader parent, boolean parentFirst) {
        this(classpath, parent, parentFirst, true);
    }

    public ExtendedURLClassLoader(URL[] classpath, ClassLoader parent, boolean parentFirst, boolean excludeJrePackagesFromLoader) {
        super(classpath, parent);
        this.parentFirst = parentFirst;
        if (parent == null) {
            throw new IllegalArgumentException("Parent classloader not specified");
        }
        this.parentClassLoader = parent;
        this.parentOnlyRules = new String[0];
        this.loaderOnlyRules = new String[0];
        if (excludeJrePackagesFromLoader) {
            String[] corePackages;
            for (String corePackage : corePackages = SystemUtil.jrePackages()) {
                if (corePackage.equals("javax")) continue;
                this.addParentOnlyRules(corePackage + ".*");
            }
        }
    }

    public void addParentOnlyRules(String ... packages) {
        this.parentOnlyRules = ArraysUtil.join(this.parentOnlyRules, packages);
    }

    public void addLoaderOnlyRules(String ... packages) {
        this.loaderOnlyRules = ArraysUtil.join(this.loaderOnlyRules, packages);
    }

    public void setMatchResourcesAsPackages(boolean matchResourcesAsPackages) {
        this.matchResourcesAsPackages = matchResourcesAsPackages;
    }

    protected boolean isMatchingRules(String name, String ... rules) {
        for (String rule : rules) {
            if (!Wildcard.equalsOrMatch(name, rule)) continue;
            return true;
        }
        return false;
    }

    protected Loading resolveLoading(boolean parentFirstStrategy, String className) {
        boolean withParent = true;
        boolean withLoader = true;
        if (parentFirstStrategy) {
            if (this.isMatchingRules(className, this.loaderOnlyRules)) {
                withParent = false;
            } else if (this.isMatchingRules(className, this.parentOnlyRules)) {
                withLoader = false;
            }
        } else if (this.isMatchingRules(className, this.parentOnlyRules)) {
            withLoader = false;
        } else if (this.isMatchingRules(className, this.loaderOnlyRules)) {
            withParent = false;
        }
        return new Loading(withParent, withLoader);
    }

    protected Loading resolveResourceLoading(boolean parentFirstStrategy, String resourceName) {
        if (this.matchResourcesAsPackages) {
            resourceName = StringUtil.replaceChar(resourceName, '/', '.');
        }
        return this.resolveLoading(parentFirstStrategy, resourceName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(className);
        if (c != null) {
            if (!resolve) return c;
            this.resolveClass(c);
            return c;
        }
        Loading loading = this.resolveLoading(this.parentFirst, className);
        if (this.parentFirst) {
            if (loading.withParent) {
                try {
                    c = this.parentClassLoader.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                if (!loading.withLoader) throw new ClassNotFoundException("Class not found: " + className);
                c = this.findClass(className);
            }
        } else {
            if (loading.withLoader) {
                try {
                    c = this.findClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                if (!loading.withParent) throw new ClassNotFoundException("Class not found: " + className);
                c = this.parentClassLoader.loadClass(className);
            }
        }
        if (!resolve) return c;
        this.resolveClass(c);
        return c;
    }

    @Override
    public URL getResource(String resourceName) {
        URL url = null;
        Loading loading = this.resolveResourceLoading(this.parentFirst, resourceName);
        if (this.parentFirst) {
            if (loading.withParent) {
                url = this.parentClassLoader.getResource(resourceName);
            }
            if (url == null && loading.withLoader) {
                url = this.findResource(resourceName);
            }
        } else {
            if (loading.withLoader) {
                url = this.findResource(resourceName);
            }
            if (url == null && loading.withParent) {
                url = this.parentClassLoader.getResource(resourceName);
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String resourceName) throws IOException {
        ArrayList<URL> urls;
        block8: {
            Loading loading;
            Enumeration<URL> parentUrls;
            Enumeration<URL> loaderUrls;
            block7: {
                urls = new ArrayList<URL>();
                loaderUrls = this.findResources(resourceName);
                parentUrls = this.parentClassLoader.getResources(resourceName);
                loading = this.resolveResourceLoading(this.parentFirst, resourceName);
                if (!this.parentFirst) break block7;
                if (loading.withParent) {
                    while (parentUrls.hasMoreElements()) {
                        urls.add(parentUrls.nextElement());
                    }
                }
                if (!loading.withLoader) break block8;
                while (loaderUrls.hasMoreElements()) {
                    urls.add(loaderUrls.nextElement());
                }
                break block8;
            }
            if (loading.withLoader) {
                while (loaderUrls.hasMoreElements()) {
                    urls.add(loaderUrls.nextElement());
                }
            }
            if (loading.withParent) {
                while (parentUrls.hasMoreElements()) {
                    urls.add(parentUrls.nextElement());
                }
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iterator;
            {
                this.iterator = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iterator.next();
            }
        };
    }

    protected static class Loading {
        protected final boolean withParent;
        protected final boolean withLoader;

        public Loading(boolean withParent, boolean withLoader) {
            this.withParent = withParent;
            this.withLoader = withLoader;
        }
    }
}

