/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.DefaultClientConnection;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.jmeter.util.HostNameSetter;

public class JMeterClientConnectionOperator
extends DefaultClientConnectionOperator {
    public JMeterClientConnectionOperator(SchemeRegistry schemes) {
        super(schemes);
    }

    public JMeterClientConnectionOperator(SchemeRegistry schemes, DnsResolver dnsResolver) {
        super(schemes, dnsResolver);
    }

    public OperatedClientConnection createConnection() {
        return new JMeterDefaultClientConnection();
    }

    private static class JMeterDefaultClientConnection
    extends DefaultClientConnection {
        public void opening(Socket sock, HttpHost target) throws IOException {
            super.opening(sock, target);
            if (sock instanceof SSLSocket) {
                HostNameSetter.setServerNameIndication((String)target.getHostName(), (SSLSocket)((SSLSocket)sock));
            }
        }
    }
}

