/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal;

import com.teamdev.jxbrowser.chromium.BrowserKeyEvent;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.NativeKeyModifiers;
import com.teamdev.jxbrowser.chromium.javafx.internal.MouseEventType;
import java.util.HashMap;
import java.util.Map;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.stage.Window;

public class FXUtil {
    private static final Map<EventType<MouseEvent>, MouseEventType> a = new HashMap<EventType<MouseEvent>, MouseEventType>();
    private static final Map<EventType<KeyEvent>, BrowserKeyEvent.KeyEventType> b = new HashMap<EventType<KeyEvent>, BrowserKeyEvent.KeyEventType>();

    public static int getNativeEventType(MouseEvent event) {
        Object object = event.getEventType();
        if ((object = a.get(object)) != null) {
            return ((MouseEventType)((Object)object)).getValue();
        }
        return 0;
    }

    public static BrowserKeyEvent.KeyEventType getBrowserKeyEventType(KeyEvent event) {
        KeyEvent keyEvent;
        return b.get(keyEvent.getEventType());
    }

    public static EventType<KeyEvent> getJavaEventType(int nativeEventType) {
        int n2;
        for (Map.Entry<EventType<KeyEvent>, BrowserKeyEvent.KeyEventType> entry : b.entrySet()) {
            if (entry.getValue().getValue() != nativeEventType) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Unsupported event type: " + n2);
    }

    public static int getModifiers(KeyEvent event) {
        KeyEvent keyEvent;
        int n2 = 0;
        if (event.isShiftDown()) {
            n2 = 0 | NativeKeyModifiers.SHIFT_DOWN_MASK.getValue();
        }
        if (event.isControlDown()) {
            n2 |= NativeKeyModifiers.CTRL_DOWN_MASK.getValue();
        }
        if (event.isAltDown()) {
            n2 |= NativeKeyModifiers.ALT_DOWN_MASK.getValue();
        }
        if (keyEvent.isMetaDown()) {
            n2 |= NativeKeyModifiers.META_DOWN_MASK.getValue();
        }
        return n2;
    }

    public static int getModifiers(ScrollEvent event) {
        ScrollEvent scrollEvent;
        int n2 = 0;
        if (event.isShiftDown()) {
            n2 = 0 | NativeKeyModifiers.SHIFT_DOWN_MASK.getValue();
        }
        if (event.isControlDown()) {
            n2 |= NativeKeyModifiers.CTRL_DOWN_MASK.getValue();
        }
        if (event.isAltDown()) {
            n2 |= NativeKeyModifiers.ALT_DOWN_MASK.getValue();
        }
        if (scrollEvent.isMetaDown()) {
            n2 |= NativeKeyModifiers.META_DOWN_MASK.getValue();
        }
        return n2;
    }

    public static int getNativeModifiers(MouseEvent event) {
        MouseEvent mouseEvent;
        int n2 = 0;
        if (event.isShiftDown()) {
            n2 = 0 | NativeKeyModifiers.SHIFT_DOWN_MASK.getValue();
        }
        if (event.isControlDown()) {
            n2 |= NativeKeyModifiers.CTRL_DOWN_MASK.getValue();
        }
        if (event.isAltDown()) {
            n2 |= NativeKeyModifiers.ALT_DOWN_MASK.getValue();
        }
        if (mouseEvent.isMetaDown()) {
            n2 |= NativeKeyModifiers.META_DOWN_MASK.getValue();
        }
        return n2;
    }

    public static Window getWindowForNode(Node node) {
        Node node2;
        if (node != null && (node2 = node2.getScene()) != null) {
            return node2.getWindow();
        }
        return null;
    }

    public static BrowserKeyEvent.KeyModifiers getBrowserKeyModifiers(KeyEvent event) {
        KeyEvent keyEvent;
        BrowserKeyEvent.KeyModifiersBuilder keyModifiersBuilder = new BrowserKeyEvent.KeyModifiersBuilder();
        if (event.isShiftDown()) {
            keyModifiersBuilder.shiftDown();
        }
        if (event.isControlDown()) {
            keyModifiersBuilder.ctrlDown();
        }
        if (event.isAltDown()) {
            keyModifiersBuilder.altDown();
        }
        if (keyEvent.isMetaDown()) {
            keyModifiersBuilder.metaDown();
        }
        return keyModifiersBuilder.build();
    }

    public static boolean scaleFactorIgnoredByJavaFX(double scaleFactor) {
        double d2;
        return Environment.isWindows() && Math.abs(1.25 - d2) <= (double)1.0E-6f;
    }

    static {
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, MouseEventType.MOUSE_CLICKED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_PRESSED, MouseEventType.MOUSE_PRESSED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_RELEASED, MouseEventType.MOUSE_RELEASED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_MOVED, MouseEventType.MOUSE_MOVED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_ENTERED, MouseEventType.MOUSE_ENTERED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_EXITED, MouseEventType.MOUSE_EXITED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_DRAGGED, MouseEventType.MOUSE_DRAGGED);
        b.put((EventType<KeyEvent>)KeyEvent.KEY_PRESSED, BrowserKeyEvent.KeyEventType.PRESSED);
        b.put((EventType<KeyEvent>)KeyEvent.KEY_RELEASED, BrowserKeyEvent.KeyEventType.RELEASED);
        b.put((EventType<KeyEvent>)KeyEvent.KEY_TYPED, BrowserKeyEvent.KeyEventType.TYPED);
    }
}

