/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

public enum CursorType {
    TypePointer,
    TypeCross,
    TypeHand,
    TypeIBeam,
    TypeWait,
    TypeHelp,
    TypeEastResize,
    TypeNorthResize,
    TypeNorthEastResize,
    TypeNorthWestResize,
    TypeSouthResize,
    TypeSouthEastResize,
    TypeSouthWestResize,
    TypeWestResize,
    TypeNorthSouthResize,
    TypeEastWestResize,
    TypeNorthEastSouthWestResize,
    TypeNorthWestSouthEastResize,
    TypeColumnResize,
    TypeRowResize,
    TypeMiddlePanning,
    TypeEastPanning,
    TypeNorthPanning,
    TypeNorthEastPanning,
    TypeNorthWestPanning,
    TypeSouthPanning,
    TypeSouthEastPanning,
    TypeSouthWestPanning,
    TypeWestPanning,
    TypeMove,
    TypeVerticalText,
    TypeCell,
    TypeContextMenu,
    TypeAlias,
    TypeProgress,
    TypeNoDrop,
    TypeCopy,
    TypeNone,
    TypeNotAllowed,
    TypeZoomIn,
    TypeZoomOut,
    TypeGrab,
    TypeGrabbing,
    TypeCustom;

    private static final Properties a;
    private static final Logger b;

    /*
     * WARNING - void declaration
     */
    public static Cursor toJavaCursor(int cursorType, byte[] pixels, int width, int height) {
        CursorType[] cursorTypeArray = CursorType.values();
        if (cursorType < cursorTypeArray.length) {
            int n2;
            CursorType cursorType2 = cursorTypeArray[n2];
            if (cursorType2 == TypeCustom) {
                WritableImage writableImage;
                void var1_4;
                int n3;
                int n4;
                if (width == 0 || height == 0) {
                    return Cursor.DEFAULT;
                }
                cursorType2 = ImageCursor.getBestSize((double)width, (double)height);
                int n5 = (int)cursorType2.getWidth();
                int n6 = (int)cursorType2.getHeight();
                if (n5 == 0 && n6 == 0) {
                    return Cursor.DEFAULT;
                }
                void v0 = n4;
                void v1 = n3;
                int n7 = n5;
                n5 = n6;
                n3 = n7;
                n4 = v1;
                int n8 = v0;
                WritableImage writableImage2 = var1_4;
                if (Environment.isWindows()) {
                    int n9 = n8 >= n3 ? n8 : n3;
                    n3 = n4 >= n5 ? n4 : n5;
                    writableImage = new WritableImage(n9, n3);
                } else {
                    writableImage = new WritableImage(n8, n4);
                }
                PixelWriter pixelWriter = writableImage.getPixelWriter();
                pixelWriter.setPixels(0, 0, n8, n4, (PixelFormat)PixelFormat.getByteBgraInstance(), (byte[])writableImage2, 0, (int)(n8 << 2));
                writableImage2 = writableImage;
                return new ImageCursor((Image)writableImage2);
            }
            if (cursorType2 == TypeNone) {
                return Cursor.NONE;
            }
            return CursorType.a(cursorType2.name());
        }
        return Cursor.DEFAULT;
    }

    private static Cursor a(String string) {
        try {
            Object object = string + ".file";
            if (Environment.isMac()) {
                object = (String)object + ".mac";
            }
            if ((object = a.getProperty((String)object)) != null) {
                object = CursorType.class.getResource((String)object);
                object = new Image(((URL)object).toString());
                Point point = new Point(0, 0);
                Object object2 = a.getProperty(string + ".hotspot");
                if (object2 != null && ((StringTokenizer)(object2 = new StringTokenizer((String)object2, ","))).countTokens() == 2) {
                    try {
                        point.x = Integer.parseInt(((StringTokenizer)object2).nextToken());
                        point.y = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        b.warning("Failed to parse hotspot property for cursor: " + string);
                    }
                }
                return new ImageCursor((Image)object, point.getX(), point.getY());
            }
            object = a.getProperty(string + ".javafx");
            if (object != null && (object = Cursor.class.getDeclaredField((String)object).get(Cursor.class)) != null) {
                return (Cursor)object;
            }
        }
        catch (Exception exception) {
            b.warning("Unable to load cursor from resources: " + string);
        }
        return Cursor.DEFAULT;
    }

    static {
        a = new Properties();
        b = LoggerProvider.getBrowserLogger();
        URL uRL = CursorType.class.getResource("/com/teamdev/jxbrowser/chromium/internal/cursors.properties");
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                a.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                b.warning("Unable to load cursors properties from:" + uRL);
            }
        }
    }
}

