/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc.message;

import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class CommonMessage
implements Message {
    protected static final String DELIMITER = ", ";
    protected static final char QUOTE = '\'';
    private static final int MSG_UID_OFFSET = 4;
    private static final int HEADER_SIZE = 12;
    private int uid = MessageUIDGenerator.generate();

    @Override
    public int getUID() {
        return this.uid;
    }

    @Override
    public int getSize() {
        return this.getHeaderSize() + this.getDataSize();
    }

    protected int getHeaderSize() {
        return 12;
    }

    protected int getDataSize() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void put(ByteBuffer buffer, byte[] bytes) {
        this.put(buffer, bytes != null ? bytes.length : 0);
        if (bytes != null) {
            void var2_2;
            void var1_1;
            var1_1.put((byte[])var2_2);
        }
    }

    protected byte[] get(ByteBuffer buffer, byte[] bytes) {
        int n2 = buffer.getInt();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = buffer.get();
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    protected void put(ByteBuffer buffer, Rectangle value) {
        void var2_2;
        void var1_1;
        this.put(buffer, value.x);
        this.put(buffer, value.y);
        this.put(buffer, value.width);
        this.put((ByteBuffer)var1_1, var2_2.height);
    }

    /*
     * WARNING - void declaration
     */
    protected Rectangle get(ByteBuffer buffer, Rectangle type) {
        void var1_1;
        Rectangle rectangle = new Rectangle();
        new Rectangle().x = this.get(buffer, rectangle.x);
        rectangle.y = this.get(buffer, rectangle.y);
        rectangle.width = this.get(buffer, rectangle.width);
        rectangle.height = this.get((ByteBuffer)var1_1, rectangle.height);
        return rectangle;
    }

    /*
     * WARNING - void declaration
     */
    protected void put(ByteBuffer buffer, byte value) {
        void var2_2;
        buffer.put((byte)var2_2);
    }

    protected byte get(ByteBuffer buffer, byte type) {
        return buffer.get();
    }

    /*
     * WARNING - void declaration
     */
    protected void put(ByteBuffer buffer, int value) {
        void var2_2;
        buffer.putInt((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void put(ByteBuffer buffer, double value) {
        void var2_2;
        buffer.putDouble((double)var2_2);
    }

    protected int get(ByteBuffer buffer, int type) {
        return buffer.getInt();
    }

    /*
     * WARNING - void declaration
     */
    protected void put(ByteBuffer buffer, String value) {
        void var1_1;
        byte[] byArray;
        if (value == null) {
            this.put(buffer, 0);
            return;
        }
        byArray = byArray.getBytes(Charset.forName("UTF-8"));
        this.put((ByteBuffer)var1_1, byArray);
    }

    protected String get(ByteBuffer buffer, String type) {
        int n2 = buffer.getInt();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = buffer.get();
        }
        return new String(byArray, Charset.forName("UTF-8"));
    }

    /*
     * WARNING - void declaration
     */
    protected void put(ByteBuffer buffer, boolean value) {
        void var2_2;
        buffer.put((byte)(var2_2 != false ? 1 : 0));
    }

    protected boolean get(ByteBuffer buffer, boolean type) {
        return buffer.get() == 1;
    }

    /*
     * WARNING - void declaration
     */
    protected void put(ByteBuffer buffer, char value) {
        void var2_2;
        buffer.putChar((char)var2_2);
    }

    protected char get(ByteBuffer buffer, char type) {
        return buffer.getChar();
    }

    protected double get(ByteBuffer buffer, double type) {
        return buffer.getDouble();
    }

    /*
     * WARNING - void declaration
     */
    protected void put(ByteBuffer buffer, long value) {
        void var2_2;
        buffer.putLong((long)var2_2);
    }

    protected long get(ByteBuffer buffer, long type) {
        return buffer.getLong();
    }

    @Override
    public void serialize(byte[] data) {
        ByteBuffer byteBuffer;
        if (data.length < this.getSize()) {
            throw new IllegalArgumentException("The data.length() must be less than this.getSize();");
        }
        byteBuffer = ByteBuffer.wrap((byte[])byteBuffer, 0, this.getHeaderSize());
        this.put(byteBuffer, this.getType().getValue());
        this.put(byteBuffer, this.getUID());
        this.put(byteBuffer, this.getDataSize());
    }

    @Override
    public void deserialize(byte[] data) {
        ByteBuffer byteBuffer;
        if (data.length < this.getSize()) {
            throw new IllegalArgumentException("The data.length() must be less than this.getSize();");
        }
        byteBuffer = ByteBuffer.wrap((byte[])byteBuffer, 0, this.getHeaderSize());
        this.uid = byteBuffer.getInt(4);
    }

    @Override
    public MessageType getType() {
        return MessageType.from(this.getClass());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append('{').append("type=").append((Object)this.getType()).append(", uid=").append(this.getUID());
        return stringBuilder.toString();
    }
}

