/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.EventQueue;
import com.teamdev.jxbrowser.chromium.internal.GuardedThread;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelException;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelStream;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.MemoryChannelReader;
import com.teamdev.jxbrowser.chromium.internal.ipc.MemoryChannelWriter;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketInfo;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelStreamListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.p;
import com.teamdev.jxbrowser.chromium.internal.ipc.s;
import com.teamdev.jxbrowser.chromium.internal.ipc.t;
import com.teamdev.jxbrowser.chromium.internal.ipc.u;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javafx.application.Platform;

public class SocketChannel
implements Channel {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private final ChannelStream b;
    private final SocketInfo c;
    private final MemoryChannelWriter d;
    private final List<Message> e;
    private final List<ChannelListener> f;
    private final EventQueue g;
    private final EventQueue h;

    /*
     * WARNING - void declaration
     */
    public SocketChannel(ChannelStream stream, SocketInfo socketInfo, MemoryChannelReader reader, MemoryChannelWriter writer) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.b = stream;
        this.c = socketInfo;
        this.d = writer;
        this.g = EventQueue.createCachedEventQueue("IPC Sync Events Thread", var2_2.getChannelType() == ChannelType.Main);
        this.h = EventQueue.createFixedEventQueue("IPC Async Events Thread");
        this.e = new ArrayList<Message>();
        this.f = new CopyOnWriteArrayList<ChannelListener>();
        var3_3.addChannelListener(new p(this));
        var1_1.addChannelStreamListener(new s(this));
    }

    @Override
    public long getChannelId() {
        return this.c.getChannelId();
    }

    @Override
    public long getBrowserId() {
        return this.c.getBrowserId();
    }

    @Override
    public boolean isClosed() {
        return this.b.isClosed();
    }

    @Override
    public ChannelType getType() {
        return this.c.getChannelType();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addChannelListener(ChannelListener listener) {
        if (!this.f.contains(listener)) {
            void var1_1;
            this.f.add((ChannelListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeChannelListener(ChannelListener listener) {
        void var1_1;
        this.f.remove(var1_1);
    }

    @Override
    public List<ChannelListener> getChannelListeners() {
        return new ArrayList<ChannelListener>(this.f);
    }

    @Override
    public void blockWriteMessages() {
        this.d.blockWriteMessages();
    }

    @Override
    public void waitForPendingPostRequests() {
        while (!this.e.isEmpty()) {
            try {
                TimeUnit.MILLISECONDS.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(Message message) {
        void var1_1;
        this.d.write((Message)var1_1);
    }

    private void a(ChannelStreamListener channelStreamListener) {
        this.b.removeChannelStreamListener(channelStreamListener);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Message> T post(T message) {
        Object object = Thread.currentThread();
        if (object instanceof GuardedThread && ((GuardedThread)object).isGuarded()) {
            throw new IllegalStateException("You are trying to execute some code that invokes synchronous message send to IPC channel. This code is executed in the scope of the handler which is bounded to synchronous message received from IPC channel. Such code execution causes a deadlock in native code with high probability and is forbidden.");
        }
        object = new CountDownLatch(1);
        AtomicReference atomicReference = new AtomicReference();
        t t2 = new t(this, message, atomicReference, (CountDownLatch)object);
        u u2 = new u(this, (CountDownLatch)object);
        this.addChannelListener(t2);
        u u3 = u2;
        SocketChannel socketChannel = this;
        socketChannel.b.addChannelStreamListener(u3);
        try {
            if (this.d.write(message)) {
                this.e.add(message);
                if (Environment.isMac() && Environment.isJavaFX() && Platform.isFxApplicationThread()) {
                    while (((CountDownLatch)object).getCount() != 0L) {
                        SharedMemoryLibrary.getInstance().runPendingTasks();
                    }
                }
                LatchUtil.await((CountDownLatch)object, new ChannelException("Failed to send message.", new TimeoutException()));
            }
            this.removeChannelListener(t2);
            this.a(u2);
            this.e.remove(message);
        }
        catch (Throwable throwable) {
            void var1_1;
            this.removeChannelListener(t2);
            this.a(u2);
            this.e.remove(var1_1);
            throw throwable;
        }
        if (atomicReference.get() == null) {
            throw new IllegalStateException("Channel stream was closed before response has been received.");
        }
        return (T)((Message)atomicReference.get());
    }

    public String toString() {
        return "SocketChannel{cid=" + this.c.getChannelId() + ", bid=" + this.c.getBrowserId() + ", type=" + (Object)((Object)this.c.getChannelType()) + '}';
    }

    static /* synthetic */ EventQueue a(SocketChannel socketChannel) {
        return socketChannel.g;
    }

    static /* synthetic */ EventQueue b(SocketChannel socketChannel) {
        return socketChannel.h;
    }

    static /* synthetic */ Logger a() {
        return a;
    }

    static abstract class a<T extends Message>
    implements ChannelListener {
        private final Message a;

        protected a(Message message) {
            this.a = message;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onMessageReceived(Message message) {
            boolean bl;
            boolean bl2 = this.a.getUID() == message.getUID();
            boolean bl3 = bl = this.a.getType() == message.getType();
            if (bl2 && bl) {
                void var1_1;
                this.a(var1_1);
            }
        }

        public abstract void a(T var1);
    }
}

