/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.MemoryChannelReader;
import com.teamdev.jxbrowser.chromium.internal.ipc.ServerException;
import com.teamdev.jxbrowser.chromium.internal.ipc.SharedMemory;
import com.teamdev.jxbrowser.chromium.internal.ipc.SharedMemoryCallback;
import com.teamdev.jxbrowser.chromium.internal.ipc.SharedMemoryNameGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.n;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class Server {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private final List<ServerListener> b = new CopyOnWriteArrayList<ServerListener>();
    private ServerSocket c;

    /*
     * WARNING - void declaration
     */
    public void addServerListener(ServerListener listener) {
        if (!this.b.contains(listener)) {
            void var1_1;
            this.b.add((ServerListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeServerListener(ServerListener listener) {
        void var1_1;
        this.b.remove(var1_1);
    }

    public List<ServerListener> getServerListeners() {
        return new ArrayList<ServerListener>(this.b);
    }

    public int getPort() {
        if (this.c != null) {
            return this.c.getLocalPort();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void start(int port) {
        if (this.isStarted()) {
            return;
        }
        try {
            this.c = new ServerSocket(port, 0, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException iOException) {
            void var1_1;
            throw new ServerException("Failed to create socket at port: " + (int)var1_1, iOException);
        }
        for (ServerListener serverListener : this.getServerListeners()) {
            serverListener.onServerStarted();
        }
        while (true) {
            SharedMemory sharedMemory;
            Object object;
            Socket socket;
            SharedMemoryCallback sharedMemoryCallback = new SharedMemoryCallback();
            try {
                socket = this.c.accept();
                object = SharedMemoryNameGenerator.generate();
                a.info("Shared Memory Name: " + (String)object);
                sharedMemory = new SharedMemory((String)object, sharedMemoryCallback);
            }
            catch (IOException iOException) {
                if (!this.c.isClosed()) {
                    throw new ServerException("Failed to accept client connection.", iOException);
                }
                for (ServerListener serverListener : this.getServerListeners()) {
                    serverListener.onServerStopped();
                }
                return;
            }
            object = new MemoryChannelReader(sharedMemoryCallback);
            ((MemoryChannelReader)object).addChannelListener(new n(this, (MemoryChannelReader)object, socket, sharedMemory));
            try {
                socket.getOutputStream().write(sharedMemory.getConnectionData());
            }
            catch (IOException iOException) {
                throw new ServerException("Failed to send connection data.", iOException);
            }
        }
    }

    public boolean isStarted() {
        return this.c != null && !this.c.isClosed();
    }

    public void stop() {
        if (this.isStarted()) {
            a.info("Stopping Server...");
            try {
                this.c.close();
            }
            catch (IOException iOException) {
                throw new ServerException("Failed to close socket connection.", iOException);
            }
            for (ServerListener serverListener : this.getServerListeners()) {
                serverListener.onServerStopped();
            }
            a.info("Stopping Server... [DONE]");
        }
    }

    static /* synthetic */ void a(Server object, Channel channel) {
        a.info("Channel has been accepted: " + channel);
        for (ServerListener serverListener : ((Server)object).getServerListeners()) {
            serverListener.onChannelConnected(channel);
        }
    }

    static /* synthetic */ void b(Server object, Channel channel) {
        a.info("Channel has been disconnected: " + channel);
        for (ServerListener serverListener : ((Server)object).getServerListeners()) {
            serverListener.onChannelDisconnected(channel);
        }
    }
}

