/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;

public enum BrowserType {
    LIGHTWEIGHT,
    HEAVYWEIGHT;


    public static BrowserType getDefault() {
        if (Environment.isMac() && Boolean.getBoolean("jxbrowser.ipc.external")) {
            return LIGHTWEIGHT;
        }
        String string = System.getProperty("jxbrowser.browser.type", "HEAVYWEIGHT");
        try {
            BrowserType browserType = BrowserType.valueOf(string);
            LoggerProvider.getBrowserLogger().info("JxBrowser type: " + string);
            return browserType;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LoggerProvider.getBrowserLogger().warning("Unsupported 'jxbrowser.browser.type' value: " + string + ". Use LIGHTWEIGHT or HEAVYWEIGHT. The default value is used - HEAVYWEIGHT.");
            return HEAVYWEIGHT;
        }
    }
}

