/*
 * Decompiled with CFR 0.152.
 */
package org.fife.plaf.OfficeXP;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.UIManager;

public class OfficeXPGraphicsUtils {
    public static void drawString(Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2, int n3) {
        int n4 = -1;
        if (n != 0) {
            char c = Character.toUpperCase((char)n);
            char c2 = Character.toLowerCase((char)n);
            int n5 = string.indexOf(c);
            int n6 = string.indexOf(c2);
            n4 = n5 == -1 ? n6 : (n6 == -1 ? n5 : (n6 < n5 ? n6 : n5));
        }
        OfficeXPGraphicsUtils.drawStringUnderlineCharAt(graphics, fontMetrics, string, n4, n2, n3);
    }

    public static void drawStringUnderlineCharAt(Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2, int n3) {
        Graphics2D graphics2D = null;
        Object object = null;
        Map map = null;
        if (graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            map = OfficeXPGraphicsUtils.getDesktopAntiAliasHints();
            if (map != null) {
                object = graphics2D.getRenderingHints();
                graphics2D.addRenderingHints(map);
            } else {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        graphics.drawString(string, n2, n3);
        if (n >= 0 && n < string.length()) {
            int n4 = n2 + fontMetrics.stringWidth(string.substring(0, n));
            int n5 = fontMetrics.charWidth(string.charAt(n));
            int n6 = n3 + fontMetrics.getDescent() - 1;
            graphics.drawLine(n4, n6, n4 + n5 - 1, n6);
        }
        if (graphics2D != null) {
            if (object instanceof RenderingHints) {
                graphics2D.setRenderingHints((RenderingHints)object);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        }
    }

    public static Map getDesktopAntiAliasHints() {
        return (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    }

    public static void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string, int n) {
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(graphics.getFont());
        int n2 = abstractButton.getDisplayedMnemonicIndex();
        Color color = abstractButton.getForeground();
        if (buttonModel.isEnabled()) {
            graphics.setColor(color);
            OfficeXPGraphicsUtils.drawStringUnderlineCharAt(graphics, fontMetrics, string, n2, rectangle.x + n, rectangle.y + fontMetrics.getAscent() + n);
        } else {
            color = UIManager.getColor("Button.disabledForeground");
            Color color2 = UIManager.getColor("Button.disabledShadow");
            if (color2 == null) {
                color2 = abstractButton.getBackground().darker();
                graphics.setColor(color2);
                OfficeXPGraphicsUtils.drawStringUnderlineCharAt(graphics, fontMetrics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
            if (color == null) {
                color = abstractButton.getBackground().brighter();
            }
            graphics.setColor(color);
            OfficeXPGraphicsUtils.drawStringUnderlineCharAt(graphics, fontMetrics, string, n2, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }
}

