/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class ToolStream {
    public static final int DEFAULT_BUFF_SIZE = 1024;

    public static byte[] getBytes(InputStream in) throws IOException {
        return ToolStream.getBytes(in, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(InputStream in, int size) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(size);
        try {
            ToolStream.pipe(in, out, size);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        ToolStream.pipe(in, out, 1024);
    }

    public static void pipe(InputStream in, OutputStream out, int size) throws IOException {
        int read;
        byte[] buff = new byte[size];
        while ((read = in.read(buff)) != -1) {
            out.write(buff, 0, read);
        }
    }

    public static String read(InputStream in) throws IOException {
        return ToolStream.read(in, Charset.defaultCharset());
    }

    public static String read(InputStream in, String charsetName) throws IOException {
        return ToolStream.read(in, Charset.forName(charsetName));
    }

    public static String read(InputStream in, Charset charset) throws IOException {
        charset = charset == null ? Charset.defaultCharset() : charset;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        StringBuilder sb = new StringBuilder();
        int ch = reader.read();
        while (ch != -1) {
            sb.append((char)ch);
            ch = reader.read();
        }
        return sb.toString();
    }

    public static void write(OutputStream out, String str) throws IOException {
        ToolStream.write(out, str, Charset.defaultCharset());
    }

    public static void write(OutputStream out, String str, String charsetName) throws IOException {
        ToolStream.write(out, str, Charset.forName(charsetName));
    }

    public static void write(OutputStream out, String str, Charset charset) throws IOException {
        charset = charset == null ? Charset.defaultCharset() : charset;
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, charset));
        writer.write(str, 0, str.length());
    }
}

