/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.tool;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.crypto.Digest;
import com.modnut.framework2.extend.IntConvert;
import com.modnut.framework2.tool.ToolArr;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;

public class ToolStr {
    public static final String REGEX_LINE = "\n|\r\n|\r";
    public static final String REGEX_SPACE = "\\s+";
    public static final String SPACE_CHARS = " \b\t\r\n";
    private static final int CHINESE_START = 19968;
    private static final int CHINESE_END = 40891;
    private static final char[] EnLowerSBC = new char[]{'\uff41', '\uff42', '\uff43', '\uff44', '\uff45', '\uff46', '\uff47', '\uff48', '\uff49', '\uff4a', '\uff4b', '\uff4c', '\uff4d', '\uff4e', '\uff4f', '\uff50', '\uff51', '\uff52', '\uff53', '\uff54', '\uff55', '\uff56', '\uff57', '\uff58', '\uff59', '\uff5a'};
    private static final char[] EnUpperSBC = new char[]{'\uff21', '\uff22', '\uff23', '\uff24', '\uff25', '\uff26', '\uff27', '\uff28', '\uff29', '\uff2a', '\uff2b', '\uff2c', '\uff2d', '\uff2e', '\uff2f', '\uff30', '\uff31', '\uff32', '\uff33', '\uff34', '\uff35', '\uff36', '\uff37', '\uff38', '\uff39', '\uff3a'};
    private static final char[] NumSBC = new char[]{'\uff10', '\uff11', '\uff12', '\uff13', '\uff14', '\uff15', '\uff16', '\uff17', '\uff18', '\uff19'};
    private static final char[] SymSBC = new char[]{'\uff0b', '\uff0d', '\uff0a', '\uff0f', '\uff08', '\uff09', '\uff0e'};
    private static final char[] SymDBC = new char[]{'+', '-', '*', '/', '(', ')', '.'};

    private static char getHexCh(int b) {
        if (b >= 10) {
            return (char)(87 + b);
        }
        return (char)(48 + b);
    }

    public static String bytes2Hex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int b = data[i];
            b = b < 0 ? b + 256 : b;
            sb.append(ToolStr.getHexCh(b / 16));
            sb.append(ToolStr.getHexCh(b % 16));
        }
        return sb.toString();
    }

    public static byte[] hex2Bytes(String hex) {
        if (hex == null) {
            return null;
        }
        hex = hex.toLowerCase();
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16);
        }
        return bytes;
    }

    public static String MD5(String str) {
        return ToolStr.MD5(str, ConstFramework.getCharset());
    }

    public static String MD5(String str, Charset charset) {
        return ToolStr.bytes2Hex(Digest.encode(str.getBytes(charset), Digest.ALGORITHM.MD5));
    }

    public static String SHA(String str) {
        return ToolStr.SHA(str, ConstFramework.getCharset());
    }

    public static String SHA(String str, Charset charset) {
        return ToolStr.bytes2Hex(Digest.encode(str.getBytes(charset), Digest.ALGORITHM.SHA));
    }

    public static String randomMD5() {
        return ToolStr.MD5(UUID.randomUUID().toString());
    }

    public static String randomSHA() {
        return ToolStr.SHA(UUID.randomUUID().toString());
    }

    public static String timeUUID() {
        return new UUID(System.currentTimeMillis(), System.nanoTime() + (long)((int)(Math.random() * 1000.0))).toString();
    }

    public static String timeUUID(long timestamp) {
        return ToolStr.timeUUID(timestamp, false);
    }

    public static String timeUUID(long timestamp, boolean random) {
        long randomNum = System.nanoTime() + (long)((int)(Math.random() * 1000.0));
        return new UUID(timestamp, random ? randomNum : 0L).toString();
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String toHtml(String str) {
        return ToolStr.toHtml(str, true, true);
    }

    public static String toHtml(String str, boolean replaceBr) {
        return ToolStr.toHtml(str, replaceBr, true);
    }

    public static String toHtml(String str, boolean replaceBr, boolean replaceSpace) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            sb.append(ToolStr.getHtmlCh(c, replaceBr, replaceSpace));
        }
        return sb.toString();
    }

    private static String getHtmlCh(char ch, boolean replaceBr, boolean replaceSpace) {
        if (ch == '&') {
            return "&amp;";
        }
        if (ch == '\"') {
            return "&quot;";
        }
        if (ch == '\'') {
            return "&apos;";
        }
        if (ch == '>') {
            return "&gt;";
        }
        if (ch == '<') {
            return "&lt;";
        }
        if (ch == ' ') {
            return replaceSpace ? "&nbsp;" : Character.toString(ch);
        }
        if (ch == '\n') {
            return replaceBr ? "<br/>" : Character.toString(ch);
        }
        return Character.toString(ch);
    }

    public static String highlightHtml(String str, String hlStr, String className) {
        return ToolStr.highlightHtml(str, hlStr, className, "span", true);
    }

    public static String highlightHtml(String str, String hlStr, String className, String tagName) {
        return ToolStr.highlightHtml(str, hlStr, className, tagName, true);
    }

    public static String highlightHtml(String str, String hlStr, String className, String tagName, boolean ignoreCase) {
        if (str == null) {
            return "";
        }
        if (hlStr == null || hlStr.equals("")) {
            return str;
        }
        char[] src = str.toCharArray();
        char[] hl = hlStr.toCharArray();
        int index = 0;
        int inTag = 0;
        StringBuilder sb = new StringBuilder();
        while (index < src.length) {
            if (src[index] == '<') {
                ++inTag;
            }
            if (ToolStr.chEqual(src[index], hl[0], ignoreCase)) {
                int i;
                boolean match = true;
                for (i = 1; index + i < src.length && i < hl.length && (match = ToolStr.chEqual(src[index + i], hl[i], ignoreCase)); ++i) {
                }
                if (i == hl.length && match && inTag == 0) {
                    sb.append("<").append(tagName).append(" class=\"").append(className).append("\">");
                    for (i = 0; i < hl.length; ++i) {
                        sb.append(src[index + i]);
                    }
                    sb.append("</").append(tagName).append(">");
                    index += hl.length;
                    continue;
                }
            }
            sb.append(src[index]);
            if (src[index] == '>') {
                --inTag;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String highlightText(String str, String hlStr, String className) {
        return ToolStr.highlightText(str, hlStr, className, "span", true);
    }

    public static String highlightText(String str, String hlStr, String className, String tagName) {
        return ToolStr.highlightText(str, hlStr, className, tagName, true);
    }

    public static String highlightText(String str, String hlStr, String className, String tagName, boolean ignoreCase) {
        if (str == null) {
            return "";
        }
        if (hlStr == null || hlStr.equals("")) {
            return ToolStr.toHtml(str);
        }
        char[] src = str.toCharArray();
        char[] hl = hlStr.toCharArray();
        int index = 0;
        boolean lastIsSpace = false;
        StringBuilder sb = new StringBuilder();
        while (index < src.length) {
            if (ToolStr.chEqual(src[index], hl[0], ignoreCase)) {
                int i;
                StringBuilder matchStrSb = new StringBuilder();
                matchStrSb.append(src[index]);
                boolean match = true;
                for (i = 1; index + i < src.length && i < hl.length && (match = ToolStr.chEqual(src[index + i], hl[i], ignoreCase)); ++i) {
                    matchStrSb.append(src[index + i]);
                }
                if (i == hl.length && match) {
                    sb.append("<").append(tagName).append(" class=\"").append(className).append("\">").append(ToolStr.toHtml(matchStrSb.toString())).append("</").append(tagName).append(">");
                    index += hl.length;
                    continue;
                }
            }
            char c = src[index];
            sb.append(ToolStr.getHtmlCh(c, true, lastIsSpace));
            lastIsSpace = c == ' ';
            ++index;
        }
        return sb.toString();
    }

    public static boolean chEqual(char ch1, char ch2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toLowerCase(ch1) == Character.toLowerCase(ch2);
        }
        return ch1 == ch2;
    }

    public static boolean isInteger(String numStr) {
        for (int i = 0; i < numStr.length(); ++i) {
            char ch = numStr.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumAndLetter(String nlStr) {
        return ToolStr.isNumAndLetter(nlStr, null);
    }

    public static boolean isNumAndLetter(String nlStr, char[] more) {
        for (int i = 0; i < nlStr.length(); ++i) {
            char ch = nlStr.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') continue;
            if (more != null) {
                boolean allowed = false;
                for (int j = 0; j < more.length; ++j) {
                    if (ch != more[j]) continue;
                    allowed = true;
                    break;
                }
                if (allowed) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isNum(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    public static boolean isChinese(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fbb';
    }

    public static int compareHex(String hex1, String hex2) {
        hex1 = ToolStr.fixHex(hex1);
        hex2 = ToolStr.fixHex(hex2);
        if (hex1.length() != hex2.length()) {
            return hex1.length() > hex2.length() ? 1 : -1;
        }
        for (int i = 0; i < hex1.length(); ++i) {
            if (hex1.charAt(i) == hex2.charAt(i)) continue;
            return hex1.charAt(i) > hex2.charAt(i) ? 1 : -1;
        }
        return 0;
    }

    private static String fixHex(String hex) {
        char[] chArr = (hex == null ? "" : hex).toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chArr.length; ++i) {
            char ch = chArr[i];
            if (ch >= '0' && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                sb.append(ch);
                continue;
            }
            if (ch < 'A' || ch > 'Z') continue;
            ch = (char)(ch - 65 + 97);
            sb.append(ch);
        }
        return sb.toString();
    }

    public static boolean equals(String strA, String strB) {
        return ToolStr.equals(strA, strB, true);
    }

    public static boolean equals(String strA, String strB, boolean sensitive) {
        if (strA == null && strB == null) {
            return true;
        }
        if (strA == null || strB == null) {
            return false;
        }
        if (sensitive) {
            return strA.equals(strB);
        }
        return strA.toLowerCase().equals(strB.toLowerCase());
    }

    public static Boolean parseBoolean(String numStr) {
        Boolean num;
        if (numStr == null) {
            return null;
        }
        try {
            num = Boolean.parseBoolean(numStr);
        }
        catch (Exception ex) {
            num = null;
        }
        return num;
    }

    public static boolean parseBoolean(String numStr, boolean defaultVal) {
        if (numStr == null) {
            return defaultVal;
        }
        boolean num = defaultVal;
        try {
            num = Boolean.parseBoolean(numStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public static Short parseShort(String numStr) {
        Short num;
        if (numStr == null) {
            return null;
        }
        try {
            num = Short.parseShort(numStr);
        }
        catch (Exception ex) {
            num = null;
        }
        return num;
    }

    public static short parseShort(String numStr, short defaultVal) {
        if (numStr == null) {
            return defaultVal;
        }
        short num = defaultVal;
        try {
            num = Short.parseShort(numStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public static Integer parseInt(String numStr) {
        Integer num;
        if (numStr == null) {
            return null;
        }
        try {
            num = Integer.parseInt(numStr);
        }
        catch (Exception ex) {
            num = null;
        }
        return num;
    }

    public static int parseInt(String numStr, int defaultVal) {
        if (numStr == null) {
            return defaultVal;
        }
        int num = defaultVal;
        try {
            num = Integer.parseInt(numStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public static Long parseLong(String numStr) {
        Long num;
        if (numStr == null) {
            return null;
        }
        try {
            num = Long.parseLong(numStr);
        }
        catch (Exception ex) {
            num = null;
        }
        return num;
    }

    public static long parseLong(String numStr, long defaultVal) {
        if (numStr == null) {
            return defaultVal;
        }
        long num = defaultVal;
        try {
            num = Long.parseLong(numStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public static Float parseFloat(String numStr) {
        Float num;
        if (numStr == null) {
            return null;
        }
        try {
            num = Float.valueOf(Float.parseFloat(numStr));
        }
        catch (Exception ex) {
            num = null;
        }
        return num;
    }

    public static float parseFloat(String numStr, float defaultVal) {
        if (numStr == null) {
            return defaultVal;
        }
        float num = defaultVal;
        try {
            num = Float.parseFloat(numStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public static Double parseDouble(String numStr) {
        Double num;
        if (numStr == null) {
            return null;
        }
        try {
            num = Double.parseDouble(numStr);
        }
        catch (Exception ex) {
            num = null;
        }
        return num;
    }

    public static double parseDouble(String numStr, double defaultVal) {
        if (numStr == null) {
            return defaultVal;
        }
        double num = defaultVal;
        try {
            num = Double.parseDouble(numStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public static boolean[] parseBoolean(String arrStr, String splitReg, boolean defaultVal) {
        return ToolStr.parseBoolean(arrStr, splitReg, defaultVal, false);
    }

    public static boolean[] parseBoolean(String arrStr, String splitReg, boolean defaultVal, boolean rtnNull) {
        if ((arrStr = ToolStr.emptyToNull(arrStr, true)) != null) {
            String[] strs = arrStr.split(splitReg);
            boolean[] arr = new boolean[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = ToolStr.parseBoolean(strs[i], defaultVal);
            }
            return arr;
        }
        return rtnNull ? null : new boolean[]{};
    }

    public static short[] parseShort(String arrStr, String splitReg, short defaultVal) {
        return ToolStr.parseShort(arrStr, splitReg, defaultVal, false);
    }

    public static short[] parseShort(String arrStr, String splitReg, short defaultVal, boolean rtnNull) {
        if ((arrStr = ToolStr.emptyToNull(arrStr, true)) != null) {
            String[] strs = arrStr.split(splitReg);
            short[] arr = new short[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = ToolStr.parseShort(strs[i], defaultVal);
            }
            return arr;
        }
        return rtnNull ? null : new short[]{};
    }

    public static int[] parseInt(String arrStr, String splitReg, int defaultVal) {
        return ToolStr.parseInt(arrStr, splitReg, defaultVal, false);
    }

    public static int[] parseInt(String arrStr, String splitReg, int defaultVal, boolean rtnNull) {
        if ((arrStr = ToolStr.emptyToNull(arrStr, true)) != null) {
            String[] strs = arrStr.split(splitReg);
            int[] arr = new int[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = ToolStr.parseInt(strs[i], defaultVal);
            }
            return arr;
        }
        return rtnNull ? null : new int[]{};
    }

    public static long[] parseLong(String arrStr, String splitReg, long defaultVal) {
        return ToolStr.parseLong(arrStr, splitReg, defaultVal, false);
    }

    public static long[] parseLong(String arrStr, String splitReg, long defaultVal, boolean rtnNull) {
        if ((arrStr = ToolStr.emptyToNull(arrStr, true)) != null) {
            String[] strs = arrStr.split(splitReg);
            long[] arr = new long[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = ToolStr.parseLong(strs[i], defaultVal);
            }
            return arr;
        }
        return rtnNull ? null : new long[]{};
    }

    public static float[] parseFloat(String arrStr, String splitReg, float defaultVal) {
        return ToolStr.parseFloat(arrStr, splitReg, defaultVal, false);
    }

    public static float[] parseFloat(String arrStr, String splitReg, float defaultVal, boolean rtnNull) {
        if ((arrStr = ToolStr.emptyToNull(arrStr, true)) != null) {
            String[] strs = arrStr.split(splitReg);
            float[] arr = new float[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = ToolStr.parseFloat(strs[i], defaultVal);
            }
            return arr;
        }
        return rtnNull ? null : new float[]{};
    }

    public static double[] parseDouble(String arrStr, String splitReg, double defaultVal) {
        return ToolStr.parseDouble(arrStr, splitReg, defaultVal, false);
    }

    public static double[] parseDouble(String arrStr, String splitReg, double defaultVal, boolean rtnNull) {
        if ((arrStr = ToolStr.emptyToNull(arrStr, true)) != null) {
            String[] strs = arrStr.split(splitReg);
            double[] arr = new double[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                arr[i] = ToolStr.parseDouble(strs[i], defaultVal);
            }
            return arr;
        }
        return rtnNull ? null : new double[]{};
    }

    public static String[] parseString(String arrStr, String splitReg) {
        return ToolStr.parseString(arrStr, splitReg, false);
    }

    public static String[] parseString(String arrStr, String splitReg, boolean rtnNull) {
        if ((arrStr = ToolStr.emptyToNull(arrStr, true)) != null) {
            return arrStr.split(splitReg);
        }
        return rtnNull ? null : new String[]{};
    }

    public static boolean parse(String numStr, boolean defaultVal) {
        return ToolStr.parseBoolean(numStr, defaultVal);
    }

    public static short parse(String numStr, short defaultVal) {
        return ToolStr.parseShort(numStr, defaultVal);
    }

    public static int parse(String numStr, int defaultVal) {
        return ToolStr.parseInt(numStr, defaultVal);
    }

    public static long parse(String numStr, long defaultVal) {
        return ToolStr.parseLong(numStr, defaultVal);
    }

    public static float parse(String numStr, float defaultVal) {
        return ToolStr.parseFloat(numStr, defaultVal);
    }

    public static double parse(String numStr, double defaultVal) {
        return ToolStr.parseDouble(numStr, defaultVal);
    }

    public static boolean[] parse(String arrStr, String splitReg, boolean defaultVal) {
        return ToolStr.parseBoolean(arrStr, splitReg, defaultVal);
    }

    public static short[] parse(String arrStr, String splitReg, short defaultVal) {
        return ToolStr.parseShort(arrStr, splitReg, defaultVal);
    }

    public static int[] parse(String arrStr, String splitReg, int defaultVal) {
        return ToolStr.parseInt(arrStr, splitReg, defaultVal);
    }

    public static long[] parse(String arrStr, String splitReg, long defaultVal) {
        return ToolStr.parseLong(arrStr, splitReg, defaultVal);
    }

    public static float[] parse(String arrStr, String splitReg, float defaultVal) {
        return ToolStr.parseFloat(arrStr, splitReg, defaultVal);
    }

    public static double[] parse(String arrStr, String splitReg, double defaultVal) {
        return ToolStr.parseDouble(arrStr, splitReg, defaultVal);
    }

    public static String[] parse(String arrStr, String splitReg) {
        return ToolStr.parseString(arrStr, splitReg);
    }

    public static String cutString(String str, int beginIndex, int length) {
        if (str == null) {
            return null;
        }
        int maxIndex = str.length() - 1;
        int endIndex = beginIndex + length;
        if (beginIndex > maxIndex) {
            return "";
        }
        if (endIndex <= maxIndex) {
            return str.substring(beginIndex, endIndex);
        }
        return str.substring(beginIndex);
    }

    public static String nullToDefault(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String nullToEmpty(String str) {
        return str == null ? "" : str;
    }

    public static String emptyToNull(String str) {
        return ToolStr.emptyToNull(str, false);
    }

    public static String emptyToNull(String str, boolean trim) {
        str = str != null && trim ? str.trim() : str;
        return "".equals(str) ? null : str;
    }

    public static String formatDouble(double value) {
        return ToolStr.formatDouble(value, 2, false);
    }

    public static String formatDouble(double value, int cnt) {
        return ToolStr.formatDouble(value, cnt, false);
    }

    public static String formatDouble(double value, int cnt, boolean keep) {
        long longVal = Double.valueOf(value).longValue();
        if ((double)longVal == value && !keep) {
            return Long.toString(longVal);
        }
        return String.format("%." + Math.abs(cnt) + "f", value);
    }

    public static String cutBetween(String source, String prefix, String suffix, String failed) {
        if (source == null) {
            return failed;
        }
        String rtn = source;
        int start = rtn.indexOf(prefix);
        if (start < 0) {
            return failed;
        }
        int end = (rtn = rtn.substring(start + prefix.length())).indexOf(suffix);
        if (end < 0) {
            return failed;
        }
        rtn = rtn.substring(0, end);
        return rtn;
    }

    public static String cutPrefix(String source, String prefix) {
        return ToolStr.cutPrefix(source, prefix, source);
    }

    public static String cutPrefix(String source, String prefix, String failed) {
        if (source != null && source.startsWith(prefix)) {
            return source.substring(prefix.length());
        }
        return failed;
    }

    public static boolean match(String str, String[] strs) {
        if (str == null || strs == null) {
            return false;
        }
        for (int i = 0; i < strs.length; ++i) {
            if (!str.equals(strs[i])) continue;
            return true;
        }
        return false;
    }

    public static String cutSuffix(String source, String suffix) {
        return ToolStr.cutSuffix(source, suffix, source);
    }

    public static String cutSuffix(String source, String suffix, String failed) {
        if (source != null && source.endsWith(suffix)) {
            return source.substring(0, source.length() - suffix.length());
        }
        return failed;
    }

    public static String URLDecode(String str) {
        return ToolStr.URLDecode(str, ConstFramework.getCharset());
    }

    public static String URLDecode(String str, String charsetName) {
        return ToolStr.URLDecode(str, Charset.forName(charsetName));
    }

    public static String URLDecode(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        try {
            return URLDecoder.decode(str, charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public static String URLEncode(String str) {
        return ToolStr.URLEncode(str, ConstFramework.getCharset());
    }

    public static String URLEncode(String str, String charsetName) {
        return ToolStr.URLEncode(str, Charset.forName(charsetName));
    }

    public static String URLEncode(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, charset.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public static String toUnicode(String str) {
        char[] chArr = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        String ZERO = "0000";
        for (char c : chArr) {
            if (c >= '\u0000' && c <= '\u007f') {
                sb.append(c);
                continue;
            }
            String val = Integer.toHexString(c);
            sb.append("\\u").append("0000".substring(val.length())).append(val);
        }
        return sb.toString();
    }

    public static String fromUnicode(String str) {
        char[] chArr = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chArr.length; ++i) {
            if (i <= chArr.length - 6 && chArr[i] == '\\' && (chArr[i + 1] == 'u' || chArr[i + 1] == 'U')) {
                int val = 0;
                for (int j = 2; j < 6; ++j) {
                    val *= 16;
                    char ch = chArr[i + j];
                    if (ch >= 'a' && ch <= 'f') {
                        val += ch - 97 + 10;
                        continue;
                    }
                    if (ch >= 'A' && ch <= 'F') {
                        val += ch - 65 + 10;
                        continue;
                    }
                    if (ch < '0' || ch > '9') continue;
                    val += ch - 48;
                }
                sb.append((char)val);
                i += 5;
                continue;
            }
            sb.append(chArr[i]);
        }
        return sb.toString();
    }

    public static String randMess(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        Random rand = new Random(System.currentTimeMillis());
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = 0; i < str.length(); ++i) {
            int index = rand.nextInt(list.size() + 1);
            list.add(index, Character.valueOf(str.charAt(i)));
        }
        StringBuilder sb = new StringBuilder();
        for (Character ch : list) {
            sb.append(ch.charValue());
        }
        return sb.toString();
    }

    public static String intMess1(String str, int param) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        return ToolStr.sortStr(str, ToolStr.genSortA(str.length(), param));
    }

    public static String intMess2(String str, int param) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        return ToolStr.sortStr(str, ToolStr.genSortB(str.length(), param));
    }

    private static String sortStr(String str, int[] sort) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        if (str.length() != sort.length) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = sort.length - 1; i >= 0; --i) {
            sb.append(str.charAt(sort[i]));
        }
        return sb.toString();
    }

    private static int[] genSortA(int length, int param) {
        int[] sortA = new int[length];
        int i = 0;
        while (i < length) {
            int index = Math.abs(IntConvert.convert1(param + i)) % (i + 1);
            System.arraycopy(sortA, index, sortA, index + 1, i - index);
            sortA[index] = i++;
        }
        return sortA;
    }

    private static int[] genSortB(int length, int param) {
        int[] sortA = ToolStr.genSortA(length, param);
        int[] sortB = new int[sortA.length];
        for (int i = sortA.length - 1; i >= 0; --i) {
            int index = -1;
            for (int j = 0; j < sortA.length; ++j) {
                if (sortA[j] != i) continue;
                index = j;
                break;
            }
            sortB[sortA.length - 1 - i] = sortA.length - 1 - index;
        }
        return sortB;
    }

    public static String SBC2DBC(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= EnLowerSBC[0] && ch <= EnLowerSBC[EnLowerSBC.length - 1]) {
                ch = (char)(ch - EnLowerSBC[0] + 97);
            } else if (ch >= EnUpperSBC[0] && ch <= EnUpperSBC[EnUpperSBC.length - 1]) {
                ch = (char)(ch - EnUpperSBC[0] + 65);
            } else if (ch >= NumSBC[0] && ch <= NumSBC[NumSBC.length - 1]) {
                ch = (char)(ch - NumSBC[0] + 48);
            } else {
                for (int j = 0; j < SymSBC.length && j < SymDBC.length; ++j) {
                    if (ch != SymSBC[j]) continue;
                    ch = SymDBC[j];
                    break;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String join(String strA, String strB) {
        return ToolStr.join(strA, strB, null);
    }

    public static String join(String strA, String strB, String joinStr) {
        if (strB != null) {
            return strA + (joinStr == null ? "" : joinStr) + strB;
        }
        return strA;
    }

    public static String joinArr(String[] arr) {
        return ToolStr.joinArr(arr, null, null, null);
    }

    public static String joinArr(String[] arr, String joinStr) {
        return ToolStr.joinArr(arr, joinStr, null, null);
    }

    public static String joinArr(String[] arr, String joinStr, String prefixStr, String suffixStr) {
        if (arr == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        for (String str : arr) {
            if (str == null) continue;
            if (started && joinStr != null) {
                sb.append(joinStr);
            }
            if (prefixStr != null) {
                sb.append(prefixStr);
            }
            sb.append(str);
            if (suffixStr != null) {
                sb.append(suffixStr);
            }
            started = true;
        }
        return sb.toString();
    }

    public static String joinList(ArrayList<String> list) {
        return ToolStr.joinList(list, null, null, null);
    }

    public static String joinList(ArrayList<String> list, String joinStr) {
        return ToolStr.joinList(list, joinStr, null, null);
    }

    public static String joinList(ArrayList<String> list, String joinStr, String prefixStr, String suffixStr) {
        if (list == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        for (String str : list) {
            if (str == null) continue;
            if (started && joinStr != null) {
                sb.append(joinStr);
            }
            if (prefixStr != null) {
                sb.append(prefixStr);
            }
            sb.append(str);
            if (suffixStr != null) {
                sb.append(suffixStr);
            }
            started = true;
        }
        return sb.toString();
    }

    public static ArrayList<String> csvValList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while (index < str.length()) {
            String value;
            int end;
            char ch = str.charAt(index);
            if (ch == ',') {
                list.add("");
                ++index;
                continue;
            }
            if (ch == '\"') {
                end = str.indexOf("\",", index + 1);
                while (end >= 0 && str.charAt(end - 1) == '\"') {
                    end = str.indexOf("\",", end + 2);
                }
                if (end >= 0) {
                    value = str.substring(index + 1, end);
                    index = end + 2;
                } else if (str.endsWith("\"")) {
                    value = str.substring(index + 1, str.length() - 1);
                    index = str.length();
                } else {
                    value = str.substring(index + 1);
                    index = str.length();
                }
                list.add(value.replace("\"\"", "\""));
                continue;
            }
            end = str.indexOf(44, index + 1);
            if (end >= 0) {
                value = str.substring(index, end);
                index = end + 1;
            } else {
                value = str.substring(index);
                index = str.length();
            }
            list.add(value);
        }
        return list;
    }

    public static String[] csvValArr(String str) {
        ArrayList<String> list = ToolStr.csvValList(str);
        return list.toArray(new String[list.size()]);
    }

    public static String csvValStr(ArrayList<String> vals) {
        if (vals != null && !vals.isEmpty()) {
            return ToolStr.csvValStr(vals.toArray(new String[vals.size()]));
        }
        return null;
    }

    public static String csvValStr(String ... vals) {
        if (vals == null || vals.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String val : vals) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("\"").append(val.replace("\"", "\"\"")).append("\"");
        }
        return sb.toString();
    }

    public static String getHost(String url) {
        String prefix;
        int index1;
        if (url != null && (index1 = url.indexOf(prefix = "://")) >= 0) {
            String part = url.substring(index1 + prefix.length());
            int index2 = part.indexOf(47);
            if (index2 >= 0) {
                part = part.substring(0, index2);
            }
            return part;
        }
        return null;
    }

    public static String getUrl(String url, boolean keep, String ... params) {
        if (url != null) {
            int index;
            if (url.startsWith("//")) {
                url = "http:" + url;
            }
            if ((index = url.lastIndexOf(63)) >= 0) {
                String part1 = url.substring(0, index);
                String part2 = url.substring(index + 1);
                StringBuilder paramSb = new StringBuilder();
                for (String str : part2.split("&")) {
                    int index2 = str.indexOf("=");
                    String paramName = str;
                    String paramValue = null;
                    if (index2 >= 0) {
                        paramName = str.substring(0, index2);
                        paramValue = str.substring(index2 + 1);
                    }
                    boolean contain = ToolArr.contain(params, paramName);
                    if (!(keep ? contain : !contain)) continue;
                    paramSb.append(paramSb.length() > 0 ? "&" : "?");
                    paramSb.append(paramName);
                    if (paramValue == null) continue;
                    paramSb.append("=").append(paramValue);
                }
                return part1 + paramSb.toString();
            }
            return url;
        }
        return null;
    }

    public static String getExtFromUrl(String url) {
        if (url != null) {
            int index = url.indexOf(63);
            if (index >= 0) {
                url = url.substring(0, index);
            }
            if ((index = url.lastIndexOf(47)) >= 0) {
                url = url.substring(index + 1);
            }
            if ((index = url.lastIndexOf(46)) >= 0) {
                return url.substring(index + 1);
            }
        }
        return null;
    }

    public static boolean matchKeyword(String keyword, String pattern) {
        String[] strs;
        if (pattern == null) {
            return true;
        }
        if (keyword == null || keyword.trim().isEmpty()) {
            return false;
        }
        for (String str : strs = pattern.replace('\uff0c', ',').split(",")) {
            String[] parts = str.split(REGEX_SPACE);
            boolean matched = true;
            for (String part : parts) {
                if (keyword.toLowerCase().indexOf(part.toLowerCase()) >= 0) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public static int matchDomain(String host, String[] domains) {
        if (host == null || host.trim().isEmpty() || domains == null) {
            return -1;
        }
        String[] parts1 = host.toLowerCase().split("\\.");
        for (int i = 0; i < domains.length; ++i) {
            if (domains[i] == null) continue;
            String[] parts2 = domains[i].trim().toLowerCase().split("\\.");
            boolean matched = true;
            if (parts1.length == parts2.length) {
                for (int j = 0; j < parts1.length; ++j) {
                    if (parts2[j].equals("*") || parts2[j].equals(parts1[j])) continue;
                    matched = false;
                    break;
                }
            } else {
                matched = false;
            }
            if (!matched) continue;
            return i;
        }
        return -1;
    }

    public static int getIntFromStr(String str) {
        return ToolStr.parseInt(ToolStr.getNumFromStr(str, false, false), 0);
    }

    public static int getIntFromStr(String str, boolean allowBreak) {
        return ToolStr.parseInt(ToolStr.getNumFromStr(str, allowBreak, false), 0);
    }

    public static long getLongFromStr(String str) {
        return ToolStr.parseLong(ToolStr.getNumFromStr(str, false, false), 0L);
    }

    public static long getLongFromStr(String str, boolean allowBreak) {
        return ToolStr.parseLong(ToolStr.getNumFromStr(str, allowBreak, false), 0L);
    }

    public static float getFloatFromStr(String str) {
        return ToolStr.parseFloat(ToolStr.getNumFromStr(str, false, true), 0.0f);
    }

    public static float getFloatFromStr(String str, boolean allowBreak) {
        return ToolStr.parseFloat(ToolStr.getNumFromStr(str, allowBreak, true), 0.0f);
    }

    public static double getDoubleFromStr(String str) {
        return ToolStr.parseDouble(ToolStr.getNumFromStr(str, false, true), 0.0);
    }

    public static double getDoubleFromStr(String str, boolean allowBreak) {
        return ToolStr.parseDouble(ToolStr.getNumFromStr(str, allowBreak, true), 0.0);
    }

    public static String getNumFromStr(String str, boolean allowBreak, boolean hasDot) {
        StringBuilder sb = new StringBuilder();
        if (str != null) {
            boolean find = false;
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    sb.append(ch);
                    find = true;
                    continue;
                }
                if (ch == '.' && hasDot) {
                    sb.append(ch);
                    continue;
                }
                if (find && !allowBreak) break;
            }
        }
        return sb.toString();
    }
}

