/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.tool;

import com.modnut.framework2.constant.ConstFramework;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ToolHttp {
    private static final int BUFF_SIZE = 4096;
    public static final int NONE_TIMEOUT = 0;
    public static final int DEFAULT_TIMEOUT = 0;

    public static HttpResponse get(String urlStr, HashMap<String, String> paramMap) {
        return ToolHttp.get(urlStr, paramMap, ConstFramework.getCharset(), 0);
    }

    public static HttpResponse get(String urlStr, HashMap<String, String> paramMap, Charset charset) {
        return ToolHttp.get(urlStr, paramMap, charset, 0);
    }

    public static HttpResponse get(String urlStr, HashMap<String, String> paramMap, int timeout) {
        return ToolHttp.get(urlStr, paramMap, ConstFramework.getCharset(), timeout);
    }

    public static HttpResponse get(String urlStr, HashMap<String, String> paramMap, Charset charset, int timeout) {
        try {
            String data;
            if (charset == null) {
                charset = ConstFramework.getCharset();
            }
            if (timeout <= 0) {
                timeout = 0;
            }
            URL url = "".equals(data = ToolHttp.buildParamData(paramMap, charset)) ? new URL(urlStr) : (urlStr.indexOf("?") >= 0 ? new URL(urlStr + "&" + data) : new URL(urlStr + "?" + data));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(false);
            conn.setUseCaches(false);
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(timeout * 1000);
            conn.setReadTimeout(timeout * 100);
            conn.setRequestProperty("Charset", charset.name());
            conn.setRequestProperty("Connection", "Keep-Alive");
            HttpResponse response = ToolHttp.getResponse(conn, charset);
            conn.disconnect();
            return response;
        }
        catch (Exception ex) {
            return new HttpResponse(ex);
        }
    }

    public static HttpResponse post(String urlStr, HashMap<String, String> paramMap) {
        return ToolHttp.post(urlStr, paramMap, ConstFramework.getCharset(), 0);
    }

    public static HttpResponse post(String urlStr, HashMap<String, String> paramMap, Charset charset) {
        return ToolHttp.post(urlStr, paramMap, charset, 0);
    }

    public static HttpResponse post(String urlStr, HashMap<String, String> paramMap, int timeout) {
        return ToolHttp.post(urlStr, paramMap, ConstFramework.getCharset(), timeout);
    }

    public static HttpResponse post(String urlStr, HashMap<String, String> paramMap, Charset charset, int timeout) {
        String data = ToolHttp.buildParamData(paramMap, charset);
        return ToolHttp.write(urlStr, data, charset, timeout);
    }

    public static HttpResponse write(String urlStr, String data) {
        return ToolHttp.write(urlStr, data, ConstFramework.getCharset(), 0);
    }

    public static HttpResponse write(String urlStr, String data, Charset charset) {
        return ToolHttp.write(urlStr, data, charset, 0);
    }

    public static HttpResponse write(String urlStr, String data, int timeout) {
        return ToolHttp.write(urlStr, data, ConstFramework.getCharset(), timeout);
    }

    public static HttpResponse write(String urlStr, String data, Charset charset, int timeout) {
        try {
            if (charset == null) {
                charset = ConstFramework.getCharset();
            }
            if (timeout <= 0) {
                timeout = 0;
            }
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(timeout * 1000);
            conn.setReadTimeout(timeout * 1000);
            byte[] requestData = data.getBytes(charset);
            conn.setRequestProperty("Charset", charset.name());
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Content-Length", Integer.toString(requestData.length));
            OutputStream os = conn.getOutputStream();
            os.write(requestData);
            os.close();
            HttpResponse response = ToolHttp.getResponse(conn, charset);
            conn.disconnect();
            return response;
        }
        catch (Exception ex) {
            return new HttpResponse(ex);
        }
    }

    public static HttpRequest send(HttpListener listener, String urlStr, HashMap<String, String> paramMap, METHOD method) {
        return ToolHttp.send(listener, urlStr, paramMap, method, ConstFramework.getCharset(), 0);
    }

    public static HttpRequest send(HttpListener listener, String urlStr, HashMap<String, String> paramMap, METHOD method, Charset charset) {
        return ToolHttp.send(listener, urlStr, paramMap, method, charset, 0);
    }

    public static HttpRequest send(HttpListener listener, String urlStr, HashMap<String, String> paramMap, METHOD method, int timeout) {
        return ToolHttp.send(listener, urlStr, paramMap, method, ConstFramework.getCharset(), timeout);
    }

    public static HttpRequest send(HttpListener listener, String urlStr, HashMap<String, String> paramMap, METHOD method, Charset charset, int timeout) {
        HttpRequest request = HttpRequest.createRequest(listener, urlStr, paramMap);
        request.setMethod(method).setCharset(charset).setTimeout(timeout).send();
        return request;
    }

    private static String buildParamData(HashMap<String, String> paramMap, Charset charset) {
        StringBuilder dataBuilder = new StringBuilder();
        if (paramMap != null) {
            int paramCnt = 0;
            for (String key : paramMap.keySet()) {
                if (paramCnt > 0) {
                    dataBuilder.append("&");
                }
                String value = paramMap.get(key);
                dataBuilder.append(ToolHttp.URLEncode(key, charset)).append("=").append(ToolHttp.URLEncode(value, charset));
                ++paramCnt;
            }
        }
        return dataBuilder.toString();
    }

    private static String URLEncode(String str, Charset charset) {
        try {
            return str == null ? "" : URLEncoder.encode(str, charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    private static HttpResponse getResponse(HttpURLConnection conn, Charset useCharset) {
        try {
            if (useCharset == null) {
                useCharset = ConstFramework.getCharset();
            }
            int rtnCode = conn.getResponseCode();
            Map<String, List<String>> headerFields = conn.getHeaderFields();
            if (rtnCode == 200) {
                int length;
                String contentType = conn.getHeaderField("Content-Type");
                String charset = ToolHttp.getCharsetByContentType(contentType);
                BufferedReader in = charset != null ? new BufferedReader(new InputStreamReader(conn.getInputStream(), charset)) : new BufferedReader(new InputStreamReader(conn.getInputStream(), useCharset));
                char[] buff = new char[4096];
                StringBuilder responseSb = new StringBuilder();
                while ((length = in.read(buff)) != -1) {
                    responseSb.append(new String(buff, 0, length));
                }
                in.close();
                return new HttpResponse(rtnCode, headerFields, responseSb.toString());
            }
            return new HttpResponse(rtnCode, headerFields, null);
        }
        catch (Exception ex) {
            return new HttpResponse(ex);
        }
    }

    private static String getCharsetByContentType(String contentType) {
        String rtn = null;
        if (contentType != null) {
            String[] fields;
            for (String field : fields = contentType.split(";")) {
                String[] pair = field.trim().split("=");
                if (pair.length < 2 || !"charset".equals(pair[0].trim().toLowerCase())) continue;
                rtn = pair[1].trim();
                break;
            }
        }
        return rtn;
    }

    public static class HttpResponse {
        public static final int CODE_EXPCETION = -1;
        public static final int CODE_OK = 200;
        public int code;
        public Map<String, List<String>> headerFields;
        public String text;
        public Exception ex;

        public HttpResponse(int code, Map<String, List<String>> headerFields, String text) {
            this.code = code;
            this.headerFields = headerFields;
            this.text = text;
            this.ex = null;
        }

        public HttpResponse(Exception ex) {
            this.code = -1;
            this.text = null;
            this.ex = ex;
        }
    }

    public static class HttpRequest
    extends Thread {
        private static long cntID = 0L;
        private long id;
        private HttpListener listener;
        private METHOD method = METHOD.GET;
        private Charset charset = ConstFramework.getCharset();
        private int timeout = 0;
        private String urlStr;
        private HashMap<String, String> paramMap;

        public static HttpRequest createRequest(String urlStr, HashMap<String, String> paramMap) {
            return HttpRequest.createRequest(null, urlStr, paramMap);
        }

        public static HttpRequest createRequest(HttpListener listener, String urlStr, HashMap<String, String> paramMap) {
            HttpRequest request = new HttpRequest();
            request.listener = listener;
            request.urlStr = urlStr;
            request.paramMap = paramMap;
            return request;
        }

        private HttpRequest() {
            this.id = cntID++;
        }

        public long getID() {
            return this.id;
        }

        public HttpRequest setListener(HttpListener newListener) {
            this.listener = newListener;
            return this;
        }

        public HttpRequest setMethod(METHOD method) {
            if (method != null) {
                this.method = method;
            }
            return this;
        }

        public HttpRequest setCharset(Charset charset) {
            if (charset != null) {
                this.charset = charset;
            }
            return this;
        }

        public HttpRequest setTimeout(int timeout) {
            if (timeout > 0) {
                this.timeout = timeout;
            }
            return this;
        }

        public HttpRequest setCharset(String charsetName) {
            if (charsetName != null) {
                this.charset = Charset.forName(charsetName);
            }
            return this;
        }

        public void send() {
            this.start();
        }

        @Override
        public void run() {
            HttpResponse response = METHOD.POST == this.method ? ToolHttp.post(this.urlStr, this.paramMap, this.charset, this.timeout) : ToolHttp.get(this.urlStr, this.paramMap, this.charset, this.timeout);
            if (this.listener != null) {
                if (response.ex == null) {
                    if (response.code == 200) {
                        this.listener.onData(this, response.text);
                    } else {
                        this.listener.onError(this, response.code);
                    }
                } else {
                    this.listener.onException(response.ex);
                }
            }
        }
    }

    public static interface HttpListener {
        public void onData(HttpRequest var1, String var2);

        public void onError(HttpRequest var1, int var2);

        public void onException(Exception var1);
    }

    public static enum METHOD {
        GET,
        POST;

    }
}

