/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.str;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class StrExpr {
    private String exprStr;
    private boolean ignoreCase;
    private HashMap<String, Double> varMap;
    private HashMap<String, Func> funcMap;
    private ComputeNode computeTree;

    public StrExpr(String exprStr) throws ExprException {
        this.exprStr = exprStr;
        this.ignoreCase = true;
        this.varMap = new HashMap();
        this.funcMap = new HashMap();
        this.computeTree = this.createTree(exprStr);
        this.computeTree = this.optimizeTree(this.computeTree);
    }

    public StrExpr(String exprStr, boolean ignoreCase) throws ExprException {
        this.exprStr = exprStr;
        this.ignoreCase = ignoreCase;
        this.varMap = new HashMap();
        this.funcMap = new HashMap();
        this.computeTree = this.createTree(exprStr);
        this.computeTree = this.optimizeTree(this.computeTree);
    }

    public String getExprStr() {
        return this.exprStr;
    }

    public Set<String> getVars() {
        return this.varMap.keySet();
    }

    public Double setVar(String name, Double val) throws ExprException {
        return this.setVar(name, val, false);
    }

    public Double setVar(String name, Double val, boolean check) throws ExprException {
        if (this.ignoreCase) {
            name = name.toLowerCase();
        }
        if (this.varMap.containsKey(name)) {
            return this.varMap.put(name, val);
        }
        if (check) {
            throw new ExprException(ExprException.NUM.UNKNOW_VAR, ExprException.NUM.UNKNOW_VAR.getDefaultMsg() + ":" + name);
        }
        return null;
    }

    public Double getVar(String name) {
        if (this.ignoreCase) {
            name = name.toLowerCase();
        }
        return this.varMap.get(name);
    }

    public Set<String> getFuncs() {
        return this.funcMap.keySet();
    }

    private String fixFuncName(String name) {
        return name.endsWith("(") ? name : name + "(";
    }

    public Func setFunc(String name, Func func) throws ExprException {
        return this.setFunc(name, func, false);
    }

    public Func setFunc(String name, Func func, boolean check) throws ExprException {
        if (this.ignoreCase) {
            name = name.toLowerCase();
        }
        if (this.funcMap.containsKey(name = this.fixFuncName(name))) {
            return this.funcMap.put(name, func);
        }
        if (check) {
            throw new ExprException(ExprException.NUM.UNKNOW_FUNC, ExprException.NUM.UNKNOW_FUNC.getDefaultMsg() + ":" + name);
        }
        return null;
    }

    public Func getFunc(String name) {
        if (this.ignoreCase) {
            name = name.toLowerCase();
        }
        return this.funcMap.get(this.fixFuncName(name));
    }

    public double compute() throws ExprException {
        return this.compute(this.computeTree, null);
    }

    public double computeX(String varsStr) throws ExprException {
        if (varsStr != null) {
            String[] varStrs;
            HashMap<String, Double> vars = new HashMap<String, Double>();
            for (String varStr : varStrs = varsStr.split(",")) {
                String[] varParams = varStr.split("=");
                if (varParams.length != 2) continue;
                try {
                    String varName = varParams[0].trim();
                    double varValue = Double.parseDouble(varParams[1].trim());
                    if (varName.isEmpty()) continue;
                    vars.put(varName, varValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.compute(this.computeTree, vars);
        }
        return this.compute();
    }

    public double computeX(HashMap<String, Double> vars) throws ExprException {
        return this.compute(this.computeTree, vars);
    }

    private double compute(ComputeNode root, HashMap<String, Double> vars) throws ExprException {
        int sig;
        int n = sig = root.negative ? -1 : 1;
        if (root.params != null) {
            boolean in;
            double[] params = new double[root.params.size()];
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.compute(root.params.get(i), vars);
            }
            if (root.str.equals("+")) {
                this.checkParamLength(root.str, params, 2);
                return (double)sig * (params[0] + params[1]);
            }
            if (root.str.equals("-")) {
                this.checkParamLength(root.str, params, 2);
                return (double)sig * (params[0] - params[1]);
            }
            if (root.str.equals("*")) {
                this.checkParamLength(root.str, params, 2);
                return (double)sig * (params[0] * params[1]);
            }
            if (root.str.equals("/")) {
                this.checkParamLength(root.str, params, 2);
                try {
                    return (double)sig * (params[0] / params[1]);
                }
                catch (Exception ex) {
                    throw new ExprException(ExprException.NUM.COMPUTE_EXCEPTION, ExprException.NUM.COMPUTE_EXCEPTION.getDefaultMsg() + ":" + ex.getMessage());
                }
            }
            if (root.str.equals("^")) {
                this.checkParamLength(root.str, params, 2);
                return (double)sig * Math.pow(params[0], params[1]);
            }
            if (root.str.equals("abs(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.abs(params[0]);
            }
            if (root.str.equals("sin(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.sin(params[0]);
            }
            if (root.str.equals("cos(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.cos(params[0]);
            }
            if (root.str.equals("tan(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.tan(params[0]);
            }
            if (root.str.equals("asin(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.asin(params[0]);
            }
            if (root.str.equals("acos(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.acos(params[0]);
            }
            if (root.str.equals("atan(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.atan(params[0]);
            }
            if (root.str.equals("exp(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.exp(params[0]);
            }
            if (root.str.equals("ln(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.log(params[0]);
            }
            if (root.str.equals("log(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.log10(params[0]);
            }
            if (root.str.equals("sqrt(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.sqrt(params[0]);
            }
            if (root.str.equals("pow(")) {
                this.checkParamLength(root.str, params, 2);
                return (double)sig * Math.pow(params[0], params[1]);
            }
            if (root.str.equals("min(")) {
                this.checkParamMinLength(root.str, params, 1);
                double minVal = params[0];
                for (int i = 1; i < params.length; ++i) {
                    minVal = Math.min(minVal, params[i]);
                }
                return (double)sig * minVal;
            }
            if (root.str.equals("max(")) {
                this.checkParamMinLength(root.str, params, 1);
                double maxVal = params[0];
                for (int i = 1; i < params.length; ++i) {
                    maxVal = Math.max(maxVal, params[i]);
                }
                return (double)sig * maxVal;
            }
            if (root.str.equals("signum(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.signum(params[0]);
            }
            if (root.str.equals("round(")) {
                this.checkParamLength(root.str, params, 1);
                return (long)sig * Math.round(params[0]);
            }
            if (root.str.equals("ceil(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.ceil(params[0]);
            }
            if (root.str.equals("floor(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.floor(params[0]);
            }
            if (root.str.equals("random(")) {
                this.checkParamMaxLength(root.str, params, 1);
                double randomVal = Math.random();
                if (params.length == 1) {
                    randomVal *= params[0];
                }
                return (double)sig * randomVal;
            }
            if (root.str.equals("degrees(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.toDegrees(params[0]);
            }
            if (root.str.equals("radians(")) {
                this.checkParamLength(root.str, params, 1);
                return (double)sig * Math.toRadians(params[0]);
            }
            if (root.str.equals("div(")) {
                this.checkParamLength(root.str, params, 2);
                long divA = (long)params[0];
                long divB = (long)params[1];
                long divVal = divA / divB;
                return (double)sig * (double)divVal;
            }
            if (root.str.equals("mod(")) {
                this.checkParamLength(root.str, params, 2);
                long divA = (long)params[0];
                long divB = (long)params[1];
                long divVal = divA % divB;
                return (double)sig * (double)divVal;
            }
            if (root.str.equals("in(")) {
                this.checkParamLength(root.str, params, 3);
                in = params[0] >= params[1] && params[0] < params[2];
                return (double)sig * (in ? 1.0 : 0.0);
            }
            if (root.str.equals("out(")) {
                this.checkParamLength(root.str, params, 3);
                in = params[0] >= params[1] && params[0] < params[2];
                return (double)sig * (in ? 0.0 : 1.0);
            }
            if (root.str.equals("more(")) {
                this.checkParamLength(root.str, params, 2);
                in = params[0] >= params[1];
                return (double)sig * (in ? 1.0 : 0.0);
            }
            if (root.str.equals("less(")) {
                this.checkParamLength(root.str, params, 2);
                in = params[0] < params[1];
                return (double)sig * (in ? 1.0 : 0.0);
            }
            if (root.str.endsWith("(")) {
                Func func = this.funcMap.get(root.str);
                if (func == null) {
                    throw new ExprException(ExprException.NUM.UNSET_FUNC, ExprException.NUM.UNSET_FUNC.getDefaultMsg() + ":" + root.str);
                }
                return (double)sig * func.compute(params);
            }
            throw new ExprException(ExprException.NUM.UNRECOGNIZABLE_OPER_SYM, ExprException.NUM.UNRECOGNIZABLE_OPER_SYM.getDefaultMsg() + ":" + root.str);
        }
        if (root.str != null) {
            Double val = null;
            if (vars != null && vars.containsKey(root.str)) {
                val = vars.get(root.str);
            }
            if (val == null) {
                val = this.varMap.get(root.str);
            }
            if (val == null) {
                throw new ExprException(ExprException.NUM.UNSET_VAR, ExprException.NUM.UNSET_VAR.getDefaultMsg() + ":" + root.str);
            }
            return (double)sig * val;
        }
        return (double)sig * root.val;
    }

    private void checkParamLength(String name, double[] params, int need) throws ExprException {
        if (params.length != need) {
            throw new ExprException(ExprException.NUM.COMPUTE_PARAM_NOT_MATCH, ExprException.NUM.COMPUTE_PARAM_NOT_MATCH.getDefaultMsg() + ":" + name + " need " + need + " parameter(s),but found " + params.length);
        }
    }

    private void checkParamMinLength(String name, double[] params, int min) throws ExprException {
        if (params.length < min) {
            throw new ExprException(ExprException.NUM.COMPUTE_PARAM_NOT_MATCH, ExprException.NUM.COMPUTE_PARAM_NOT_MATCH.getDefaultMsg() + ":" + name + " need at least " + min + " parameter(s),but found " + params.length);
        }
    }

    private void checkParamMaxLength(String name, double[] params, int max) throws ExprException {
        if (params.length > max) {
            throw new ExprException(ExprException.NUM.COMPUTE_PARAM_NOT_MATCH, ExprException.NUM.COMPUTE_PARAM_NOT_MATCH.getDefaultMsg() + ":" + name + " need at most " + max + " parameter(s),but found " + params.length);
        }
    }

    private ComputeNode createTree(String exprStr) throws ExprException {
        ArrayList<ComputeNode> numStack = new ArrayList<ComputeNode>();
        ArrayList<ComputeNode> symStack = new ArrayList<ComputeNode>();
        StringBuilder buff = new StringBuilder();
        exprStr = Str.fixExprStr(exprStr, true);
        if (this.ignoreCase) {
            exprStr = exprStr.toLowerCase();
        }
        boolean newStart = true;
        boolean negative = false;
        for (int i = 0; i < exprStr.length(); ++i) {
            char ch = exprStr.charAt(i);
            if (newStart && ch == '-') {
                if (negative) {
                    throw new ExprException(ExprException.NUM.UNEXCEPT_NEGATIVE_SYM);
                }
                negative = true;
                continue;
            }
            newStart = false;
            if (Str.isSymCut(ch)) {
                if (buff.length() != 0) {
                    if (ch == '(') {
                        char nextCh;
                        ComputeNode node = new ComputeNode();
                        node.str = Str.testFuncName(buff.toString()) + "(";
                        if (!Str.isSysFunc(node.str) && !this.funcMap.containsKey(node.str)) {
                            this.funcMap.put(node.str, null);
                        }
                        node.operCnt = (nextCh = exprStr.charAt(i + 1)) == ')' ? 0 : 1;
                        node.negative = negative;
                        this.pushSym(numStack, symStack, node);
                        buff = new StringBuilder();
                        negative = false;
                        newStart = true;
                        continue;
                    }
                    this.pushNum(numStack, buff.toString(), negative);
                    buff = new StringBuilder();
                    negative = false;
                }
                if (Str.isSymOper2(ch)) {
                    ComputeNode symNode = new ComputeNode();
                    symNode.str = Character.toString(ch);
                    symNode.operCnt = 2;
                    this.pushSym(numStack, symStack, symNode);
                    continue;
                }
                if (ch == '(') {
                    ComputeNode symNode = new ComputeNode();
                    symNode.str = Character.toString(ch);
                    this.pushSym(numStack, symStack, symNode);
                    newStart = true;
                    continue;
                }
                if (ch == ')') {
                    boolean matchFunction = false;
                    while (!symStack.isEmpty()) {
                        ComputeNode symNode = symStack.get(symStack.size() - 1);
                        if (symNode.str.equals("(")) {
                            matchFunction = false;
                            break;
                        }
                        if (symNode.str.endsWith("(")) {
                            matchFunction = true;
                            break;
                        }
                        this.computeStack(numStack, symStack);
                    }
                    if (symStack.isEmpty()) {
                        throw new ExprException(ExprException.NUM.NO_MATCH_BRACKET, ExprException.NUM.NO_MATCH_BRACKET.getDefaultMsg());
                    }
                    if (matchFunction) {
                        this.computeStack(numStack, symStack);
                        continue;
                    }
                    symStack.remove(symStack.size() - 1);
                    continue;
                }
                if (ch == ',') {
                    while (!symStack.isEmpty()) {
                        ComputeNode symNode = symStack.get(symStack.size() - 1);
                        if (symNode.str.endsWith("(")) break;
                        this.computeStack(numStack, symStack);
                    }
                    if (symStack.isEmpty()) {
                        throw new ExprException(ExprException.NUM.MISSING_FUNCTION, ExprException.NUM.MISSING_FUNCTION.getDefaultMsg());
                    }
                    ++symStack.get((int)(symStack.size() - 1)).operCnt;
                    newStart = true;
                    continue;
                }
                throw new ExprException(ExprException.NUM.BAD_OPER_SYM, ExprException.NUM.BAD_OPER_SYM.getDefaultMsg() + ":" + ch);
            }
            buff.append(ch);
        }
        if (buff.length() > 0) {
            this.pushNum(numStack, buff.toString(), negative);
        }
        while (!symStack.isEmpty()) {
            this.computeStack(numStack, symStack);
        }
        if (numStack.isEmpty()) {
            throw new ExprException(ExprException.NUM.NO_RESULT);
        }
        if (numStack.size() > 1) {
            throw new ExprException(ExprException.NUM.MORE_RESULT);
        }
        return numStack.get(0);
    }

    private ComputeNode optimizeTree(ComputeNode root) throws ExprException {
        if (root.params == null) {
            return root;
        }
        for (int i = 0; i < root.params.size(); ++i) {
            root.params.set(i, this.optimizeTree(root.params.get(i)));
        }
        for (ComputeNode child : root.params) {
            if (child.params == null && child.str == null) continue;
            return root;
        }
        if (root.str.endsWith("(") && !Str.isSysFunc(root.str)) {
            return root;
        }
        if ("random(".equals(root.str)) {
            return root;
        }
        ComputeNode newNode = new ComputeNode();
        newNode.val = this.compute(root, null);
        return newNode;
    }

    private void pushNum(ArrayList<ComputeNode> numStack, String numStr, boolean negative) throws ExprException {
        ComputeNode numNode = new ComputeNode();
        numNode.str = numStr;
        numNode.negative = negative;
        if (Str.isNum(numStr.charAt(0))) {
            try {
                numNode.val = Double.parseDouble(numStr);
                numNode.str = null;
            }
            catch (NumberFormatException ex) {
                throw new ExprException(ExprException.NUM.BAD_NUMBER, ExprException.NUM.BAD_NUMBER.getDefaultMsg() + ":" + numStr);
            }
        } else if ("e".equals(numStr)) {
            numNode.val = Math.E;
            numNode.str = null;
        } else if ("pi".equals(numStr)) {
            numNode.val = Math.PI;
            numNode.str = null;
        } else {
            Str.testVarName(numStr);
            if (!this.varMap.containsKey(numStr)) {
                this.varMap.put(numStr, null);
            }
        }
        numStack.add(numNode);
    }

    private void pushSym(ArrayList<ComputeNode> numStack, ArrayList<ComputeNode> symStack, ComputeNode symNode) throws ExprException {
        while (!symStack.isEmpty()) {
            ComputeNode symTopNode = symStack.get(symStack.size() - 1);
            if (StrExpr.getInStackLevel(symTopNode.str) < StrExpr.getOutStackLevel(symNode.str)) break;
            this.computeStack(numStack, symStack);
        }
        symStack.add(symNode);
    }

    private void computeStack(ArrayList<ComputeNode> numStack, ArrayList<ComputeNode> symStack) throws ExprException {
        int i;
        if (symStack.isEmpty()) {
            throw new ExprException(ExprException.NUM.MISSING_OPER_SYM);
        }
        ComputeNode symNode = symStack.remove(symStack.size() - 1);
        int numStackSize = numStack.size();
        if (numStackSize < symNode.operCnt) {
            throw new ExprException(ExprException.NUM.MISSING_OPER_NUM);
        }
        symNode.params = new ArrayList(symNode.operCnt);
        for (i = 0; i < symNode.operCnt; ++i) {
            symNode.params.add(numStack.get(numStackSize - symNode.operCnt + i));
        }
        for (i = 0; i < symNode.operCnt; ++i) {
            numStack.remove(numStack.size() - 1);
        }
        numStack.add(symNode);
    }

    private static int getInStackLevel(String symStr) {
        if (symStr.equals("(")) {
            return 0;
        }
        if (symStr.equals("+") || symStr.equals("-")) {
            return 2;
        }
        if (symStr.equals("*") || symStr.equals("/")) {
            return 4;
        }
        if (symStr.equals("^")) {
            return 6;
        }
        if (symStr.endsWith("(")) {
            return 0;
        }
        return -1;
    }

    private static int getOutStackLevel(String symStr) {
        if (symStr.equals("(")) {
            return 9;
        }
        if (symStr.equals("+") || symStr.equals("-")) {
            return 1;
        }
        if (symStr.equals("*") || symStr.equals("/")) {
            return 3;
        }
        if (symStr.equals("^")) {
            return 5;
        }
        if (symStr.endsWith("(")) {
            return 9;
        }
        return -1;
    }

    public static double compute(String expr) throws ExprException {
        return new StrExpr(expr).compute();
    }

    private static class ComputeNode {
        public String str = null;
        public double val = Double.NaN;
        public int operCnt = 0;
        public boolean negative = false;
        public ArrayList<ComputeNode> params = null;

        private ComputeNode() {
        }
    }

    private static class Str {
        private static final char[] EnLowerSBC = new char[]{'\uff41', '\uff42', '\uff43', '\uff44', '\uff45', '\uff46', '\uff47', '\uff48', '\uff49', '\uff4a', '\uff4b', '\uff4c', '\uff4d', '\uff4e', '\uff4f', '\uff50', '\uff51', '\uff52', '\uff53', '\uff54', '\uff55', '\uff56', '\uff57', '\uff58', '\uff59', '\uff5a'};
        private static final char[] EnUpperSBC = new char[]{'\uff21', '\uff22', '\uff23', '\uff24', '\uff25', '\uff26', '\uff27', '\uff28', '\uff29', '\uff2a', '\uff2b', '\uff2c', '\uff2d', '\uff2e', '\uff2f', '\uff30', '\uff31', '\uff32', '\uff33', '\uff34', '\uff35', '\uff36', '\uff37', '\uff38', '\uff39', '\uff3a'};
        private static final char[] NumSBC = new char[]{'\uff10', '\uff11', '\uff12', '\uff13', '\uff14', '\uff15', '\uff16', '\uff17', '\uff18', '\uff19'};
        private static final char[] SymSBC = new char[]{'\uff0b', '\uff0d', '\uff0a', '\uff0f', '\uff08', '\uff09', '\uff0e', '\uff0c', '\u00d7', '\u00f7'};
        private static final char[] SymDBC = new char[]{'+', '-', '*', '/', '(', ')', '.', ',', '*', '/'};
        private static final String LEGAL_CHARS = "+-*/^().,";
        private static final String SYM_CUT = "+-*/^(),";
        private static final String SYM_OPER2 = "+-*/^";
        private static final String[] SYS_FUNC = new String[]{"abs(", "sin(", "cos(", "tan(", "asin(", "acos(", "atan(", "exp(", "ln(", "log(", "sqrt(", "pow(", "min(", "max(", "signum(", "round(", "ceil(", "floor(", "random(", "degrees(", "radians(", "div(", "mod(", "in(", "out(", "more(", "less("};

        private Str() {
        }

        public static String fixExprStr(String str, boolean delSpace) throws ExprException {
            if (str == null || str.isEmpty()) {
                throw new ExprException(ExprException.NUM.EXPR_MISSING);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (delSpace && (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n')) continue;
                if (ch >= EnLowerSBC[0] && ch <= EnLowerSBC[EnLowerSBC.length - 1]) {
                    ch = (char)(ch - EnLowerSBC[0] + 97);
                } else if (ch >= EnUpperSBC[0] && ch <= EnUpperSBC[EnUpperSBC.length - 1]) {
                    ch = (char)(ch - EnUpperSBC[0] + 65);
                } else if (ch >= NumSBC[0] && ch <= NumSBC[NumSBC.length - 1]) {
                    ch = (char)(ch - NumSBC[0] + 48);
                } else {
                    for (int j = 0; j < SymSBC.length && j < SymDBC.length; ++j) {
                        if (ch != SymSBC[j]) continue;
                        ch = SymDBC[j];
                        break;
                    }
                }
                boolean unrecognizable = true;
                if (ch >= 'a' && ch <= 'z') {
                    unrecognizable = false;
                } else if (ch >= 'A' && ch <= 'Z') {
                    unrecognizable = false;
                } else if (ch >= '0' && ch <= '9') {
                    unrecognizable = false;
                } else if (LEGAL_CHARS.indexOf(ch) >= 0) {
                    unrecognizable = false;
                }
                if (unrecognizable) {
                    throw new ExprException(ExprException.NUM.UNRECOGNIZABLE_CHAR, ExprException.NUM.UNRECOGNIZABLE_CHAR.getDefaultMsg() + " '" + ch + "'");
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        public static boolean isSymCut(char ch) {
            return SYM_CUT.indexOf(ch) >= 0;
        }

        public static boolean isSymOper2(char ch) {
            return SYM_OPER2.indexOf(ch) >= 0;
        }

        public static boolean isSysFunc(String func) {
            for (String sysFunc : SYS_FUNC) {
                if (!sysFunc.equals(func)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLetter(char ch) {
            return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
        }

        public static boolean isNum(char ch) {
            return ch >= '0' && ch <= '9';
        }

        public static String testFuncName(String name) throws ExprException {
            if (name == null || name.length() == 0) {
                throw new ExprException(ExprException.NUM.BAD_FUNC_NAME, ExprException.NUM.BAD_FUNC_NAME.getDefaultMsg() + ":" + name);
            }
            if (!Str.isLetter(name.charAt(0))) {
                throw new ExprException(ExprException.NUM.BAD_FUNC_NAME, ExprException.NUM.BAD_FUNC_NAME.getDefaultMsg() + ":" + name + ",should start with a letter");
            }
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Str.isLetter(ch) || Str.isNum(ch)) continue;
                throw new ExprException(ExprException.NUM.BAD_FUNC_NAME, ExprException.NUM.BAD_FUNC_NAME.getDefaultMsg() + ":" + name + ",should use only english letter or number letter");
            }
            return name;
        }

        public static String testVarName(String name) throws ExprException {
            if (name == null || name.length() == 0) {
                throw new ExprException(ExprException.NUM.BAD_VAR_NAME, ExprException.NUM.BAD_VAR_NAME.getDefaultMsg() + ":" + name);
            }
            if (!Str.isLetter(name.charAt(0))) {
                throw new ExprException(ExprException.NUM.BAD_VAR_NAME, ExprException.NUM.BAD_VAR_NAME.getDefaultMsg() + ":" + name + ",should start with a letter");
            }
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Str.isLetter(ch) || Str.isNum(ch)) continue;
                throw new ExprException(ExprException.NUM.BAD_VAR_NAME, ExprException.NUM.BAD_VAR_NAME.getDefaultMsg() + ":" + name + ",should use only english letter or number letter");
            }
            return name;
        }
    }

    public static interface Func {
        public double compute(double[] var1);
    }

    public static class ExprException
    extends Exception {
        public NUM num;
        public String msg;

        public ExprException(NUM num) {
            this.num = num;
            this.msg = ExprException.getDefaultMsg(num);
        }

        public ExprException(NUM num, String msg) {
            this.num = num;
            this.msg = msg;
        }

        public static String getDefaultMsg(NUM num) {
            if (num == null) {
                return NUM.UNKNOW_ERROR.getDefaultMsg();
            }
            return num.getDefaultMsg();
        }

        @Override
        public String toString() {
            return this.msg;
        }

        public static enum NUM {
            EXPR_MISSING,
            UNRECOGNIZABLE_CHAR,
            UNEXCEPT_NEGATIVE_SYM,
            MISSING_OPER_SYM,
            MISSING_OPER_NUM,
            BAD_FUNC_NAME,
            BAD_VAR_NAME,
            BAD_NUMBER,
            BAD_OPER_SYM,
            NO_MATCH_BRACKET,
            MISSING_FUNCTION,
            NO_RESULT,
            MORE_RESULT,
            UNKNOW_VAR,
            UNKNOW_FUNC,
            UNSET_VAR,
            UNSET_FUNC,
            COMPUTE_PARAM_NOT_MATCH,
            UNRECOGNIZABLE_OPER_SYM,
            COMPUTE_EXCEPTION,
            UNKNOW_ERROR;


            public String getDefaultMsg() {
                switch (this) {
                    case EXPR_MISSING: {
                        return "expression missing";
                    }
                    case UNRECOGNIZABLE_CHAR: {
                        return "unrecognizable character";
                    }
                    case UNEXCEPT_NEGATIVE_SYM: {
                        return "unexcept negative symbol";
                    }
                    case MISSING_OPER_SYM: {
                        return "missing operating symbol";
                    }
                    case MISSING_OPER_NUM: {
                        return "missing operating number";
                    }
                    case BAD_FUNC_NAME: {
                        return "bad function name";
                    }
                    case BAD_VAR_NAME: {
                        return "bad variable name";
                    }
                    case BAD_NUMBER: {
                        return "bad number";
                    }
                    case BAD_OPER_SYM: {
                        return "bad operating symbol";
                    }
                    case NO_MATCH_BRACKET: {
                        return "right bracket find no match left bracket";
                    }
                    case MISSING_FUNCTION: {
                        return "missing function";
                    }
                    case NO_RESULT: {
                        return "no result";
                    }
                    case MORE_RESULT: {
                        return "more result";
                    }
                    case UNSET_VAR: {
                        return "unset variable";
                    }
                    case UNSET_FUNC: {
                        return "unset function";
                    }
                    case UNKNOW_VAR: {
                        return "unknow variable";
                    }
                    case UNKNOW_FUNC: {
                        return "unknow function";
                    }
                    case COMPUTE_PARAM_NOT_MATCH: {
                        return "compute parameter not match";
                    }
                    case UNRECOGNIZABLE_OPER_SYM: {
                        return "unrecognizable operating symbol";
                    }
                    case COMPUTE_EXCEPTION: {
                        return "compute expcetion";
                    }
                }
                return "unknow error";
            }
        }
    }
}

