/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.str;

public class StrConvert {
    public static final String MAP_BIN = "01";
    public static final String MAP_OCT = "01234567";
    public static final String MAP_DEC = "0123456789";
    public static final String MAP_HEX = "0123456789abcdef";
    public static final String MAP_NUM = "0123456789";
    public static final String MAP_LETTER = "abcdefghijklmnopqrstuvwxyz";
    public static final String MAP_ALL = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static String convert(String str, String src, String dest) {
        int partMod;
        if (str == null || src == null || dest == null || str.isEmpty() || src.isEmpty() || dest.isEmpty()) {
            return null;
        }
        int modSrc = src.length();
        int length = (int)Math.ceil((double)str.length() * Math.log(modSrc) / Math.log(10.0));
        ConvertInt sum = new ConvertInt(length);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            int num = Math.max(src.indexOf(ch), 0);
            for (int j = 0; j < length; ++j) {
                int n = j;
                sum.nums[n] = sum.nums[n] * modSrc;
                if (j == 0) {
                    int n2 = j;
                    sum.nums[n2] = sum.nums[n2] + num;
                } else {
                    int n3 = j;
                    sum.nums[n3] = sum.nums[n3] + sum.nums[j - 1] / 10;
                    sum.nums[j - 1] = sum.nums[j - 1] % 10;
                }
                if (sum.nums[j] == 0) continue;
                sum.bits = j + 1;
            }
            sum.nums[length - 1] = sum.nums[length - 1] % 10;
        }
        int modDest = dest.length();
        int lenDest = StrConvert.getLen(modDest);
        String result = "";
        while (StrConvert.compareVal(sum, modDest, lenDest)) {
            partMod = StrConvert.divideSum(sum, modDest);
            result = dest.charAt(partMod) + result;
        }
        partMod = StrConvert.getVal(sum);
        result = dest.charAt(partMod) + result;
        return result;
    }

    public static String convertInt(int val, String map) {
        return StrConvert.convert(Integer.toString(val), "0123456789", map);
    }

    public static int convertIntBack(String str, String map) {
        return Integer.parseInt(StrConvert.convert(str, map, "0123456789"));
    }

    public static String convertLong(long val, String map) {
        return StrConvert.convert(Long.toString(val), "0123456789", map);
    }

    public static long convertLongBack(String str, String map) {
        return Long.parseLong(StrConvert.convert(str, map, "0123456789"));
    }

    private static int divideSum(ConvertInt sum, int val) {
        int part = 0;
        for (int i = sum.bits - 1; i >= 0; --i) {
            part = part * 10 + sum.nums[i];
            sum.nums[i] = part / val;
            part %= val;
            if (sum.nums[i] != 0 || sum.bits != i + 1) continue;
            sum.bits = i;
        }
        return part;
    }

    private static boolean compareVal(ConvertInt val, int val2, int len) {
        if (val.bits > len) {
            return true;
        }
        int sum = 0;
        for (int i = val.bits - 1; i >= 0 && i < val.nums.length; --i) {
            sum = sum * 10 + val.nums[i];
        }
        return sum >= val2;
    }

    private static int getVal(ConvertInt val) {
        int sum = 0;
        for (int i = val.bits - 1; i >= 0; --i) {
            sum = sum * 10 + val.nums[i];
        }
        return sum;
    }

    private static int getLen(int val) {
        int len = 0;
        int num = val;
        while (num > 0) {
            num /= 10;
            ++len;
        }
        return len;
    }

    private static class ConvertInt {
        public int[] nums;
        public int bits;

        public ConvertInt(int length) {
            this.nums = new int[length];
            this.bits = 0;
            for (int i = 0; i < length; ++i) {
                this.nums[i] = 0;
            }
        }
    }
}

