/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.servlet;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.resource.ResServlet;
import com.modnut.framework2.servlet.ServletSolver;
import com.modnut.framework2.tool.ToolStr;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;

public abstract class ServletDownloadSolver<RC extends ResServlet>
extends ServletSolver<RC> {
    protected static final int BUFF_SIZE = 4096;
    private static final MimetypesFileTypeMap mime = new MimetypesFileTypeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getMimetype(File file) {
        MimetypesFileTypeMap mimetypesFileTypeMap = mime;
        synchronized (mimetypesFileTypeMap) {
            return mime.getContentType(file);
        }
    }

    public ServletDownloadSolver(RC res) {
        super(res);
    }

    @Override
    public void doInit() throws ServletException {
        this.setRequestCharacterEncoding();
        this.setResponseCache();
    }

    @Override
    public void doSolve() throws ServletException {
        try {
            this.doDownload(this.getFile());
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected abstract File getFile() throws ServletException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDownload(File file) throws IOException {
        long since = 0L;
        long until = file.length() - 1L;
        String range = ((ResServlet)this.getRes()).getRequest().getHeader("range");
        if (range != null) {
            range = range.split("=")[1];
            String[] rs = range.split("-");
            since = ToolStr.parseLong(rs[0], since);
            if (rs.length > 1) {
                until = ToolStr.parseLong(rs[1], until);
            }
            ((ResServlet)this.getRes()).getResponse().setStatus(206);
        } else {
            ((ResServlet)this.getRes()).getResponse().setStatus(200);
        }
        String contentType = ServletDownloadSolver.getMimetype(file);
        contentType = contentType == null ? "application/octet-stream" : contentType;
        ((ResServlet)this.getRes()).getResponse().setHeader("Content-Type", contentType);
        ((ResServlet)this.getRes()).getResponse().setContentType(contentType);
        if (this.hasAttachment()) {
            String newName = this.getRename();
            newName = newName == null ? file.getName() : newName;
            ((ResServlet)this.getRes()).getResponse().setHeader("Content-Disposition", "attachment; filename=\"" + new String(newName.getBytes(ConstFramework.getCharset()), "ISO8859_1") + "\"");
        }
        ((ResServlet)this.getRes()).getResponse().setHeader("Accept-Ranges", "bytes");
        ((ResServlet)this.getRes()).getResponse().setHeader("Content-Range", "bytes " + since + "-" + until + "/" + file.length());
        ((ResServlet)this.getRes()).getResponse().setHeader("Content-Length", "" + (until - since + 1L));
        ((ResServlet)this.getRes()).getResponse().setContentLength((int)(until - since + 1L));
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)((ResServlet)this.getRes()).getResponse().getOutputStream());
            try {
                int len;
                if (since > 0L) {
                    is.skip(since);
                }
                byte[] buf = new byte[4096];
                int left = (int)(until - since + 1L);
                while ((len = is.read(buf)) > 0) {
                    if ((left -= len) > 0) {
                        os.write(buf, 0, len);
                        continue;
                    }
                    os.write(buf, 0, len + left);
                    break;
                }
            }
            finally {
                os.flush();
                os.close();
            }
        }
        finally {
            is.close();
            ((ResServlet)this.getRes()).getResponse().flushBuffer();
        }
    }

    protected String getRename() {
        return null;
    }

    protected boolean hasAttachment() {
        return false;
    }

    static {
        mime.addMimeTypes("text/plain txt");
        mime.addMimeTypes("text/html htm html xhtml jsp php");
        mime.addMimeTypes("text/css css");
        mime.addMimeTypes("text/javascript js");
        mime.addMimeTypes("text/xml xml");
        mime.addMimeTypes("text/csv csv");
        mime.addMimeTypes("text/asp asp");
        mime.addMimeTypes("text/richtext rtx");
        mime.addMimeTypes("application/msword doc");
        mime.addMimeTypes("application/vnd.ms-excel xls");
        mime.addMimeTypes("application/pdf pdf");
        mime.addMimeTypes("application/vnd.openxmlformats-officedocument.wordprocessingml.document docx");
        mime.addMimeTypes("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet xlsx");
        mime.addMimeTypes("application/vnd.rn-realmedia rm");
        mime.addMimeTypes("application/vnd.rn-realmedia-vbr rmvb");
        mime.addMimeTypes("application/zip zip");
        mime.addMimeTypes("application/x-tar tar");
        mime.addMimeTypes("image/jpeg jpeg jpg jpe");
        mime.addMimeTypes("image/gif gif");
        mime.addMimeTypes("image/png png");
        mime.addMimeTypes("image/bmp bmp");
        mime.addMimeTypes("image/tiff tif tiff");
        mime.addMimeTypes("image/x-icon ico");
        mime.addMimeTypes("audio/amr amr");
        mime.addMimeTypes("audio/basic au");
        mime.addMimeTypes("audio/x-ms-wma wma");
        mime.addMimeTypes("audio/midi midi mid");
        mime.addMimeTypes("audio/mp3 mp3");
        mime.addMimeTypes("audio/wav wav");
        mime.addMimeTypes("video/3gpp 3gp");
        mime.addMimeTypes("video/mpeg mpeg");
        mime.addMimeTypes("video/mp4 mp4");
        mime.addMimeTypes("video/ogg ogg");
        mime.addMimeTypes("video/webm webm");
        mime.addMimeTypes("video/vnd.rn-realvideo rv");
        mime.addMimeTypes("video/quicktime qt mov moov");
        mime.addMimeTypes("video/mpeg mpeg mpg mpe mpv vbs mpegv");
        mime.addMimeTypes("video/msvideo avi");
    }
}

