/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.servlet;

import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.resource.ResServlet;
import com.modnut.framework2.servlet.ServletSolver;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;

public abstract class ServletCaptchaSolver<RC extends ResServlet>
extends ServletSolver<RC> {
    private static final char[] CH_ARRAY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final int WIDTH = 100;
    private static final int HEIGHT = 25;
    private static final int FONT_HEIGHT_MAX = 23;
    private static final int FONT_HEIGHT_MIN = 18;
    private static final int STROKE_MAX = 3;
    private static final int STROKE_MIN = 1;
    private static final int ROT_RANGE = 45;
    private static final String[] CAPTCHA_FONT = new String[]{"Default"};
    private static final int[] CAPTCHA_STYLE = new int[]{1, 3, 0};
    private static final Color[] CAPTCHA_COLOR = new Color[]{new Color(0x7D7D7D)};
    private static final Color[] CONFUSE_COLOR1 = CAPTCHA_COLOR;
    private static final Color[] CONFUSE_COLOR2 = new Color[]{new Color(0xFFFFFF)};
    private static final String CAPTCHA_FORMAT = "GIF";
    private static final int CAPTCHA_CNT = 4;
    private static final int CONFUSE_LEVEL1 = 2;
    private static final int CONFUSE_LEVEL2 = 1;
    private static final int CHAR_WIDTH = 20;
    private static final int CAPTCHA_LEFT = 10;
    private static final int CAPTCHA_BOTTOM = 5;

    public ServletCaptchaSolver(RC res) {
        super(res);
    }

    @Override
    public void doSolve() throws ServletException {
        String captchaStr = this.createCaptchaStr();
        ((ResPack)this.getRes()).printMsg("Create Captcha:" + captchaStr);
        this.setServerCaptcha(captchaStr);
        BufferedImage image = this.createCaptchaImg(captchaStr);
        try {
            this.ouputCaptchaImg(image);
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public String createCaptchaStr() {
        Random rand = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int seed = rand.nextInt(CH_ARRAY.length);
            char ch = CH_ARRAY[seed];
            sb.append(ch);
        }
        return sb.toString();
    }

    protected BufferedImage createCaptchaImg(String captchaStr) {
        BufferedImage image = new BufferedImage(100, 25, 1);
        Graphics g = image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 100, 25);
        g.dispose();
        this.drawConfuse(image, CONFUSE_COLOR1, 2);
        this.drawCaptchaStr(image, captchaStr);
        this.drawConfuse(image, CONFUSE_COLOR2, 1);
        return image;
    }

    private void drawConfuse(BufferedImage image, Color[] colors, int level) {
        int i;
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        Random rand = new Random();
        for (i = 0; i < level; ++i) {
            int x1 = rand.nextInt(image.getWidth());
            int x2 = rand.nextInt(image.getWidth());
            int y1 = rand.nextInt(image.getHeight());
            int y2 = rand.nextInt(image.getHeight());
            g2d.setStroke(new BasicStroke((float)(rand.nextInt(2) + 1) + rand.nextFloat() - 1.0f));
            g2d.setColor(colors[rand.nextInt(colors.length)]);
            g2d.drawLine(x1, y1, x2, y2);
        }
        for (i = 0; i < level * 2; ++i) {
            int x = rand.nextInt(image.getWidth());
            int y = rand.nextInt(image.getHeight());
            int width = rand.nextInt(2) + 1;
            int height = rand.nextInt(2) + 1;
            g2d.setColor(colors[rand.nextInt(colors.length)]);
            g2d.fillRect(x, y, width, height);
        }
        g2d.dispose();
    }

    private void drawCaptchaStr(BufferedImage image, String str) {
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        Random rand = new Random();
        char[] chArr = str.toCharArray();
        for (int i = 0; i < chArr.length; ++i) {
            int rot = rand.nextInt(45) - 22;
            int left = i * 20 + 10;
            int top = image.getHeight() - 5;
            String[] fonts = CAPTCHA_FONT;
            int[] styles = CAPTCHA_STYLE;
            Color[] captchaColor = CAPTCHA_COLOR;
            g2d.setFont(new Font(fonts[rand.nextInt(fonts.length)], styles[rand.nextInt(styles.length)], rand.nextInt(5) + 18));
            g2d.translate(left, top);
            g2d.rotate(Math.PI * (double)rot / 180.0);
            g2d.setColor(captchaColor[rand.nextInt(captchaColor.length)]);
            g2d.drawChars(chArr, i, 1, 0, 0);
            g2d.rotate(-(Math.PI * (double)rot) / 180.0);
            g2d.translate(-left, -top);
        }
        g2d.dispose();
    }

    protected void ouputCaptchaImg(BufferedImage image) throws IOException {
        ServletOutputStream responseOutputStream = ((ResServlet)this.getRes()).getResponse().getOutputStream();
        try {
            ImageIO.write((RenderedImage)image, CAPTCHA_FORMAT, (OutputStream)responseOutputStream);
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        finally {
            responseOutputStream.close();
        }
    }

    protected void setServerCaptcha(String captchaStr) {
        ((ResServlet)this.getRes()).setSession(this.getCaptchaSessionName(), captchaStr);
    }

    protected abstract String getCaptchaSessionName();

    @Override
    protected void setResponseContentType() {
        ((ResServlet)this.getRes()).getResponse().setHeader("Content-Type", "image/gif");
        ((ResServlet)this.getRes()).getResponse().setContentType("image/gif");
    }
}

