/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.servlet;

import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.resource.ResServlet;
import com.modnut.framework2.servlet.ServletSolver;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ServletBase<RC extends ResServlet>
extends HttpServlet {
    protected abstract RC createRes(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract ServletSolver getSolver(RC var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.isAsync()) {
            request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
            if (request.isAsyncSupported() && !request.isAsyncStarted()) {
                AsyncContext ac = request.startAsync((ServletRequest)request, (ServletResponse)response);
                ac.setTimeout(this.getAsyncTimeout());
                ac.start((Runnable)new AsyncRunnable(ac));
            }
        } else {
            RC res = this.createRes(request, response);
            try {
                ServletSolver solver = this.getSolver(res);
                if (solver != null) {
                    try {
                        solver.doInit();
                        solver.doSolve();
                        solver.doDispose();
                    }
                    catch (ServletException ex) {
                        solver.doException(ex);
                    }
                }
            }
            finally {
                ((ResPack)res).disposeRes();
            }
        }
    }

    public boolean isAsync() {
        return false;
    }

    public long getAsyncTimeout() {
        return 300000L;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    private class AsyncRunnable
    implements Runnable {
        protected AsyncContext ac;

        public AsyncRunnable(AsyncContext ac) {
            this.ac = ac;
        }

        @Override
        public void run() {
            Object res = ServletBase.this.createRes((HttpServletRequest)this.ac.getRequest(), (HttpServletResponse)this.ac.getResponse());
            try {
                ServletSolver solver = ServletBase.this.getSolver(res);
                if (solver != null) {
                    solver.doInit();
                    solver.doSolve();
                    solver.doDispose();
                }
            }
            catch (ServletException ex) {
                Logger.getLogger(AsyncRunnable.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                ((ResPack)res).disposeRes();
                this.ac.complete();
            }
        }
    }
}

