/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.framework2.servlet;

import com.modnut.framework2.ajax.AjaxDomBase;
import com.modnut.framework2.ajax.AjaxDomException;
import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.resource.ResServlet;
import com.modnut.framework2.servlet.ServletSolver;
import com.modnut.framework2.tool.ToolClass;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;

public abstract class ServletAjaxDomSolver<RC extends ResServlet>
extends ServletSolver<RC> {
    public static final String DEFAULT_URL = "/dom";
    public static final String URL_PATTERN = "/*";
    public static final long DEBUG_DELAY = 1500L;

    public ServletAjaxDomSolver(RC res) {
        super(res);
    }

    @Override
    protected void setResponseContentType() {
        ((ResServlet)this.getRes()).getResponse().setHeader("Content-Type", "text/plain");
        ((ResServlet)this.getRes()).getResponse().setContentType("text/plain;charset=" + ((ResPack)this.getRes()).getCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSolve() throws ServletException {
        if (ConstFramework.getDebug()) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ServletAjaxDomSolver.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        PrintWriter out = ((ResServlet)this.getRes()).getWriter();
        try {
            try {
                AjaxDomBase ajax = this.build(((ResServlet)this.getRes()).getPathInfo());
                ajax.setRes(this.getRes());
                ajax.doInit();
                String outStr = ajax.getDom();
                ajax.doDispose();
                out.print(outStr);
            }
            catch (AjaxDomException ex) {
                out.print(ex.dom);
            }
        }
        finally {
            out.close();
        }
    }

    private AjaxDomBase build(String pathInfo) throws AjaxDomException {
        try {
            String ajaxName = null;
            if (pathInfo == null || !pathInfo.startsWith("/")) {
                throw new AjaxDomException("ajax name path missing");
            }
            ajaxName = pathInfo.substring(1).replace('/', '.');
            Class<?> ajaxClass = this.forName(ajaxName);
            if (ajaxClass != null && ToolClass.baseOfClass(ajaxClass, AjaxDomBase.class)) {
                return (AjaxDomBase)ajaxClass.newInstance();
            }
            throw new AjaxDomException("ajax name not accept");
        }
        catch (AjaxDomException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AjaxDomException(ex.getMessage());
        }
    }

    protected abstract Class<?> forName(String var1) throws ClassNotFoundException;
}

